!------------------------egs5_block_data_atom.f-------------------------
! Version: 051219-1435
!          060619-1800   Change expression in D-type
!          070829-1530   Change precision of DFLX1(2)
! Reference: SLAC-R-730/KEK-2005-8
!-----------------------------------------------------------------------
!23456789|123456789|123456789|123456789|123456789|123456789|123456789|12

      block data atom

      implicit none

      include 'include/egs5_h.f'               ! Main EGS5 'header' file

      include 'include/egs5_edge.f'      ! COMMONs required by EGS5 code
      include 'include/egs5_photin.f'

      integer iiz                                       ! Local variable

!-------------------------------------------------------------!
!  E-K edge energy  in KeV                                    !
!            (Table 2. of Table of Isotopes, Eighth Edition)  !
!-------------------------------------------------------------!
      DATA (EEDGE(1,IIZ),IIZ=1,100)/
     *0.13600D-01,0.24600D-01,0.54800D-01,0.11210D+00,0.18800D+00,
     *0.28380D+00,0.40160D+00,0.53200D+00,0.68540D+00,0.87010D+00,
     *0.10721D+01,0.13050D+01,0.15596D+01,0.18389D+01,0.21455D+01,
     *0.24720D+01,0.28224D+01,0.32060D+01,0.36074D+01,0.40381D+01,
     *0.44928D+01,0.49664D+01,0.54651D+01,0.59892D+01,0.65390D+01,
     *0.71120D+01,0.77089D+01,0.83328D+01,0.89789D+01,0.96586D+01,
     *0.10367D+02,0.11103D+02,0.11867D+02,0.12658D+02,0.13474D+02,
     *0.14326D+02,0.15200D+02,0.16105D+02,0.17038D+02,0.17998D+02,
     *0.18986D+02,0.20000D+02,0.21044D+02,0.22117D+02,0.23220D+02,
     *0.24350D+02,0.25514D+02,0.26711D+02,0.27940D+02,0.29200D+02,
     *0.30491D+02,0.31814D+02,0.33169D+02,0.34564D+02,0.35985D+02,
     *0.37441D+02,0.38925D+02,0.40443D+02,0.41991D+02,0.43569D+02,
     *0.45184D+02,0.46834D+02,0.48519D+02,0.50239D+02,0.51996D+02,
     *0.53789D+02,0.55618D+02,0.57486D+02,0.59390D+02,0.61332D+02,
     *0.63314D+02,0.65351D+02,0.67416D+02,0.69525D+02,0.71676D+02,
     *0.73871D+02,0.76111D+02,0.78395D+02,0.80725D+02,0.83102D+02,
     *0.85530D+02,0.88005D+02,0.90526D+02,0.93100D+02,0.95724D+02,
     *0.98397D+02,0.10113D+03,0.10392D+03,0.10676D+03,0.10965D+03,
     *0.11260D+03,0.11560D+03,0.11867D+03,0.12180D+03,0.12498D+03,
     *0.12824D+03,0.13156D+03,0.13494D+03,0.13840D+03,0.14193D+03/
!--------------------------------------------------------------!
!OMEGAK is probability of X-ray emission at K-Shell absorption !
!            (Table 3. of Table of Isotopes, Eighth Edition)   !
!--------------------------------------------------------------!
      DATA OMEGAK/
     *  0.200D-04,  0.100D-03,  0.300D-03,  0.700D-03,  0.140D-02,
     *  0.260D-02,  0.430D-02,  0.690D-02,  0.100D-01,  0.150D-01,
     *  0.210D-01,  0.290D-01,  0.390D-01,  0.500D-01,  0.640D-01,
     *  0.800D-01,  0.990D-01,  0.120D+00,  0.143D+00,  0.169D+00,
     *  0.196D+00,  0.226D+00,  0.256D+00,  0.288D+00,  0.321D+00,
     *  0.355D+00,  0.388D+00,  0.421D+00,  0.454D+00,  0.486D+00,
     *  0.517D+00,  0.546D+00,  0.575D+00,  0.602D+00,  0.628D+00,
     *  0.652D+00,  0.674D+00,  0.696D+00,  0.716D+00,  0.734D+00,
     *  0.751D+00,  0.767D+00,  0.782D+00,  0.796D+00,  0.807D+00,
     *  0.820D+00,  0.831D+00,  0.842D+00,  0.851D+00,  0.860D+00,
     *  0.868D+00,  0.875D+00,  0.882D+00,  0.888D+00,  0.894D+00,
     *  0.900D+00,  0.905D+00,  0.910D+00,  0.914D+00,  0.918D+00,
     *  0.922D+00,  0.926D+00,  0.929D+00,  0.932D+00,  0.935D+00,
     *  0.938D+00,  0.940D+00,  0.942D+00,  0.945D+00,  0.947D+00,
     *  0.949D+00,  0.950D+00,  0.952D+00,  0.954D+00,  0.955D+00,
     *  0.957D+00,  0.958D+00,  0.959D+00,  0.960D+00,  0.962D+00,
     *  0.962D+00,  0.963D+00,  0.964D+00,  0.965D+00,  0.966D+00,
     *  0.967D+00,  0.967D+00,  0.968D+00,  0.969D+00,  0.969D+00,
     *  0.970D+00,  0.970D+00,  0.971D+00,  0.971D+00,  0.971D+00,
     *  0.972D+00,  0.972D+00,  0.972D+00,  0.972D+00,  0.973D+00/
!---------------------------------------------------------------------!
!E-Alpha1 photon energy (L3--> K electron transitions).               !
!                 (Table 7 Table of Isotopes Eighth Edition)          !
!---------------------------------------------------------------------!
      DATA (EKX(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.18300D+00,
     *0.27700D+00,0.39200D+00,0.52500D+00,0.67700D+00,0.84900D+00,
     *0.10410D+01,0.12540D+01,0.14870D+01,0.17400D+01,0.20100D+01,
     *0.23080D+01,0.26220D+01,0.29570D+01,0.33140D+01,0.36920D+01,
     *0.40910D+01,0.45110D+01,0.49520D+01,0.54150D+01,0.58990D+01,
     *0.64040D+01,0.69300D+01,0.74780D+01,0.80480D+01,0.86390D+01,
     *0.92520D+01,0.98860D+01,0.10544D+02,0.11222D+02,0.11924D+02,
     *0.12651D+02,0.13395D+02,0.14165D+02,0.14958D+02,0.15775D+02,
     *0.16615D+02,0.17479D+02,0.18367D+02,0.19279D+02,0.20216D+02,
     *0.21177D+02,0.22163D+02,0.23174D+02,0.24210D+02,0.25271D+02,
     *0.26359D+02,0.27472D+02,0.28612D+02,0.29782D+02,0.30973D+02,
     *0.32194D+02,0.33442D+02,0.34720D+02,0.36026D+02,0.37361D+02,
     *0.38725D+02,0.40118D+02,0.41542D+02,0.42996D+02,0.44482D+02,
     *0.45998D+02,0.47547D+02,0.49128D+02,0.50742D+02,0.52389D+02,
     *0.54070D+02,0.55790D+02,0.57535D+02,0.59318D+02,0.61141D+02,
     *0.63000D+02,0.64896D+02,0.66831D+02,0.68806D+02,0.70818D+02,
     *0.72873D+02,0.74969D+02,0.77107D+02,0.79290D+02,0.81517D+02,
     *0.83787D+02,0.86105D+02,0.88471D+02,0.90886D+02,0.93350D+02,
     *0.95863D+02,0.98434D+02,0.10106D+03,0.10373D+03,0.10647D+03,
     *0.10927D+03,0.11212D+03,0.11503D+03,0.11801D+03,0.12106D+03/
!----------------------------------------------------------------------!
!E-Alpha2 photon energy (L2--> K electron transitions).                !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA (EKX(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.18300D+00,
     *0.27700D+00,0.39200D+00,0.52500D+00,0.67700D+00,0.84800D+00,
     *0.10410D+01,0.12540D+01,0.14860D+01,0.17390D+01,0.20090D+01,
     *0.23070D+01,0.26210D+01,0.29550D+01,0.33110D+01,0.36880D+01,
     *0.40860D+01,0.45050D+01,0.49450D+01,0.54050D+01,0.58880D+01,
     *0.63910D+01,0.69150D+01,0.74610D+01,0.80280D+01,0.86160D+01,
     *0.92250D+01,0.98550D+01,0.10508D+02,0.11182D+02,0.11878D+02,
     *0.12598D+02,0.13336D+02,0.14098D+02,0.14883D+02,0.15691D+02,
     *0.16521D+02,0.17374D+02,0.18251D+02,0.19150D+02,0.20074D+02,
     *0.21020D+02,0.21990D+02,0.22984D+02,0.24002D+02,0.25044D+02,
     *0.26111D+02,0.27202D+02,0.28317D+02,0.29461D+02,0.30625D+02,
     *0.31817D+02,0.33034D+02,0.34279D+02,0.35550D+02,0.36847D+02,
     *0.38171D+02,0.39522D+02,0.40902D+02,0.42309D+02,0.43744D+02,
     *0.45208D+02,0.46700D+02,0.48221D+02,0.49773D+02,0.51354D+02,
     *0.52965D+02,0.54611D+02,0.56280D+02,0.57981D+02,0.59718D+02,
     *0.61486D+02,0.63287D+02,0.65122D+02,0.66991D+02,0.68894D+02,
     *0.70832D+02,0.72805D+02,0.74815D+02,0.76863D+02,0.78948D+02,
     *0.81069D+02,0.83231D+02,0.85431D+02,0.87675D+02,0.89957D+02,
     *0.92282D+02,0.94654D+02,0.97069D+02,0.99525D+02,0.10203D+03,
     *0.10459D+03,0.10718D+03,0.10983D+03,0.11253D+03,0.11529D+03/
!----------------------------------------------------------------------!
!E-Alpha3 photon energy (L1--> K electron transitions).                !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA (EKX(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.21708D+02,0.22693D+02,0.23702D+02,0.24735D+02,
     *0.25793D+02,0.26875D+02,0.27981D+02,0.29112D+02,0.30270D+02,
     *0.31452D+02,0.32658D+02,0.33894D+02,0.35156D+02,0.36443D+02,
     *0.37756D+02,0.39097D+02,0.40467D+02,0.41864D+02,0.43288D+02,
     *0.44743D+02,0.46224D+02,0.47734D+02,0.49274D+02,0.50846D+02,
     *0.52443D+02,0.54080D+02,0.55735D+02,0.57425D+02,0.59150D+02,
     *0.60903D+02,0.62693D+02,0.64514D+02,0.66372D+02,0.68263D+02,
     *0.70184D+02,0.72144D+02,0.74138D+02,0.76172D+02,0.78242D+02,
     *0.80349D+02,0.82496D+02,0.84683D+02,0.86910D+02,0.89178D+02,
     *0.91491D+02,0.93844D+02,0.96242D+02,0.98687D+02,0.10117D+03,
     *0.10371D+03,0.10630D+03,0.10893D+03,0.11161D+03,0.11435D+03/
!----------------------------------------------------------------------!
!E-Beta1  photon energy (M3--> K electron transitions).                !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA (EKX(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.15540D+01,0.18360D+01,0.21360D+01,
     *0.24640D+01,0.28160D+01,0.31900D+01,0.35900D+01,0.40130D+01,
     *0.44610D+01,0.49320D+01,0.54270D+01,0.59470D+01,0.64900D+01,
     *0.70580D+01,0.76490D+01,0.82650D+01,0.89050D+01,0.95720D+01,
     *0.10264D+02,0.10982D+02,0.11726D+02,0.12496D+02,0.13292D+02,
     *0.14111D+02,0.14961D+02,0.15836D+02,0.16738D+02,0.17667D+02,
     *0.18623D+02,0.19607D+02,0.20619D+02,0.21657D+02,0.22724D+02,
     *0.23819D+02,0.24943D+02,0.26095D+02,0.27276D+02,0.28486D+02,
     *0.29726D+02,0.30995D+02,0.32295D+02,0.33624D+02,0.34987D+02,
     *0.36378D+02,0.37801D+02,0.39258D+02,0.40748D+02,0.42272D+02,
     *0.43827D+02,0.45414D+02,0.47038D+02,0.48695D+02,0.50384D+02,
     *0.52113D+02,0.53877D+02,0.55674D+02,0.57505D+02,0.59383D+02,
     *0.61290D+02,0.63243D+02,0.65222D+02,0.67244D+02,0.69309D+02,
     *0.71414D+02,0.73560D+02,0.75749D+02,0.77982D+02,0.80255D+02,
     *0.82574D+02,0.84938D+02,0.87349D+02,0.89807D+02,0.92315D+02,
     *0.94868D+02,0.97474D+02,0.10013D+03,0.10284D+03,0.10560D+03,
     *0.10842D+03,0.11130D+03,0.11423D+03,0.11723D+03,0.12028D+03,
     *0.12340D+03,0.12658D+03,0.12982D+03,0.13314D+03,0.13652D+03/
!----------------------------------------------------------------------!
!E-Beta2  photon energy (N2+3--> K electron transitions).              !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA (EKX(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.10366D+02,0.11101D+02,0.11864D+02,0.12652D+02,0.13469D+02,
     *0.14311D+02,0.15185D+02,0.16085D+02,0.17013D+02,0.17969D+02,
     *0.18952D+02,0.19965D+02,0.21005D+02,0.22074D+02,0.23172D+02,
     *0.24299D+02,0.25455D+02,0.26644D+02,0.27863D+02,0.29111D+02,
     *0.30393D+02,0.31704D+02,0.33047D+02,0.34419D+02,0.35818D+02,
     *0.37255D+02,0.38726D+02,0.40228D+02,0.41764D+02,0.43335D+02,
     *0.44942D+02,0.46578D+02,0.48249D+02,0.49959D+02,0.51698D+02,
     *0.53476D+02,0.55293D+02,0.57142D+02,0.59028D+02,0.60962D+02,
     *0.62929D+02,0.64942D+02,0.66982D+02,0.69067D+02,0.71195D+02,
     *0.73363D+02,0.75575D+02,0.77831D+02,0.80130D+02,0.82473D+02,
     *0.84865D+02,0.87300D+02,0.89784D+02,0.92317D+02,0.94900D+02,
     *0.97530D+02,0.10021D+03,0.10295D+03,0.10574D+03,0.10858D+03,
     *0.11149D+03,0.11444D+03,0.11746D+03,0.12054D+03,0.12368D+03,
     *0.12689D+03,0.13015D+03,0.13348D+03,0.13689D+03,0.14036D+03/
!----------------------------------------------------------------------!
!E-Beta3  photon energy (M2--> K electron transitions).                !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA (EKX(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.15540D+01,0.18360D+01,0.21360D+01,
     *0.24640D+01,0.28160D+01,0.31900D+01,0.35900D+01,0.40130D+01,
     *0.44610D+01,0.49320D+01,0.54270D+01,0.59470D+01,0.64900D+01,
     *0.70580D+01,0.76490D+01,0.82650D+01,0.89050D+01,0.95720D+01,
     *0.10260D+02,0.10975D+02,0.11720D+02,0.12490D+02,0.13284D+02,
     *0.14104D+02,0.14952D+02,0.15825D+02,0.16726D+02,0.17653D+02,
     *0.18607D+02,0.19590D+02,0.20599D+02,0.21634D+02,0.22699D+02,
     *0.23791D+02,0.24912D+02,0.26060D+02,0.27238D+02,0.28444D+02,
     *0.29679D+02,0.30944D+02,0.32239D+02,0.33562D+02,0.34920D+02,
     *0.36304D+02,0.37720D+02,0.39170D+02,0.40653D+02,0.42166D+02,
     *0.43713D+02,0.45293D+02,0.46905D+02,0.48551D+02,0.50228D+02,
     *0.51947D+02,0.53695D+02,0.55480D+02,0.57300D+02,0.59159D+02,
     *0.61050D+02,0.62985D+02,0.64948D+02,0.66950D+02,0.68995D+02,
     *0.71079D+02,0.73202D+02,0.75368D+02,0.77577D+02,0.79824D+02,
     *0.82115D+02,0.84450D+02,0.86830D+02,0.89256D+02,0.91730D+02,
     *0.94247D+02,0.96815D+02,0.99432D+02,0.10210D+03,0.10482D+03,
     *0.10760D+03,0.11042D+03,0.11330D+03,0.11624D+03,0.11924D+03,
     *0.12230D+03,0.12542D+03,0.12859D+03,0.13184D+03,0.13515D+03/
!----------------------------------------------------------------------!
!E-Beta4  photon energy (N4,N5--> K electron transitions).             !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA (EKX(7,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.18982D+02,0.19998D+02,0.21042D+02,0.22115D+02,0.23217D+02,
     *0.24349D+02,0.25511D+02,0.26702D+02,0.27924D+02,0.29176D+02,
     *0.30460D+02,0.31774D+02,0.33120D+02,0.34496D+02,0.35907D+02,
     *0.37349D+02,0.38826D+02,0.40333D+02,0.41877D+02,0.43451D+02,
     *0.45064D+02,0.46705D+02,0.48386D+02,0.50099D+02,0.51849D+02,
     *0.53634D+02,0.55457D+02,0.57313D+02,0.59210D+02,0.61141D+02,
     *0.63114D+02,0.65132D+02,0.67181D+02,0.69273D+02,0.71409D+02,
     *0.73590D+02,0.75808D+02,0.78073D+02,0.80382D+02,0.82733D+02,
     *0.85134D+02,0.87580D+02,0.90074D+02,0.92618D+02,0.95211D+02,
     *0.97853D+02,0.10055D+03,0.10329D+03,0.10610D+03,0.10896D+03,
     *0.11187D+03,0.11484D+03,0.11788D+03,0.12097D+03,0.12413D+03,
     *0.12735D+03,0.13063D+03,0.13398D+03,0.13740D+03,0.14089D+03/
!----------------------------------------------------------------------!
!E-Beta5  photon energy (M4,M5--> K electron transitions).             !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA (EKX(8,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.71080D+01,0.77060D+01,0.83290D+01,0.89770D+01,0.96510D+01,
     *0.10350D+02,0.11074D+02,0.11826D+02,0.12601D+02,0.13404D+02,
     *0.14231D+02,0.15089D+02,0.15971D+02,0.16880D+02,0.17816D+02,
     *0.18780D+02,0.19771D+02,0.20789D+02,0.21836D+02,0.22911D+02,
     *0.24013D+02,0.25144D+02,0.26304D+02,0.27493D+02,0.28711D+02,
     *0.29959D+02,0.31236D+02,0.32544D+02,0.33881D+02,0.35252D+02,
     *0.36652D+02,0.38085D+02,0.39551D+02,0.41050D+02,0.42580D+02,
     *0.44145D+02,0.45741D+02,0.47373D+02,0.49038D+02,0.50738D+02,
     *0.52475D+02,0.54246D+02,0.56054D+02,0.57898D+02,0.59780D+02,
     *0.61700D+02,0.63662D+02,0.65652D+02,0.67685D+02,0.69760D+02,
     *0.71875D+02,0.74033D+02,0.76233D+02,0.78476D+02,0.80762D+02,
     *0.83093D+02,0.85470D+02,0.87892D+02,0.90363D+02,0.92883D+02,
     *0.95449D+02,0.98069D+02,0.10074D+03,0.10346D+03,0.10624D+03,
     *0.10907D+03,0.11196D+03,0.11491D+03,0.11792D+03,0.12099D+03,
     *0.12412D+03,0.12732D+03,0.13057D+03,0.13390D+03,0.13730D+03/
!----------------------------------------------------------------------!
!E-O       photon energy (O2O3--> K electron transitions).             !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA (EKX(9,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.27939D+02,0.29199D+02,
     *0.30489D+02,0.31812D+02,0.33166D+02,0.34552D+02,0.35972D+02,
     *0.37425D+02,0.38910D+02,0.40423D+02,0.41968D+02,0.43548D+02,
     *0.45162D+02,0.46813D+02,0.48497D+02,0.50219D+02,0.51970D+02,
     *0.53762D+02,0.55597D+02,0.57456D+02,0.59357D+02,0.61309D+02,
     *0.63286D+02,0.65316D+02,0.67376D+02,0.69484D+02,0.71636D+02,
     *0.73819D+02,0.76054D+02,0.78337D+02,0.80660D+02,0.83028D+02,
     *0.85444D+02,0.87911D+02,0.90421D+02,0.92983D+02,0.95595D+02,
     *0.98257D+02,0.10097D+03,0.10374D+03,0.10656D+03,0.10944D+03,
     *0.11238D+03,0.11538D+03,0.11843D+03,0.12154D+03,0.12472D+03,
     *0.12797D+03,0.13127D+03,0.13465D+03,0.13809D+03,0.14161D+03/
!----------------------------------------------------------------------!
!E-P       photon energy (P2P3--> K electron transitions).             !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA (EKX(10,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.85530D+02,0.88003D+02,0.90522D+02,0.93095D+02,0.95717D+02,
     *0.98389D+02,0.10112D+03,0.10390D+03,0.10674D+03,0.10963D+03,
     *0.11257D+03,0.11558D+03,0.11865D+03,0.12177D+03,0.12496D+03,
     *0.12821D+03,0.13152D+03,0.13491D+03,0.13836D+03,0.14189D+03/
!----------------------------------------------------------------------!
! Probability of K-alpha1 emission,                                    !
!         or Alpha1/(K-Xray total)                                     !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!  K-beta intensity are adjusted to experimental data using the data   !
!  in Table of Isotopes Seventh Edition                                !
!----------------------------------------------------------------------!
      DATA (DFKX(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.66265D+00,
     *0.67857D+00,0.67308D+00,0.66265D+00,0.67669D+00,0.66667D+00,
     *0.66522D+00,0.66667D+00,0.65613D+00,0.65067D+00,0.64248D+00,
     *0.63056D+00,0.62068D+00,0.60590D+00,0.59327D+00,0.59032D+00,
     *0.58824D+00,0.58685D+00,0.58651D+00,0.58582D+00,0.58548D+00,
     *0.58514D+00,0.58480D+00,0.58411D+00,0.58309D+00,0.58207D+00,
     *0.57897D+00,0.57519D+00,0.57113D+00,0.56738D+00,0.56440D+00,
     *0.56243D+00,0.55960D+00,0.55741D+00,0.55463D+00,0.55188D+00,
     *0.54975D+00,0.54795D+00,0.54585D+00,0.54377D+00,0.54230D+00,
     *0.54054D+00,0.53966D+00,0.53821D+00,0.53618D+00,0.53446D+00,
     *0.53275D+00,0.53106D+00,0.52937D+00,0.52741D+00,0.52547D+00,
     *0.52381D+00,0.52244D+00,0.52081D+00,0.51918D+00,0.51757D+00,
     *0.51650D+00,0.51543D+00,0.51383D+00,0.51205D+00,0.51099D+00,
     *0.50993D+00,0.50888D+00,0.50733D+00,0.50603D+00,0.50475D+00,
     *0.50321D+00,0.50192D+00,0.50090D+00,0.49988D+00,0.49861D+00,
     *0.49709D+00,0.49634D+00,0.49531D+00,0.49359D+00,0.49260D+00,
     *0.49113D+00,0.48862D+00,0.48737D+00,0.48612D+00,0.48486D+00,
     *0.48362D+00,0.48216D+00,0.48070D+00,0.47923D+00,0.47823D+00,
     *0.47701D+00,0.47557D+00,0.47459D+00,0.47338D+00,0.47217D+00,
     *0.47075D+00,0.46865D+00,0.46636D+00,0.46496D+00,0.46355D+00/
!----------------------------------------------------------------------!
! Probability of K-alpha2 emission,                                    !
!         or DFKX(1)+Alpha2/(K-Xray total)                             !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!  K-beta intensity are adjusted to experimental data using the data   !
!  in Table of Isotopes Seventh Edition                                !
!----------------------------------------------------------------------!
      DATA (DFKX(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.98168D+00,0.97403D+00,0.96216D+00,
     *0.94458D+00,0.92593D+00,0.90470D+00,0.89339D+00,0.88666D+00,
     *0.88412D+00,0.88204D+00,0.88152D+00,0.88108D+00,0.88115D+00,
     *0.88122D+00,0.88129D+00,0.88084D+00,0.87988D+00,0.87893D+00,
     *0.87482D+00,0.87026D+00,0.86469D+00,0.85959D+00,0.85563D+00,
     *0.85321D+00,0.85003D+00,0.84727D+00,0.84359D+00,0.84051D+00,
     *0.83782D+00,0.83562D+00,0.83297D+00,0.83034D+00,0.82863D+00,
     *0.82649D+00,0.82568D+00,0.82453D+00,0.82197D+00,0.81987D+00,
     *0.81831D+00,0.81623D+00,0.81417D+00,0.81168D+00,0.80975D+00,
     *0.80825D+00,0.80665D+00,0.80517D+00,0.80370D+00,0.80171D+00,
     *0.80109D+00,0.79994D+00,0.79850D+00,0.79675D+00,0.79612D+00,
     *0.79549D+00,0.79488D+00,0.79346D+00,0.79245D+00,0.79094D+00,
     *0.79004D+00,0.78902D+00,0.78842D+00,0.78781D+00,0.78681D+00,
     *0.78541D+00,0.78471D+00,0.78408D+00,0.78284D+00,0.78224D+00,
     *0.78090D+00,0.77838D+00,0.77735D+00,0.77633D+00,0.77578D+00,
     *0.77477D+00,0.77386D+00,0.77297D+00,0.77205D+00,0.77139D+00,
     *0.77085D+00,0.76994D+00,0.76978D+00,0.76924D+00,0.76870D+00,
     *0.76826D+00,0.76719D+00,0.76577D+00,0.76486D+00,0.76394D+00/
!----------------------------------------------------------------------!
! Probability of K-alpha3 emission,                                    !
!         or DFKX(2)+Alpha3/(K-Xray total)                             !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!  K-beta intensity are adjusted to experimental data using the data   !
!  in Table of Isotopes Seventh Edition                                !
!----------------------------------------------------------------------!
      DATA (DFKX(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.98168D+00,0.97403D+00,0.96216D+00,
     *0.94458D+00,0.92593D+00,0.90470D+00,0.89339D+00,0.88666D+00,
     *0.88412D+00,0.88204D+00,0.88152D+00,0.88108D+00,0.88115D+00,
     *0.88122D+00,0.88129D+00,0.88084D+00,0.87988D+00,0.87893D+00,
     *0.87482D+00,0.87026D+00,0.86469D+00,0.85959D+00,0.85563D+00,
     *0.85321D+00,0.85003D+00,0.84727D+00,0.84359D+00,0.84051D+00,
     *0.83782D+00,0.83562D+00,0.83297D+00,0.83034D+00,0.82863D+00,
     *0.82649D+00,0.82569D+00,0.82454D+00,0.82199D+00,0.81989D+00,
     *0.81833D+00,0.81625D+00,0.81419D+00,0.81171D+00,0.80978D+00,
     *0.80828D+00,0.80670D+00,0.80522D+00,0.80375D+00,0.80177D+00,
     *0.80115D+00,0.80001D+00,0.79858D+00,0.79683D+00,0.79622D+00,
     *0.79560D+00,0.79499D+00,0.79359D+00,0.79259D+00,0.79109D+00,
     *0.79020D+00,0.78921D+00,0.78862D+00,0.78803D+00,0.78705D+00,
     *0.78566D+00,0.78499D+00,0.78440D+00,0.78318D+00,0.78262D+00,
     *0.78132D+00,0.77883D+00,0.77785D+00,0.77687D+00,0.77638D+00,
     *0.77541D+00,0.77457D+00,0.77374D+00,0.77288D+00,0.77228D+00,
     *0.77181D+00,0.77098D+00,0.77089D+00,0.77043D+00,0.76999D+00,
     *0.76965D+00,0.76871D+00,0.76743D+00,0.76666D+00,0.76587D+00/
!----------------------------------------------------------------------!
! Probability of K-beta1 emission,                                     !
!         or DFKX(3)+beta1/(K-Xray total)                              !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!  K-beta intensity are adjusted to experimental data using the data   !
!  in Table of Isotopes Seventh Edition                                !
!----------------------------------------------------------------------!
      DATA (DFKX(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.99381D+00,0.99134D+00,0.98725D+00,
     *0.98137D+00,0.97514D+00,0.96751D+00,0.96416D+00,0.96178D+00,
     *0.96095D+00,0.96031D+00,0.95987D+00,0.95979D+00,0.95989D+00,
     *0.95972D+00,0.95970D+00,0.95950D+00,0.95922D+00,0.95886D+00,
     *0.95698D+00,0.95443D+00,0.95125D+00,0.94854D+00,0.94478D+00,
     *0.94282D+00,0.93954D+00,0.93671D+00,0.93407D+00,0.93201D+00,
     *0.93033D+00,0.92892D+00,0.92731D+00,0.92571D+00,0.92478D+00,
     *0.92324D+00,0.92224D+00,0.92079D+00,0.91962D+00,0.91851D+00,
     *0.91770D+00,0.91635D+00,0.91468D+00,0.91285D+00,0.91117D+00,
     *0.90965D+00,0.90808D+00,0.90666D+00,0.90514D+00,0.90313D+00,
     *0.90270D+00,0.90163D+00,0.90086D+00,0.89974D+00,0.89954D+00,
     *0.89934D+00,0.89947D+00,0.89891D+00,0.89889D+00,0.89837D+00,
     *0.89860D+00,0.89846D+00,0.89833D+00,0.89758D+00,0.89711D+00,
     *0.89663D+00,0.89546D+00,0.89468D+00,0.89328D+00,0.89231D+00,
     *0.89093D+00,0.89023D+00,0.88897D+00,0.88771D+00,0.88693D+00,
     *0.88568D+00,0.88498D+00,0.88430D+00,0.88358D+00,0.88323D+00,
     *0.88295D+00,0.88227D+00,0.88194D+00,0.88120D+00,0.88048D+00,
     *0.87981D+00,0.87931D+00,0.87842D+00,0.87778D+00,0.87712D+00/
!----------------------------------------------------------------------!
! Probability of K-beta2 emission,                                     !
!         or DFKX(4)+beta2/(K-Xray total)                              !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!  K-beta intensity are adjusted to experimental data using the data   !
!  in Table of Isotopes Seventh Edition                                !
!----------------------------------------------------------------------!
      DATA (DFKX(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.99381D+00,0.99134D+00,0.98725D+00,
     *0.98137D+00,0.97514D+00,0.96751D+00,0.96416D+00,0.96178D+00,
     *0.96095D+00,0.96031D+00,0.95987D+00,0.95979D+00,0.95989D+00,
     *0.95972D+00,0.95970D+00,0.95950D+00,0.95922D+00,0.95886D+00,
     *0.95767D+00,0.95648D+00,0.95520D+00,0.95392D+00,0.95370D+00,
     *0.95351D+00,0.95353D+00,0.95343D+00,0.95293D+00,0.95243D+00,
     *0.95176D+00,0.95136D+00,0.95075D+00,0.95013D+00,0.94966D+00,
     *0.94910D+00,0.94912D+00,0.94920D+00,0.94820D+00,0.94711D+00,
     *0.94622D+00,0.94518D+00,0.94423D+00,0.94295D+00,0.94204D+00,
     *0.94140D+00,0.94070D+00,0.94085D+00,0.94064D+00,0.94037D+00,
     *0.94038D+00,0.94017D+00,0.93975D+00,0.93910D+00,0.93920D+00,
     *0.93898D+00,0.93863D+00,0.93801D+00,0.93748D+00,0.93703D+00,
     *0.93643D+00,0.93563D+00,0.93520D+00,0.93466D+00,0.93388D+00,
     *0.93363D+00,0.93318D+00,0.93297D+00,0.93253D+00,0.93215D+00,
     *0.93159D+00,0.93152D+00,0.93096D+00,0.93035D+00,0.92988D+00,
     *0.92918D+00,0.92870D+00,0.92833D+00,0.92787D+00,0.92761D+00,
     *0.92738D+00,0.92709D+00,0.92683D+00,0.92618D+00,0.92594D+00,
     *0.92518D+00,0.92504D+00,0.92466D+00,0.92446D+00,0.92389D+00/
!----------------------------------------------------------------------!
! Probability of K-beta3 emission,                                     !
!         or DFKX(5)+beta3/(K-Xray total)                              !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!  K-beta intensity are adjusted to experimental data using the data   !
!  in Table of Isotopes Seventh Edition                                !
!----------------------------------------------------------------------!
      DATA (DFKX(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.99996D+00,0.99994D+00,0.99993D+00,0.99991D+00,0.99988D+00,
     *0.99986D+00,0.99984D+00,0.99981D+00,0.99977D+00,0.99974D+00,
     *0.99972D+00,0.99969D+00,0.99966D+00,0.99963D+00,0.99959D+00,
     *0.99954D+00,0.99950D+00,0.99944D+00,0.99938D+00,0.99934D+00,
     *0.99926D+00,0.99920D+00,0.99913D+00,0.99882D+00,0.99834D+00,
     *0.99781D+00,0.99711D+00,0.99628D+00,0.99532D+00,0.99458D+00,
     *0.99391D+00,0.99326D+00,0.99335D+00,0.99316D+00,0.99291D+00,
     *0.99283D+00,0.99270D+00,0.99262D+00,0.99232D+00,0.99261D+00,
     *0.99258D+00,0.99259D+00,0.99255D+00,0.99257D+00,0.99265D+00,
     *0.99235D+00,0.99219D+00,0.99186D+00,0.99156D+00,0.99124D+00,
     *0.99100D+00,0.99071D+00,0.99028D+00,0.98984D+00,0.98945D+00,
     *0.98885D+00,0.98820D+00,0.98749D+00,0.98674D+00,0.98612D+00,
     *0.98528D+00,0.98463D+00,0.98409D+00,0.98346D+00,0.98308D+00,
     *0.98271D+00,0.98226D+00,0.98189D+00,0.98157D+00,0.98119D+00,
     *0.98072D+00,0.98034D+00,0.98016D+00,0.97979D+00,0.97952D+00/
!----------------------------------------------------------------------!
! Probability of K-beta4 emission,                                     !
!         or DFKX(6)+beta4/(K-Xray total)                              !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!  K-beta intensity are adjusted to experimental data using the data   !
!  in Table of Isotopes Seventh Edition                                !
!----------------------------------------------------------------------!
      DATA (DFKX(7,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.99996D+00,0.99994D+00,0.99993D+00,0.99991D+00,0.99988D+00,
     *0.99986D+00,0.99984D+00,0.99981D+00,0.99977D+00,0.99974D+00,
     *0.99972D+00,0.99969D+00,0.99966D+00,0.99963D+00,0.99959D+00,
     *0.99956D+00,0.99952D+00,0.99948D+00,0.99943D+00,0.99940D+00,
     *0.99935D+00,0.99930D+00,0.99925D+00,0.99896D+00,0.99850D+00,
     *0.99798D+00,0.99730D+00,0.99649D+00,0.99554D+00,0.99483D+00,
     *0.99417D+00,0.99355D+00,0.99368D+00,0.99350D+00,0.99329D+00,
     *0.99324D+00,0.99313D+00,0.99308D+00,0.99276D+00,0.99306D+00,
     *0.99305D+00,0.99307D+00,0.99304D+00,0.99307D+00,0.99318D+00,
     *0.99290D+00,0.99277D+00,0.99246D+00,0.99220D+00,0.99192D+00,
     *0.99171D+00,0.99147D+00,0.99108D+00,0.99068D+00,0.99034D+00,
     *0.98979D+00,0.98919D+00,0.98853D+00,0.98784D+00,0.98728D+00,
     *0.98650D+00,0.98592D+00,0.98544D+00,0.98488D+00,0.98458D+00,
     *0.98429D+00,0.98391D+00,0.98361D+00,0.98337D+00,0.98307D+00,
     *0.98268D+00,0.98237D+00,0.98225D+00,0.98196D+00,0.98176D+00/
!----------------------------------------------------------------------!
! Probability of K-beta5 emission,                                     !
!         or DFKX(7)+beta5/(K-Xray total)                              !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!  K-beta intensity are adjusted to experimental data using the data   !
!  in Table of Isotopes Seventh Edition                                !
!----------------------------------------------------------------------!
      DATA (DFKX(8,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.99977D+00,0.99936D+00,
     *0.99885D+00,0.99821D+00,0.99746D+00,0.99658D+00,0.99591D+00,
     *0.99535D+00,0.99478D+00,0.99494D+00,0.99482D+00,0.99466D+00,
     *0.99469D+00,0.99464D+00,0.99464D+00,0.99430D+00,0.99471D+00,
     *0.99480D+00,0.99492D+00,0.99499D+00,0.99512D+00,0.99531D+00,
     *0.99513D+00,0.99509D+00,0.99488D+00,0.99472D+00,0.99453D+00,
     *0.99442D+00,0.99427D+00,0.99397D+00,0.99366D+00,0.99341D+00,
     *0.99295D+00,0.99243D+00,0.99187D+00,0.99127D+00,0.99080D+00,
     *0.99012D+00,0.98960D+00,0.98919D+00,0.98873D+00,0.98853D+00,
     *0.98832D+00,0.98802D+00,0.98781D+00,0.98766D+00,0.98744D+00,
     *0.98713D+00,0.98689D+00,0.98684D+00,0.98663D+00,0.98651D+00/
!----------------------------------------------------------------------!
! Probability of K-O emission,                                         !
!         or DFKX(8)+KO/(K-Xray total)                                 !
!                 (Table 7 Table of Isotopes Eighth Edition)           !
!  K-beta intensity are adjusted to experimental data using the data   !
!  in Table of Isotopes Seventh Edition                                !
!----------------------------------------------------------------------!
      DATA (DFKX(9,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.99994D+00,0.99983D+00,0.99967D+00,0.99947D+00,0.99924D+00,
     *0.99897D+00,0.99876D+00,0.99856D+00,0.99841D+00,0.99827D+00,
     *0.99832D+00,0.99828D+00,0.99826D+00,0.99831D+00,0.99829D+00,
     *0.99817D+00,0.99816D+00,0.99824D+00,0.99822D+00,0.99823D+00/
!---------------------------------------------------------------------!
!  E-L1 edge energy  in KeV                                           !
!            (Table 2. of Table of Isotopes, Eighth Edition)          !
!---------------------------------------------------------------------!
      DATA (EEDGE(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.53000D-02,0.80000D-02,0.12600D-01,
     *0.18000D-01,0.24400D-01,0.28500D-01,0.34000D-01,0.48500D-01,
     *0.63300D-01,0.89400D-01,0.11770D+00,0.14870D+00,0.18930D+00,
     *0.22920D+00,0.27020D+00,0.32630D+00,0.37710D+00,0.43780D+00,
     *0.50040D+00,0.56370D+00,0.62820D+00,0.69460D+00,0.76900D+00,
     *0.84610D+00,0.92560D+00,0.10081D+01,0.10961D+01,0.11936D+01,
     *0.12977D+01,0.14143D+01,0.15265D+01,0.16539D+01,0.17820D+01,
     *0.19210D+01,0.20651D+01,0.22163D+01,0.23725D+01,0.25316D+01,
     *0.26977D+01,0.28655D+01,0.30425D+01,0.32240D+01,0.34119D+01,
     *0.36043D+01,0.38058D+01,0.40180D+01,0.42375D+01,0.44647D+01,
     *0.46983D+01,0.49392D+01,0.51881D+01,0.54528D+01,0.57143D+01,
     *0.59888D+01,0.62663D+01,0.65488D+01,0.68348D+01,0.71260D+01,
     *0.74279D+01,0.77368D+01,0.80520D+01,0.83756D+01,0.87080D+01,
     *0.90458D+01,0.93942D+01,0.97513D+01,0.10116D+02,0.10486D+02,
     *0.10870D+02,0.11271D+02,0.11682D+02,0.12100D+02,0.12527D+02,
     *0.12968D+02,0.13419D+02,0.13881D+02,0.14353D+02,0.14839D+02,
     *0.15347D+02,0.15861D+02,0.16388D+02,0.16928D+02,0.17482D+02,
     *0.18048D+02,0.18634D+02,0.19232D+02,0.19846D+02,0.20472D+02,
     *0.21105D+02,0.21758D+02,0.22427D+02,0.23104D+02,0.23808D+02,
     *0.24526D+02,0.25256D+02,0.26010D+02,0.26782D+02,0.27574D+02/
!---------------------------------------------------------------------!
!  E-L2 edge energy  in KeV                                           !
!            (Table 2. of Table of Isotopes, Eighth Edition)          !
!---------------------------------------------------------------------!
      DATA (EEDGE(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.47000D-02,
     *0.64000D-02,0.92000D-02,0.71000D-02,0.86000D-02,0.21700D-01,
     *0.31100D-01,0.51400D-01,0.73200D-01,0.99500D-01,0.13620D+00,
     *0.16540D+00,0.20160D+00,0.25070D+00,0.29630D+00,0.35000D+00,
     *0.40670D+00,0.46150D+00,0.52050D+00,0.58370D+00,0.65140D+00,
     *0.72110D+00,0.79360D+00,0.87190D+00,0.95100D+00,0.10428D+01,
     *0.11423D+01,0.12478D+01,0.13586D+01,0.14762D+01,0.15960D+01,
     *0.17272D+01,0.18639D+01,0.20068D+01,0.21555D+01,0.23067D+01,
     *0.24647D+01,0.26251D+01,0.27932D+01,0.29669D+01,0.31461D+01,
     *0.33303D+01,0.35237D+01,0.37270D+01,0.39380D+01,0.41561D+01,
     *0.43804D+01,0.46120D+01,0.48521D+01,0.51037D+01,0.53594D+01,
     *0.56236D+01,0.58906D+01,0.61642D+01,0.64404D+01,0.67215D+01,
     *0.70128D+01,0.73118D+01,0.76171D+01,0.79303D+01,0.82516D+01,
     *0.85806D+01,0.89178D+01,0.92643D+01,0.96169D+01,0.99782D+01,
     *0.10349D+02,0.10739D+02,0.11136D+02,0.11544D+02,0.11959D+02,
     *0.12385D+02,0.12824D+02,0.13273D+02,0.13734D+02,0.14209D+02,
     *0.14698D+02,0.15200D+02,0.15711D+02,0.16237D+02,0.16776D+02,
     *0.17328D+02,0.17899D+02,0.18484D+02,0.19081D+02,0.19693D+02,
     *0.20314D+02,0.20948D+02,0.21600D+02,0.22266D+02,0.22952D+02,
     *0.23651D+02,0.24371D+02,0.25108D+02,0.25865D+02,0.26641D+02/
!---------------------------------------------------------------------!
!  E-L3 edge energy  in KeV                                           !
!            (Table 2. of Table of Isotopes, Eighth Edition)          !
!---------------------------------------------------------------------!
      DATA (EEDGE(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.47000D-02,
     *0.64000D-02,0.92000D-02,0.71000D-02,0.86000D-02,0.21600D-01,
     *0.31100D-01,0.51400D-01,0.72700D-01,0.98900D-01,0.13530D+00,
     *0.16420D+00,0.20000D+00,0.24860D+00,0.29360D+00,0.34640D+00,
     *0.40220D+00,0.45550D+00,0.51290D+00,0.57450D+00,0.64030D+00,
     *0.70810D+00,0.77860D+00,0.85470D+00,0.93110D+00,0.10197D+01,
     *0.11154D+01,0.12167D+01,0.13231D+01,0.14358D+01,0.15499D+01,
     *0.16749D+01,0.18044D+01,0.19396D+01,0.20800D+01,0.22223D+01,
     *0.23705D+01,0.25202D+01,0.26769D+01,0.28379D+01,0.30038D+01,
     *0.31733D+01,0.33511D+01,0.35375D+01,0.37301D+01,0.39288D+01,
     *0.41322D+01,0.43414D+01,0.45571D+01,0.47822D+01,0.50119D+01,
     *0.52470D+01,0.54827D+01,0.57234D+01,0.59643D+01,0.62079D+01,
     *0.64593D+01,0.67162D+01,0.69769D+01,0.72428D+01,0.75140D+01,
     *0.77901D+01,0.80711D+01,0.83579D+01,0.86480D+01,0.89436D+01,
     *0.92441D+01,0.95607D+01,0.98811D+01,0.10207D+02,0.10535D+02,
     *0.10871D+02,0.11215D+02,0.11564D+02,0.11919D+02,0.12284D+02,
     *0.12658D+02,0.13035D+02,0.13419D+02,0.13810D+02,0.14207D+02,
     *0.14610D+02,0.15025D+02,0.15444D+02,0.15870D+02,0.16300D+02,
     *0.16733D+02,0.17168D+02,0.17610D+02,0.18057D+02,0.18510D+02,
     *0.18970D+02,0.19435D+02,0.19907D+02,0.20384D+02,0.20868D+02/
!--------------------------------------------------------------------!
!L-beta3 photon energy in keV (M3--> L1 electron transitions).       !
!                (Table 7b Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX1(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.11200D+00,0.14600D+00,0.17900D+00,
     *0.22100D+00,0.26300D+00,0.31000D+00,0.35900D+00,0.41200D+00,
     *0.46800D+00,0.52900D+00,0.59000D+00,0.65200D+00,0.72000D+00,
     *0.79200D+00,0.86600D+00,0.94000D+00,0.10220D+01,0.11070D+01,
     *0.11950D+01,0.12940D+01,0.13860D+01,0.14920D+01,0.16010D+01,
     *0.17070D+01,0.18270D+01,0.19470D+01,0.20720D+01,0.22010D+01,
     *0.23350D+01,0.24730D+01,0.26170D+01,0.27630D+01,0.29160D+01,
     *0.30730D+01,0.32340D+01,0.34020D+01,0.35730D+01,0.37500D+01,
     *0.39330D+01,0.41210D+01,0.43140D+01,0.45120D+01,0.47170D+01,
     *0.49270D+01,0.51430D+01,0.53630D+01,0.55930D+01,0.58290D+01,
     *0.60710D+01,0.63170D+01,0.65710D+01,0.68320D+01,0.70970D+01,
     *0.73700D+01,0.76530D+01,0.79400D+01,0.82310D+01,0.85370D+01,
     *0.88470D+01,0.91630D+01,0.94880D+01,0.98190D+01,0.10159D+02,
     *0.10511D+02,0.10868D+02,0.11235D+02,0.11610D+02,0.11992D+02,
     *0.12390D+02,0.12794D+02,0.13211D+02,0.13635D+02,0.14073D+02,
     *0.14519D+02,0.14978D+02,0.15447D+02,0.15931D+02,0.16426D+02,
     *0.16931D+02,0.17454D+02,0.17992D+02,0.18541D+02,0.19110D+02,
     *0.19688D+02,0.20280D+02,0.20894D+02,0.21523D+02,0.22169D+02/
!--------------------------------------------------------------------!
!L-beta4 photon energy in keV (M2--> L1 electron transitions).       !
!                (Table 7b Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX1(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.11200D+00,0.14600D+00,0.17900D+00,
     *0.22100D+00,0.26300D+00,0.31000D+00,0.35900D+00,0.41200D+00,
     *0.46800D+00,0.52900D+00,0.59000D+00,0.65200D+00,0.72000D+00,
     *0.79200D+00,0.86600D+00,0.94000D+00,0.10220D+01,0.11070D+01,
     *0.11910D+01,0.12860D+01,0.13800D+01,0.14860D+01,0.15930D+01,
     *0.16990D+01,0.18180D+01,0.19360D+01,0.20600D+01,0.21870D+01,
     *0.23190D+01,0.24560D+01,0.25980D+01,0.27410D+01,0.28910D+01,
     *0.30450D+01,0.32030D+01,0.33670D+01,0.35350D+01,0.37080D+01,
     *0.38860D+01,0.40700D+01,0.42580D+01,0.44510D+01,0.46490D+01,
     *0.48520D+01,0.50620D+01,0.52760D+01,0.54970D+01,0.57230D+01,
     *0.59560D+01,0.61960D+01,0.64380D+01,0.66870D+01,0.69400D+01,
     *0.72040D+01,0.74710D+01,0.77460D+01,0.80260D+01,0.83130D+01,
     *0.86070D+01,0.89050D+01,0.92130D+01,0.95250D+01,0.98450D+01,
     *0.10176D+02,0.10510D+02,0.10854D+02,0.11205D+02,0.11561D+02,
     *0.11931D+02,0.12307D+02,0.12691D+02,0.13084D+02,0.13488D+02,
     *0.13898D+02,0.14319D+02,0.14749D+02,0.15191D+02,0.15641D+02,
     *0.16104D+02,0.16577D+02,0.17061D+02,0.17557D+02,0.18069D+02,
     *0.18589D+02,0.19118D+02,0.19665D+02,0.20224D+02,0.20798D+02/
!--------------------------------------------------------------------!
!L-Beta10  photon energy (M IV --> L I electron transition).         !
!                 (Table IV of Storm Israel)                         !
!--------------------------------------------------------------------!
      DATA (ELX1(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.69500D+00,0.76700D+00,
     *0.84300D+00,0.92200D+00,0.10030D+01,0.10890D+01,0.11830D+01,
     *0.12830D+01,0.13850D+01,0.14890D+01,0.15970D+01,0.17100D+01,
     *0.18300D+01,0.19530D+01,0.20810D+01,0.22150D+01,0.23510D+01,
     *0.24920D+01,0.26370D+01,0.27870D+01,0.29400D+01,0.31000D+01,
     *0.32650D+01,0.34330D+01,0.36080D+01,0.37870D+01,0.39720D+01,
     *0.41610D+01,0.43560D+01,0.45550D+01,0.47590D+01,0.49730D+01,
     *0.51930D+01,0.54180D+01,0.56480D+01,0.58840D+01,0.61270D+01,
     *0.63760D+01,0.66300D+01,0.68910D+01,0.71580D+01,0.74340D+01,
     *0.77140D+01,0.80020D+01,0.82990D+01,0.86010D+01,0.89120D+01,
     *0.92330D+01,0.95560D+01,0.98870D+01,0.10227D+02,0.10578D+02,
     *0.10938D+02,0.11303D+02,0.11678D+02,0.12062D+02,0.12457D+02,
     *0.12861D+02,0.13275D+02,0.13702D+02,0.14138D+02,0.14582D+02,
     *0.15033D+02,0.15503D+02,0.15984D+02,0.16474D+02,0.16976D+02,
     *0.17496D+02,0.18031D+02,0.18577D+02,0.19136D+02,0.19712D+02,
     *0.20305D+02,0.20911D+02,0.21528D+02,0.22159D+02,0.22804D+02/
!---------------------------------------------------------------------!
!L-Beta9/1  photon energy (M V --> L I electron transition).          !
!                 (Table IV of Storm Israel)                          !
!---------------------------------------------------------------------!
      DATA (ELX1(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.69500D+00,0.76700D+00,
     *0.84300D+00,0.92200D+00,0.10030D+01,0.10890D+01,0.11830D+01,
     *0.12830D+01,0.13850D+01,0.14890D+01,0.15970D+01,0.17110D+01,
     *0.18310D+01,0.19550D+01,0.20830D+01,0.22170D+01,0.23530D+01,
     *0.24970D+01,0.26390D+01,0.27900D+01,0.29440D+01,0.31050D+01,
     *0.32700D+01,0.34390D+01,0.36140D+01,0.37950D+01,0.39800D+01,
     *0.41700D+01,0.43670D+01,0.45670D+01,0.47730D+01,0.49870D+01,
     *0.52070D+01,0.54340D+01,0.56660D+01,0.59040D+01,0.61500D+01,
     *0.64010D+01,0.66580D+01,0.69210D+01,0.71900D+01,0.74680D+01,
     *0.77510D+01,0.80430D+01,0.83430D+01,0.86480D+01,0.89610D+01,
     *0.92830D+01,0.96100D+01,0.99450D+01,0.10289D+02,0.10645D+02,
     *0.11009D+02,0.11379D+02,0.11758D+02,0.12147D+02,0.12547D+02,
     *0.12957D+02,0.13377D+02,0.13810D+02,0.14253D+02,0.14704D+02,
     *0.15163D+02,0.15639D+02,0.16128D+02,0.16626D+02,0.17134D+02,
     *0.17663D+02,0.18207D+02,0.18763D+02,0.19331D+02,0.19918D+02,
     *0.20523D+02,0.21143D+02,0.21776D+02,0.22425D+02,0.23090D+02/
!-------------------------------------------------------------------!
!L-gama2 photon energy in keV (N2--> L1 electron transitions).      !
!                (Table 7b Table of Isotopes Eighth Edition)        !
!-------------------------------------------------------------------!
      DATA (ELX1(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.14120D+01,0.15240D+01,0.16480D+01,0.17770D+01,
     *0.19060D+01,0.20500D+01,0.21960D+01,0.23470D+01,0.25030D+01,
     *0.26640D+01,0.28310D+01,0.30040D+01,0.31810D+01,0.33640D+01,
     *0.35530D+01,0.37430D+01,0.39510D+01,0.41600D+01,0.43760D+01,
     *0.46000D+01,0.48290D+01,0.50650D+01,0.53070D+01,0.55420D+01,
     *0.57970D+01,0.60600D+01,0.63260D+01,0.65990D+01,0.68830D+01,
     *0.71860D+01,0.74710D+01,0.77680D+01,0.80870D+01,0.83980D+01,
     *0.87140D+01,0.90510D+01,0.93850D+01,0.97300D+01,0.10090D+02,
     *0.10460D+02,0.10834D+02,0.11217D+02,0.11608D+02,0.12009D+02,
     *0.12421D+02,0.12841D+02,0.13273D+02,0.13709D+02,0.14158D+02,
     *0.14625D+02,0.15097D+02,0.15582D+02,0.16077D+02,0.16585D+02,
     *0.17104D+02,0.17635D+02,0.18177D+02,0.18734D+02,0.19304D+02,
     *0.19888D+02,0.20487D+02,0.21099D+02,0.21724D+02,0.22370D+02,
     *0.23028D+02,0.23698D+02,0.24390D+02,0.25099D+02,0.25825D+02/
!--------------------------------------------------------------------!
!L-gama3 photon energy in keV (N3--> L1 electron transitions).       !
!                (Table 7b Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX1(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.12970D+01,0.14120D+01,0.15240D+01,0.16480D+01,0.17770D+01,
     *0.19070D+01,0.20510D+01,0.21960D+01,0.23470D+01,0.25030D+01,
     *0.26640D+01,0.28310D+01,0.30040D+01,0.31810D+01,0.33640D+01,
     *0.35530D+01,0.37500D+01,0.39510D+01,0.41600D+01,0.43760D+01,
     *0.46000D+01,0.48290D+01,0.50650D+01,0.53070D+01,0.55530D+01,
     *0.58090D+01,0.60750D+01,0.63420D+01,0.66170D+01,0.69010D+01,
     *0.71860D+01,0.74890D+01,0.77950D+01,0.81050D+01,0.84230D+01,
     *0.87530D+01,0.90880D+01,0.94310D+01,0.97790D+01,0.10143D+02,
     *0.10511D+02,0.10890D+02,0.11277D+02,0.11675D+02,0.12082D+02,
     *0.12500D+02,0.12924D+02,0.13361D+02,0.13807D+02,0.14262D+02,
     *0.14738D+02,0.15216D+02,0.15709D+02,0.16213D+02,0.16731D+02,
     *0.17258D+02,0.17800D+02,0.18353D+02,0.18922D+02,0.19505D+02,
     *0.20101D+02,0.20715D+02,0.21342D+02,0.21981D+02,0.22643D+02,
     *0.23319D+02,0.24007D+02,0.24718D+02,0.25446D+02,0.26195D+02/
!--------------------------------------------------------------------!
!L-Gamma41 photon energy (O II --> L I electron transition).         !
!                 (Table IV of Storm Israel)                         !
!--------------------------------------------------------------------!
      DATA (ELX1(7,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.42370D+01,0.44630D+01,
     *0.46950D+01,0.49340D+01,0.51810D+01,0.54360D+01,0.57020D+01,
     *0.59730D+01,0.62510D+01,0.65330D+01,0.68170D+01,0.71090D+01,
     *0.74080D+01,0.77150D+01,0.80300D+01,0.83510D+01,0.86830D+01,
     *0.90200D+01,0.93660D+01,0.97230D+01,0.10085D+02,0.10456D+02,
     *0.10838D+02,0.11233D+02,0.11637D+02,0.12051D+02,0.12477D+02,
     *0.12914D+02,0.13359D+02,0.13815D+02,0.14281D+02,0.14762D+02,
     *0.15255D+02,0.15757D+02,0.16274D+02,0.16803D+02,0.17341D+02,
     *0.17890D+02,0.18459D+02,0.19039D+02,0.19631D+02,0.20236D+02,
     *0.20858D+02,0.21494D+02,0.22144D+02,0.22809D+02,0.23497D+02,
     *0.24204D+02,0.24928D+02,0.25667D+02,0.26425D+02,0.27201D+02/
!--------------------------------------------------------------------!
!L-Gamma42 photon energy (O III --> L I electron transition).        !
!                 (Table IV of Storm Israel)                         !
!--------------------------------------------------------------------!
      DATA (ELX1(8,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.42370D+01,0.44610D+01,
     *0.46950D+01,0.49340D+01,0.51810D+01,0.54360D+01,0.57020D+01,
     *0.59740D+01,0.62520D+01,0.65340D+01,0.68190D+01,0.71110D+01,
     *0.74110D+01,0.77180D+01,0.80330D+01,0.83550D+01,0.86870D+01,
     *0.90240D+01,0.93710D+01,0.97270D+01,0.10090D+02,0.10461D+02,
     *0.10845D+02,0.11241D+02,0.11647D+02,0.12062D+02,0.12487D+02,
     *0.12927D+02,0.13373D+02,0.13828D+02,0.14295D+02,0.14776D+02,
     *0.15271D+02,0.15775D+02,0.16293D+02,0.16828D+02,0.17371D+02,
     *0.17924D+02,0.18497D+02,0.19084D+02,0.19681D+02,0.20291D+02,
     *0.20920D+02,0.21564D+02,0.22221D+02,0.22892D+02,0.23584D+02,
     *0.24296D+02,0.25025D+02,0.25770D+02,0.26533D+02,0.27314D+02/
!--------------------------------------------------------------------!
!L-beta1 photon energy in keV (M4--> L2 electron transitions).       !
!                (Table 7c Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX2(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.73000D-01,0.99000D-01,0.13600D+00,
     *0.16500D+00,0.20200D+00,0.25100D+00,0.29600D+00,0.35000D+00,
     *0.40000D+00,0.45800D+00,0.51800D+00,0.58100D+00,0.64800D+00,
     *0.71700D+00,0.79100D+00,0.86800D+00,0.94900D+00,0.10350D+01,
     *0.11250D+01,0.12190D+01,0.13170D+01,0.14200D+01,0.15260D+01,
     *0.16320D+01,0.17520D+01,0.18720D+01,0.19960D+01,0.21240D+01,
     *0.22570D+01,0.23950D+01,0.25370D+01,0.26830D+01,0.28340D+01,
     *0.29900D+01,0.31510D+01,0.33170D+01,0.34870D+01,0.36630D+01,
     *0.38430D+01,0.40290D+01,0.42210D+01,0.44140D+01,0.46200D+01,
     *0.48280D+01,0.50420D+01,0.52630D+01,0.54890D+01,0.57220D+01,
     *0.59610D+01,0.62060D+01,0.64570D+01,0.67130D+01,0.69770D+01,
     *0.72480D+01,0.75260D+01,0.78110D+01,0.81020D+01,0.84020D+01,
     *0.87090D+01,0.90230D+01,0.93430D+01,0.96720D+01,0.10010D+02,
     *0.10354D+02,0.10708D+02,0.11071D+02,0.11443D+02,0.11824D+02,
     *0.12213D+02,0.12614D+02,0.13024D+02,0.13443D+02,0.13875D+02,
     *0.14316D+02,0.14770D+02,0.15236D+02,0.15711D+02,0.16202D+02,
     *0.16708D+02,0.17222D+02,0.17751D+02,0.18296D+02,0.18856D+02,
     *0.19427D+02,0.20018D+02,0.20624D+02,0.21248D+02,0.21889D+02/
!--------------------------------------------------------------------!
!L-gamma1 photon energy in keV (N4--> L2 electron transitions).      !
!                (Table 7c Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX2(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.21530D+01,0.23040D+01,
     *0.24620D+01,0.26230D+01,0.27910D+01,0.29650D+01,0.31440D+01,
     *0.33290D+01,0.35200D+01,0.37180D+01,0.39220D+01,0.41320D+01,
     *0.43490D+01,0.45720D+01,0.48020D+01,0.50340D+01,0.52810D+01,
     *0.55310D+01,0.57920D+01,0.60540D+01,0.63270D+01,0.66040D+01,
     *0.68920D+01,0.71830D+01,0.74840D+01,0.77900D+01,0.81050D+01,
     *0.84260D+01,0.87570D+01,0.90880D+01,0.94370D+01,0.97800D+01,
     *0.10144D+02,0.10516D+02,0.10895D+02,0.11285D+02,0.11685D+02,
     *0.12096D+02,0.12513D+02,0.12942D+02,0.13382D+02,0.13830D+02,
     *0.14291D+02,0.14765D+02,0.15248D+02,0.15742D+02,0.16249D+02,
     *0.16770D+02,0.17302D+02,0.17848D+02,0.18405D+02,0.18980D+02,
     *0.19571D+02,0.20169D+02,0.20784D+02,0.21420D+02,0.22072D+02,
     *0.22735D+02,0.23416D+02,0.24117D+02,0.24836D+02,0.25574D+02/
!--------------------------------------------------------------------!
!L-gamma5 photon energy (N I --> L II electron transition).          !
!                 (Table IV of Storm Israel)                         !
!--------------------------------------------------------------------!
      DATA (ELX2(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.10420D+01,
     *0.11400D+01,0.12440D+01,0.13510D+01,0.14630D+01,0.15790D+01,
     *0.17030D+01,0.18320D+01,0.19690D+01,0.21110D+01,0.22560D+01,
     *0.24070D+01,0.25620D+01,0.27230D+01,0.28920D+01,0.30650D+01,
     *0.32430D+01,0.34280D+01,0.36190D+01,0.38160D+01,0.40190D+01,
     *0.42280D+01,0.44440D+01,0.46660D+01,0.48940D+01,0.51290D+01,
     *0.53700D+01,0.56200D+01,0.58770D+01,0.61380D+01,0.64050D+01,
     *0.66810D+01,0.69650D+01,0.72550D+01,0.75510D+01,0.78550D+01,
     *0.81640D+01,0.84850D+01,0.88130D+01,0.91460D+01,0.94860D+01,
     *0.98340D+01,0.10200D+02,0.10570D+02,0.10946D+02,0.11332D+02,
     *0.11729D+02,0.12136D+02,0.12549D+02,0.12972D+02,0.13408D+02,
     *0.13852D+02,0.14309D+02,0.14775D+02,0.15254D+02,0.15743D+02,
     *0.16242D+02,0.16754D+02,0.17276D+02,0.17814D+02,0.18363D+02,
     *0.18929D+02,0.19507D+02,0.20099D+02,0.20708D+02,0.21333D+02,
     *0.21974D+02,0.22630D+02,0.23303D+02,0.23992D+02,0.24698D+02/
!--------------------------------------------------------------------!
!L-gamma6 photon energy in keV (O4--> L2 electron transitions).      !
!                (Table 7c Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX2(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.58910D+01,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.79300D+01,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.10344D+02,0.10733D+02,0.11130D+02,0.11538D+02,0.11955D+02,
     *0.12385D+02,0.12820D+02,0.13270D+02,0.13731D+02,0.14199D+02,
     *0.14683D+02,0.15178D+02,0.15685D+02,0.16203D+02,0.16735D+02,
     *0.17280D+02,0.17839D+02,0.18412D+02,0.18997D+02,0.19599D+02,
     *0.20217D+02,0.20844D+02,0.21491D+02,0.22153D+02,0.22836D+02,
     *0.23527D+02,0.24241D+02,0.24971D+02,0.25723D+02,0.26492D+02/
!--------------------------------------------------------------------!
!L-eta photon energy in keV (M1--> L2 electron transitions).         !
!                (Table 7c Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX2(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.35300D+00,0.40100D+00,0.45400D+00,0.51000D+00,0.56800D+00,
     *0.62800D+00,0.69300D+00,0.76000D+00,0.83100D+00,0.90700D+00,
     *0.98400D+00,0.10680D+01,0.11550D+01,0.12450D+01,0.13390D+01,
     *0.14350D+01,0.15420D+01,0.16490D+01,0.17620D+01,0.18760D+01,
     *0.19960D+01,0.21200D+01,0.22490D+01,0.23820D+01,0.25190D+01,
     *0.26600D+01,0.28060D+01,0.29570D+01,0.31120D+01,0.32720D+01,
     *0.34370D+01,0.36060D+01,0.37800D+01,0.39550D+01,0.41420D+01,
     *0.43310D+01,0.45290D+01,0.47300D+01,0.49290D+01,0.51460D+01,
     *0.53630D+01,0.55890D+01,0.58170D+01,0.60490D+01,0.62840D+01,
     *0.65340D+01,0.67890D+01,0.70580D+01,0.73100D+01,0.75800D+01,
     *0.78570D+01,0.81390D+01,0.84280D+01,0.87240D+01,0.90270D+01,
     *0.93370D+01,0.96500D+01,0.99750D+01,0.10309D+02,0.10647D+02,
     *0.10994D+02,0.11349D+02,0.11712D+02,0.12085D+02,0.12466D+02,
     *0.12855D+02,0.13255D+02,0.13662D+02,0.14082D+02,0.14511D+02,
     *0.14953D+02,0.15400D+02,0.15861D+02,0.16333D+02,0.16819D+02,
     *0.17314D+02,0.17826D+02,0.18347D+02,0.18884D+02,0.19433D+02/
!--------------------------------------------------------------------!
!L-alpha1 photon energy in keV (M5--> L3 electron transitions).      !
!                (Table 7d Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX3(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.39600D+00,0.45200D+00,0.51100D+00,0.57200D+00,0.63700D+00,
     *0.70400D+00,0.77600D+00,0.85100D+00,0.92900D+00,0.10120D+01,
     *0.10980D+01,0.11880D+01,0.12820D+01,0.13790D+01,0.14810D+01,
     *0.15810D+01,0.16940D+01,0.18060D+01,0.19230D+01,0.20420D+01,
     *0.21660D+01,0.22930D+01,0.24240D+01,0.25580D+01,0.26970D+01,
     *0.28390D+01,0.29840D+01,0.31340D+01,0.32870D+01,0.34440D+01,
     *0.36050D+01,0.37690D+01,0.39380D+01,0.41060D+01,0.42860D+01,
     *0.44660D+01,0.46510D+01,0.48400D+01,0.50330D+01,0.52300D+01,
     *0.54320D+01,0.56360D+01,0.58460D+01,0.60580D+01,0.62730D+01,
     *0.64950D+01,0.67200D+01,0.69490D+01,0.71800D+01,0.74160D+01,
     *0.76560D+01,0.78990D+01,0.81460D+01,0.83980D+01,0.86520D+01,
     *0.89110D+01,0.91750D+01,0.94430D+01,0.97130D+01,0.99890D+01,
     *0.10268D+02,0.10551D+02,0.10839D+02,0.11130D+02,0.11426D+02,
     *0.11726D+02,0.12031D+02,0.12339D+02,0.12651D+02,0.12968D+02,
     *0.13291D+02,0.13618D+02,0.13946D+02,0.14282D+02,0.14620D+02,
     *0.14961D+02,0.15308D+02,0.15660D+02,0.16016D+02,0.16377D+02/
!--------------------------------------------------------------------!
!L-alpha2 photon energy in keV (M4--> L3 electron transitions).      !
!                (Table 7d Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX3(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.39600D+00,0.45200D+00,0.51100D+00,0.57200D+00,0.63700D+00,
     *0.70400D+00,0.77600D+00,0.85100D+00,0.92900D+00,0.10120D+01,
     *0.10980D+01,0.11880D+01,0.12820D+01,0.13790D+01,0.14800D+01,
     *0.15800D+01,0.16930D+01,0.18050D+01,0.19200D+01,0.20400D+01,
     *0.21630D+01,0.22900D+01,0.24200D+01,0.25540D+01,0.26920D+01,
     *0.28330D+01,0.29780D+01,0.31270D+01,0.32790D+01,0.34350D+01,
     *0.35950D+01,0.37590D+01,0.39260D+01,0.40930D+01,0.42720D+01,
     *0.44510D+01,0.46340D+01,0.48220D+01,0.50130D+01,0.52080D+01,
     *0.54080D+01,0.56100D+01,0.58160D+01,0.60260D+01,0.62390D+01,
     *0.64580D+01,0.66800D+01,0.69050D+01,0.71330D+01,0.73670D+01,
     *0.76050D+01,0.78440D+01,0.80880D+01,0.83350D+01,0.85860D+01,
     *0.88400D+01,0.90990D+01,0.93620D+01,0.96280D+01,0.98990D+01,
     *0.10172D+02,0.10450D+02,0.10731D+02,0.11016D+02,0.11306D+02,
     *0.11598D+02,0.11896D+02,0.12196D+02,0.12500D+02,0.12809D+02,
     *0.13127D+02,0.13442D+02,0.13761D+02,0.14087D+02,0.14414D+02,
     *0.14746D+02,0.15082D+02,0.15423D+02,0.15767D+02,0.16116D+02/
!--------------------------------------------------------------------!
!L-Beta2  photon energy (N5 --> L 3 electron transition).            !
!                 (Table IV of Storm Israel)                         !
!--------------------------------------------------------------------!
      DATA (ELX3(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.28370D+01,0.30020D+01,
     *0.31710D+01,0.33460D+01,0.35280D+01,0.37140D+01,0.39050D+01,
     *0.41010D+01,0.43010D+01,0.45070D+01,0.47190D+01,0.49330D+01,
     *0.51550D+01,0.53850D+01,0.56180D+01,0.58520D+01,0.60910D+01,
     *0.63370D+01,0.65890D+01,0.68430D+01,0.71030D+01,0.73670D+01,
     *0.76360D+01,0.79110D+01,0.81890D+01,0.84710D+01,0.87550D+01,
     *0.90460D+01,0.93470D+01,0.96520D+01,0.99620D+01,0.10276D+02,
     *0.10597D+02,0.10922D+02,0.11251D+02,0.11585D+02,0.11923D+02,
     *0.12270D+02,0.12622D+02,0.12980D+02,0.13341D+02,0.13708D+02,
     *0.14078D+02,0.14454D+02,0.14836D+02,0.15226D+02,0.15624D+02,
     *0.16025D+02,0.16430D+02,0.16841D+02,0.17262D+02,0.17691D+02,
     *0.18129D+02,0.18575D+02,0.19027D+02,0.19487D+02,0.19955D+02/
!--------------------------------------------------------------------!
!L-beta5 photon energy in keV (O4O5--> L3 electron transitions).     !
!                (Table 7d Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX3(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.54830D+01,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.72430D+01,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.92400D+01,0.95540D+01,0.98750D+01,0.10201D+02,0.10532D+02,
     *0.10871D+02,0.11211D+02,0.11562D+02,0.11916D+02,0.12275D+02,
     *0.12643D+02,0.13015D+02,0.13393D+02,0.13778D+02,0.14168D+02,
     *0.14565D+02,0.14967D+02,0.15375D+02,0.15790D+02,0.16209D+02,
     *0.16639D+02,0.17069D+02,0.17505D+02,0.17950D+02,0.18399D+02,
     *0.18853D+02,0.19312D+02,0.19777D+02,0.20249D+02,0.20727D+02/
!--------------------------------------------------------------------!
!L-beta6 photon energy in keV (N1--> L3 electron transitions).       !
!                (Table 7d Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX3(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.40200D+00,0.45600D+00,0.51300D+00,0.57400D+00,0.64000D+00,
     *0.70800D+00,0.77900D+00,0.85500D+00,0.93100D+00,0.10200D+01,
     *0.11140D+01,0.12120D+01,0.13150D+01,0.14240D+01,0.15230D+01,
     *0.16470D+01,0.17750D+01,0.19020D+01,0.20350D+01,0.21710D+01,
     *0.23120D+01,0.24580D+01,0.26090D+01,0.27630D+01,0.29230D+01,
     *0.30870D+01,0.32560D+01,0.34300D+01,0.36080D+01,0.37920D+01,
     *0.39800D+01,0.41730D+01,0.43710D+01,0.45690D+01,0.47810D+01,
     *0.49940D+01,0.52120D+01,0.54340D+01,0.56600D+01,0.58930D+01,
     *0.61280D+01,0.63700D+01,0.66170D+01,0.68670D+01,0.71160D+01,
     *0.73740D+01,0.76350D+01,0.79090D+01,0.81760D+01,0.84560D+01,
     *0.87380D+01,0.90230D+01,0.93160D+01,0.96120D+01,0.99100D+01,
     *0.10217D+02,0.10525D+02,0.10840D+02,0.11160D+02,0.11481D+02,
     *0.11812D+02,0.12142D+02,0.12480D+02,0.12823D+02,0.13169D+02,
     *0.13520D+02,0.13877D+02,0.14236D+02,0.14601D+02,0.14970D+02,
     *0.15350D+02,0.15727D+02,0.16109D+02,0.16498D+02,0.16890D+02,
     *0.17286D+02,0.17687D+02,0.18094D+02,0.18501D+02,0.18916D+02/
!--------------------------------------------------------------------!
!L-Beta15  photon energy (N 4 --> L 3 electron transition).          !
!                 (Table IV of Storm Israel)                         !
!--------------------------------------------------------------------!
      DATA (ELX3(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.28370D+01,0.30020D+01,
     *0.31710D+01,0.33460D+01,0.35280D+01,0.37140D+01,0.39050D+01,
     *0.41010D+01,0.43010D+01,0.45070D+01,0.47190D+01,0.49330D+01,
     *0.51550D+01,0.53850D+01,0.56180D+01,0.58520D+01,0.60910D+01,
     *0.63370D+01,0.65890D+01,0.68430D+01,0.71030D+01,0.73660D+01,
     *0.76340D+01,0.79070D+01,0.81820D+01,0.84610D+01,0.87450D+01,
     *0.90350D+01,0.93360D+01,0.96400D+01,0.99480D+01,0.10261D+02,
     *0.10580D+02,0.10904D+02,0.11233D+02,0.11566D+02,0.11903D+02,
     *0.12249D+02,0.12600D+02,0.12956D+02,0.13316D+02,0.13681D+02,
     *0.14051D+02,0.14427D+02,0.14808D+02,0.15195D+02,0.15587D+02,
     *0.15987D+02,0.16390D+02,0.16797D+02,0.17214D+02,0.17638D+02,
     *0.18070D+02,0.18509D+02,0.18956D+02,0.19413D+02,0.19880D+02/
!--------------------------------------------------------------------!
!L-l     photon energy in keV (M1--> L3 electron transitions).       !
!                (Table 7d Table of Isotopes Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA (ELX3(7,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.34800D+00,0.39500D+00,0.44600D+00,0.50000D+00,0.55600D+00,
     *0.61500D+00,0.67800D+00,0.74300D+00,0.81100D+00,0.88400D+00,
     *0.95700D+00,0.10370D+01,0.11200D+01,0.12040D+01,0.12930D+01,
     *0.13830D+01,0.14820D+01,0.15820D+01,0.16860D+01,0.17920D+01,
     *0.19020D+01,0.20160D+01,0.21330D+01,0.22530D+01,0.23770D+01,
     *0.25030D+01,0.26340D+01,0.27670D+01,0.29050D+01,0.30450D+01,
     *0.31890D+01,0.33350D+01,0.34850D+01,0.36340D+01,0.37950D+01,
     *0.39540D+01,0.41210D+01,0.42890D+01,0.44530D+01,0.46330D+01,
     *0.48090D+01,0.49930D+01,0.51770D+01,0.53620D+01,0.55460D+01,
     *0.57430D+01,0.59430D+01,0.61510D+01,0.63410D+01,0.65450D+01,
     *0.67530D+01,0.69600D+01,0.71730D+01,0.73870D+01,0.76040D+01,
     *0.78220D+01,0.80420D+01,0.82660D+01,0.84940D+01,0.87220D+01,
     *0.89530D+01,0.91840D+01,0.94200D+01,0.96580D+01,0.98970D+01,
     *0.10137D+02,0.10381D+02,0.10622D+02,0.10871D+02,0.11118D+02,
     *0.11372D+02,0.11620D+02,0.11871D+02,0.12124D+02,0.12377D+02,
     *0.12633D+02,0.12890D+02,0.13146D+02,0.13403D+02,0.13660D+02/
!---------------------------------------------------------------------!
!PM0(K) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3       !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM0(1,IIZ),IIZ=1,100)/
     *0.23503D+01,0.59186D+01,0.78158D+01,0.90023D+01,0.98828D+01,
     *0.10544D+02,0.11135D+02,0.11622D+02,0.11956D+02,0.12313D+02,
     *0.12455D+02,0.12757D+02,0.12887D+02,0.13061D+02,0.13090D+02,
     *0.13258D+02,0.13425D+02,0.13300D+02,0.13440D+02,0.13481D+02,
     *0.13500D+02,0.13605D+02,0.13605D+02,0.13551D+02,0.13450D+02,
     *0.13389D+02,0.13289D+02,0.13146D+02,0.13054D+02,0.13322D+02,
     *0.13090D+02,0.13050D+02,0.13009D+02,0.12916D+02,0.12849D+02,
     *0.12747D+02,0.12564D+02,0.12525D+02,0.12439D+02,0.12282D+02,
     *0.12308D+02,0.12083D+02,0.11964D+02,0.11813D+02,0.11848D+02,
     *0.11666D+02,0.11473D+02,0.11371D+02,0.11333D+02,0.11312D+02,
     *0.10953D+02,0.10946D+02,0.10975D+02,0.10798D+02,0.10698D+02,
     *0.10542D+02,0.10363D+02,0.10659D+02,0.10452D+02,0.97405D+01,
     *0.98486D+01,0.10127D+02,0.10067D+02,0.10033D+02,0.98017D+01,
     *0.92128D+01,0.93958D+01,0.98396D+01,0.10082D+02,0.95777D+01,
     *0.91113D+01,0.94043D+01,0.92843D+01,0.94191D+01,0.92342D+01,
     *0.99658D+01,0.95330D+01,0.90402D+01,0.93968D+01,0.98871D+01,
     *0.87164D+01,0.92839D+01,0.10329D+02,0.85480D+01,0.95395D+01,
     *0.84097D+01,0.97627D+01,0.98375D+01,0.88785D+01,0.93921D+01,
     *0.10857D+02,0.10013D+02,0.93384D+01,0.12049D+02,0.11875D+02,
     *0.11779D+02,0.10028D+02,0.12059D+02,0.11001D+02,0.12996D+02/
!---------------------------------------------------------------------!
!PM1(K) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3       !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM1(1,IIZ),IIZ=1,100)/
     *-.31059D+01,-.29804D+01,-.28924D+01,-.27639D+01,-.26731D+01,
     *-.25613D+01,-.25218D+01,-.24713D+01,-.23473D+01,-.23130D+01,
     *-.20992D+01,-.20880D+01,-.19430D+01,-.18677D+01,-.16778D+01,
     *-.16365D+01,-.16087D+01,-.13585D+01,-.13201D+01,-.12258D+01,
     *-.11165D+01,-.10928D+01,-.98174D+00,-.84665D+00,-.69379D+00,
     *-.57157D+00,-.42405D+00,-.25841D+00,-.13131D+00,-.24491D+00,
     *-.32034D-01,0.49935D-01,0.13418D+00,0.24545D+00,0.33295D+00,
     *0.44300D+00,0.60430D+00,0.67230D+00,0.76539D+00,0.89714D+00,
     *0.90761D+00,0.10741D+01,0.11914D+01,0.13022D+01,0.13122D+01,
     *0.14535D+01,0.15952D+01,0.16784D+01,0.17260D+01,0.17613D+01,
     *0.19957D+01,0.20214D+01,0.20250D+01,0.21421D+01,0.22179D+01,
     *0.23294D+01,0.24527D+01,0.22968D+01,0.24320D+01,0.28436D+01,
     *0.27891D+01,0.26450D+01,0.26979D+01,0.27274D+01,0.28654D+01,
     *0.32023D+01,0.31222D+01,0.28678D+01,0.27627D+01,0.30374D+01,
     *0.33001D+01,0.31539D+01,0.32212D+01,0.31421D+01,0.32704D+01,
     *0.28559D+01,0.31065D+01,0.33796D+01,0.31784D+01,0.29445D+01,
     *0.35605D+01,0.32244D+01,0.26967D+01,0.36454D+01,0.31307D+01,
     *0.36996D+01,0.29753D+01,0.29692D+01,0.34306D+01,0.31771D+01,
     *0.23868D+01,0.28464D+01,0.31651D+01,0.17785D+01,0.18523D+01,
     *0.18955D+01,0.27876D+01,0.17598D+01,0.23171D+01,0.12794D+01/
!---------------------------------------------------------------------!
!PM2(K) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3       !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM2(1,IIZ),IIZ=1,100)/
     *-.15245D+00,-.17455D+00,-.17914D+00,-.20402D+00,-.21555D+00,
     *-.23378D+00,-.23297D+00,-.23674D+00,-.26026D+00,-.25889D+00,
     *-.30863D+00,-.30218D+00,-.33217D+00,-.34302D+00,-.38528D+00,
     *-.38825D+00,-.38823D+00,-.44204D+00,-.44625D+00,-.46250D+00,
     *-.48327D+00,-.48205D+00,-.50375D+00,-.52945D+00,-.55758D+00,
     *-.57941D+00,-.60728D+00,-.63802D+00,-.66035D+00,-.63224D+00,
     *-.67266D+00,-.68556D+00,-.69935D+00,-.71873D+00,-.73194D+00,
     *-.75034D+00,-.78007D+00,-.79046D+00,-.80569D+00,-.82737D+00,
     *-.82446D+00,-.85315D+00,-.87451D+00,-.89057D+00,-.88985D+00,
     *-.91453D+00,-.93850D+00,-.95088D+00,-.95679D+00,-.95992D+00,
     *-.10016D+01,-.10037D+01,-.10012D+01,-.10197D+01,-.10303D+01,
     *-.10489D+01,-.10694D+01,-.10371D+01,-.10596D+01,-.11315D+01,
     *-.11171D+01,-.10877D+01,-.10961D+01,-.10984D+01,-.11200D+01,
     *-.11782D+01,-.11630D+01,-.11105D+01,-.10923D+01,-.11372D+01,
     *-.11814D+01,-.11535D+01,-.11621D+01,-.11435D+01,-.11670D+01,
     *-.10865D+01,-.11302D+01,-.11766D+01,-.11358D+01,-.10966D+01,
     *-.11996D+01,-.11319D+01,-.10419D+01,-.12049D+01,-.11138D+01,
     *-.12058D+01,-.10756D+01,-.10774D+01,-.11473D+01,-.11037D+01,
     *-.96128D+00,-.10409D+01,-.10883D+01,-.85188D+00,-.86017D+00,
     *-.86388D+00,-.10126D+01,-.83818D+00,-.93409D+00,-.75389D+00/
!---------------------------------------------------------------------!
!PM3(K) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3       !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM3(1,IIZ),IIZ=1,100)/
     *0.18812D-01,0.20159D-01,0.19714D-01,0.21563D-01,0.21994D-01,
     *0.23017D-01,0.22575D-01,0.22577D-01,0.24150D-01,0.23683D-01,
     *0.27447D-01,0.26617D-01,0.28739D-01,0.29277D-01,0.32391D-01,
     *0.32372D-01,0.32159D-01,0.35948D-01,0.36114D-01,0.37110D-01,
     *0.38480D-01,0.38151D-01,0.39612D-01,0.41283D-01,0.43049D-01,
     *0.44403D-01,0.46204D-01,0.48134D-01,0.49488D-01,0.47438D-01,
     *0.50015D-01,0.50735D-01,0.51522D-01,0.52693D-01,0.53382D-01,
     *0.54440D-01,0.56323D-01,0.56889D-01,0.57770D-01,0.58965D-01,
     *0.58580D-01,0.60270D-01,0.61595D-01,0.62365D-01,0.62251D-01,
     *0.63722D-01,0.65107D-01,0.65755D-01,0.66008D-01,0.66060D-01,
     *0.68553D-01,0.68606D-01,0.68326D-01,0.69346D-01,0.69836D-01,
     *0.70912D-01,0.72084D-01,0.70010D-01,0.71297D-01,0.75468D-01,
     *0.74424D-01,0.72560D-01,0.73054D-01,0.73087D-01,0.74242D-01,
     *0.77596D-01,0.76713D-01,0.73295D-01,0.72327D-01,0.74791D-01,
     *0.77294D-01,0.75610D-01,0.75995D-01,0.74732D-01,0.76197D-01,
     *0.71160D-01,0.73726D-01,0.76398D-01,0.73772D-01,0.71703D-01,
     *0.77400D-01,0.73078D-01,0.68115D-01,0.77397D-01,0.72134D-01,
     *0.77104D-01,0.69480D-01,0.69801D-01,0.73299D-01,0.70900D-01,
     *0.62526D-01,0.67140D-01,0.69502D-01,0.56244D-01,0.56570D-01,
     *0.56627D-01,0.64918D-01,0.55164D-01,0.60736D-01,0.50461D-01/
!---------------------------------------------------------------------!
!PM0(L1) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM0(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.35463D+01,0.56873D+01,0.67570D+01,
     *0.74942D+01,0.80556D+01,0.85054D+01,0.88830D+01,0.91951D+01,
     *0.95599D+01,0.98206D+01,0.10048D+02,0.10244D+02,0.10433D+02,
     *0.10619D+02,0.10731D+02,0.10919D+02,0.11018D+02,0.11146D+02,
     *0.11243D+02,0.11335D+02,0.11428D+02,0.11466D+02,0.11523D+02,
     *0.11618D+02,0.11657D+02,0.11724D+02,0.11739D+02,0.11783D+02,
     *0.11763D+02,0.11824D+02,0.11713D+02,0.11745D+02,0.11800D+02,
     *0.11809D+02,0.11847D+02,0.11778D+02,0.11694D+02,0.11709D+02,
     *0.11716D+02,0.11749D+02,0.11550D+02,0.11672D+02,0.11555D+02,
     *0.11570D+02,0.11581D+02,0.11516D+02,0.11489D+02,0.11525D+02,
     *0.11376D+02,0.11385D+02,0.11265D+02,0.11308D+02,0.11172D+02,
     *0.11164D+02,0.11049D+02,0.10987D+02,0.10972D+02,0.10876D+02,
     *0.10865D+02,0.10816D+02,0.10697D+02,0.10672D+02,0.10550D+02,
     *0.10490D+02,0.10438D+02,0.10386D+02,0.10282D+02,0.10190D+02,
     *0.10196D+02,0.10060D+02,0.10061D+02,0.99774D+01,0.98548D+01,
     *0.97760D+01,0.97083D+01,0.96183D+01,0.96124D+01,0.94898D+01,
     *0.94345D+01,0.93071D+01,0.92491D+01,0.91799D+01,0.90150D+01,
     *0.89785D+01,0.89466D+01,0.88739D+01,0.85317D+01,0.85761D+01,
     *0.84456D+01,0.84186D+01,0.83789D+01,0.83830D+01,0.82625D+01,
     *0.80395D+01,0.78077D+01,0.77794D+01,0.78400D+01,0.77913D+01/
!---------------------------------------------------------------------!
!PM1(L1) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM1(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,-.28513D+01,-.27067D+01,-.25990D+01,
     *-.24934D+01,-.23968D+01,-.23127D+01,-.22355D+01,-.21556D+01,
     *-.21305D+01,-.20389D+01,-.19553D+01,-.18748D+01,-.18187D+01,
     *-.17856D+01,-.16963D+01,-.17045D+01,-.16341D+01,-.16037D+01,
     *-.15548D+01,-.15185D+01,-.14857D+01,-.14096D+01,-.13625D+01,
     *-.13537D+01,-.12935D+01,-.12732D+01,-.12081D+01,-.11748D+01,
     *-.10901D+01,-.10730D+01,-.91934D+00,-.88193D+00,-.87410D+00,
     *-.83465D+00,-.81803D+00,-.71390D+00,-.61017D+00,-.57284D+00,
     *-.54839D+00,-.53175D+00,-.34314D+00,-.40341D+00,-.28079D+00,
     *-.26583D+00,-.24905D+00,-.17203D+00,-.12368D+00,-.13033D+00,
     *0.37320D-02,0.18208D-01,0.12559D+00,0.11527D+00,0.22646D+00,
     *0.25232D+00,0.34817D+00,0.40626D+00,0.43045D+00,0.51168D+00,
     *0.52998D+00,0.57802D+00,0.66781D+00,0.68754D+00,0.78272D+00,
     *0.83196D+00,0.87792D+00,0.92117D+00,0.98983D+00,0.10583D+01,
     *0.10550D+01,0.11539D+01,0.11545D+01,0.12142D+01,0.13032D+01,
     *0.13531D+01,0.13930D+01,0.14562D+01,0.14613D+01,0.15428D+01,
     *0.15701D+01,0.16516D+01,0.16880D+01,0.17258D+01,0.18248D+01,
     *0.18473D+01,0.18645D+01,0.19079D+01,0.21079D+01,0.20813D+01,
     *0.21587D+01,0.21682D+01,0.21833D+01,0.21772D+01,0.22371D+01,
     *0.23716D+01,0.25036D+01,0.25040D+01,0.24571D+01,0.24777D+01/
!---------------------------------------------------------------------!
!PM2(L1) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM2(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,-.19110D+00,-.21767D+00,-.23208D+00,
     *-.24834D+00,-.26111D+00,-.27000D+00,-.27934D+00,-.29030D+00,
     *-.28349D+00,-.29780D+00,-.30992D+00,-.32167D+00,-.32616D+00,
     *-.32475D+00,-.33979D+00,-.32749D+00,-.33744D+00,-.33756D+00,
     *-.34240D+00,-.34323D+00,-.34435D+00,-.35736D+00,-.36211D+00,
     *-.35773D+00,-.36741D+00,-.36585D+00,-.37651D+00,-.37870D+00,
     *-.39414D+00,-.39337D+00,-.42623D+00,-.43148D+00,-.42813D+00,
     *-.43198D+00,-.43070D+00,-.45184D+00,-.47072D+00,-.47651D+00,
     *-.47641D+00,-.47656D+00,-.51656D+00,-.49810D+00,-.52342D+00,
     *-.52141D+00,-.52061D+00,-.53494D+00,-.54216D+00,-.53601D+00,
     *-.56271D+00,-.56208D+00,-.58218D+00,-.57603D+00,-.59623D+00,
     *-.59880D+00,-.61609D+00,-.62495D+00,-.62661D+00,-.64071D+00,
     *-.64046D+00,-.64767D+00,-.66301D+00,-.66204D+00,-.67964D+00,
     *-.68661D+00,-.69364D+00,-.69920D+00,-.70876D+00,-.71996D+00,
     *-.71481D+00,-.73294D+00,-.72882D+00,-.73815D+00,-.75434D+00,
     *-.76029D+00,-.76434D+00,-.77440D+00,-.77208D+00,-.78567D+00,
     *-.78671D+00,-.79980D+00,-.80429D+00,-.80776D+00,-.82377D+00,
     *-.82551D+00,-.82566D+00,-.83102D+00,-.86646D+00,-.85858D+00,
     *-.87103D+00,-.86952D+00,-.86831D+00,-.86443D+00,-.87121D+00,
     *-.89556D+00,-.91807D+00,-.91327D+00,-.90049D+00,-.90146D+00/
!---------------------------------------------------------------------!
!PM3(L1) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM3(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.20752D-01,0.22531D-01,0.23130D-01,
     *0.24086D-01,0.24632D-01,0.24841D-01,0.25244D-01,0.25859D-01,
     *0.24746D-01,0.25578D-01,0.26226D-01,0.26867D-01,0.26867D-01,
     *0.26423D-01,0.27361D-01,0.26050D-01,0.26563D-01,0.26350D-01,
     *0.26483D-01,0.26267D-01,0.26142D-01,0.26975D-01,0.27123D-01,
     *0.26596D-01,0.27194D-01,0.26879D-01,0.27541D-01,0.27538D-01,
     *0.28553D-01,0.28371D-01,0.30726D-01,0.31056D-01,0.30655D-01,
     *0.30764D-01,0.30513D-01,0.32019D-01,0.33214D-01,0.33604D-01,
     *0.33403D-01,0.33330D-01,0.36139D-01,0.34677D-01,0.36485D-01,
     *0.36131D-01,0.35937D-01,0.36911D-01,0.37320D-01,0.36747D-01,
     *0.38549D-01,0.38402D-01,0.39713D-01,0.39170D-01,0.40437D-01,
     *0.40567D-01,0.41664D-01,0.42165D-01,0.42193D-01,0.43061D-01,
     *0.42904D-01,0.43332D-01,0.44256D-01,0.43987D-01,0.45150D-01,
     *0.45526D-01,0.45961D-01,0.46227D-01,0.46687D-01,0.47363D-01,
     *0.46859D-01,0.48032D-01,0.47611D-01,0.48163D-01,0.49207D-01,
     *0.49447D-01,0.49585D-01,0.50176D-01,0.49931D-01,0.50743D-01,
     *0.50663D-01,0.51409D-01,0.51646D-01,0.51736D-01,0.52647D-01,
     *0.52708D-01,0.52626D-01,0.52876D-01,0.55019D-01,0.54460D-01,
     *0.55192D-01,0.55013D-01,0.54789D-01,0.54496D-01,0.54734D-01,
     *0.56277D-01,0.57619D-01,0.57144D-01,0.56234D-01,0.56230D-01/
!---------------------------------------------------------------------!
!PM0(L2) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM0(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.13821D+01,
     *0.33896D+01,0.47594D+01,0.58136D+01,0.67001D+01,0.74415D+01,
     *0.80774D+01,0.85726D+01,0.90111D+01,0.93997D+01,0.97523D+01,
     *0.10096D+02,0.10390D+02,0.10626D+02,0.10900D+02,0.11104D+02,
     *0.11337D+02,0.11535D+02,0.11726D+02,0.11909D+02,0.12049D+02,
     *0.12209D+02,0.12350D+02,0.12507D+02,0.12676D+02,0.12747D+02,
     *0.12840D+02,0.12926D+02,0.12940D+02,0.13075D+02,0.13127D+02,
     *0.13234D+02,0.13236D+02,0.13359D+02,0.13381D+02,0.13385D+02,
     *0.13456D+02,0.13562D+02,0.13500D+02,0.13500D+02,0.13656D+02,
     *0.13605D+02,0.13494D+02,0.13674D+02,0.13548D+02,0.13707D+02,
     *0.13549D+02,0.13545D+02,0.13659D+02,0.13490D+02,0.13639D+02,
     *0.13520D+02,0.13723D+02,0.13479D+02,0.13676D+02,0.13590D+02,
     *0.13634D+02,0.13470D+02,0.13547D+02,0.13770D+02,0.13454D+02,
     *0.13637D+02,0.13301D+02,0.13460D+02,0.13565D+02,0.13758D+02,
     *0.13367D+02,0.13374D+02,0.13337D+02,0.13345D+02,0.13333D+02,
     *0.13279D+02,0.13270D+02,0.13223D+02,0.13111D+02,0.13154D+02,
     *0.13074D+02,0.13010D+02,0.13078D+02,0.12982D+02,0.12967D+02,
     *0.12884D+02,0.12742D+02,0.12729D+02,0.12735D+02,0.12895D+02,
     *0.12662D+02,0.12537D+02,0.12537D+02,0.12360D+02,0.12267D+02,
     *0.12201D+02,0.12104D+02,0.12183D+02,0.11773D+02,0.11746D+02/
!---------------------------------------------------------------------!
!PM1(L2) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM1(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,-.35617D+01,
     *-.35058D+01,-.33869D+01,-.32670D+01,-.31941D+01,-.31058D+01,
     *-.30682D+01,-.29758D+01,-.29020D+01,-.28289D+01,-.27709D+01,
     *-.27453D+01,-.26947D+01,-.26148D+01,-.26049D+01,-.25321D+01,
     *-.25064D+01,-.24688D+01,-.24286D+01,-.24069D+01,-.23461D+01,
     *-.23161D+01,-.22695D+01,-.22745D+01,-.22717D+01,-.21959D+01,
     *-.21373D+01,-.20826D+01,-.19715D+01,-.19834D+01,-.19204D+01,
     *-.19000D+01,-.18024D+01,-.18073D+01,-.17365D+01,-.16514D+01,
     *-.16312D+01,-.16356D+01,-.15089D+01,-.14332D+01,-.14817D+01,
     *-.13882D+01,-.12375D+01,-.13094D+01,-.11503D+01,-.12145D+01,
     *-.10410D+01,-.99464D+00,-.10242D+01,-.84893D+00,-.91523D+00,
     *-.78576D+00,-.88110D+00,-.67059D+00,-.76315D+00,-.67436D+00,
     *-.65696D+00,-.51346D+00,-.52713D+00,-.63746D+00,-.40545D+00,
     *-.48873D+00,-.24081D+00,-.31210D+00,-.35384D+00,-.45341D+00,
     *-.16488D+00,-.14737D+00,-.99714D-01,-.86619D-01,-.56038D-01,
     *0.50655D-02,0.26636D-01,0.83624D-01,0.17797D+00,0.16449D+00,
     *0.24079D+00,0.29658D+00,0.26312D+00,0.34271D+00,0.36754D+00,
     *0.42703D+00,0.53254D+00,0.55526D+00,0.56306D+00,0.47503D+00,
     *0.63074D+00,0.71444D+00,0.72238D+00,0.84501D+00,0.89911D+00,
     *0.93728D+00,0.10088D+01,0.95997D+00,0.12155D+01,0.12368D+01/
!---------------------------------------------------------------------!
!PM2(L2) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM2(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,-.25644D+00,
     *-.25856D+00,-.27734D+00,-.29934D+00,-.30547D+00,-.31942D+00,
     *-.31547D+00,-.33010D+00,-.33816D+00,-.34805D+00,-.35271D+00,
     *-.34823D+00,-.35230D+00,-.36439D+00,-.35647D+00,-.36762D+00,
     *-.36627D+00,-.36682D+00,-.37173D+00,-.36782D+00,-.37698D+00,
     *-.37808D+00,-.38578D+00,-.37300D+00,-.36824D+00,-.38108D+00,
     *-.39159D+00,-.39972D+00,-.42279D+00,-.41241D+00,-.42250D+00,
     *-.42311D+00,-.44225D+00,-.43633D+00,-.44840D+00,-.46454D+00,
     *-.46354D+00,-.45800D+00,-.48389D+00,-.49774D+00,-.48157D+00,
     *-.49712D+00,-.52876D+00,-.50763D+00,-.54094D+00,-.52120D+00,
     *-.55702D+00,-.56169D+00,-.55121D+00,-.58727D+00,-.56696D+00,
     *-.59167D+00,-.56703D+00,-.60886D+00,-.58513D+00,-.59908D+00,
     *-.60032D+00,-.62653D+00,-.61977D+00,-.59318D+00,-.63640D+00,
     *-.61595D+00,-.66368D+00,-.64541D+00,-.63245D+00,-.60725D+00,
     *-.66500D+00,-.66398D+00,-.66949D+00,-.66749D+00,-.66966D+00,
     *-.67879D+00,-.67878D+00,-.68751D+00,-.70329D+00,-.69557D+00,
     *-.70842D+00,-.71554D+00,-.70350D+00,-.71644D+00,-.71730D+00,
     *-.72431D+00,-.74140D+00,-.74229D+00,-.73967D+00,-.71750D+00,
     *-.74456D+00,-.75651D+00,-.75370D+00,-.77413D+00,-.77929D+00,
     *-.78054D+00,-.79150D+00,-.77635D+00,-.82233D+00,-.82209D+00/
!---------------------------------------------------------------------!
!PM3(L2) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM3(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.31011D-01,
     *0.30980D-01,0.31890D-01,0.33427D-01,0.33519D-01,0.34431D-01,
     *0.33584D-01,0.34516D-01,0.34797D-01,0.35331D-01,0.35367D-01,
     *0.34640D-01,0.34658D-01,0.35380D-01,0.34374D-01,0.35044D-01,
     *0.34738D-01,0.34446D-01,0.34824D-01,0.34156D-01,0.34711D-01,
     *0.34658D-01,0.35260D-01,0.33755D-01,0.33279D-01,0.34091D-01,
     *0.34852D-01,0.35330D-01,0.37005D-01,0.35971D-01,0.36611D-01,
     *0.36558D-01,0.37912D-01,0.37366D-01,0.38141D-01,0.39251D-01,
     *0.39010D-01,0.38509D-01,0.40323D-01,0.41260D-01,0.39926D-01,
     *0.40867D-01,0.43136D-01,0.41483D-01,0.43833D-01,0.42256D-01,
     *0.44754D-01,0.44898D-01,0.44055D-01,0.46565D-01,0.44945D-01,
     *0.46586D-01,0.44773D-01,0.47568D-01,0.45838D-01,0.46642D-01,
     *0.46697D-01,0.48355D-01,0.47766D-01,0.45897D-01,0.48608D-01,
     *0.47181D-01,0.50267D-01,0.48962D-01,0.47956D-01,0.46117D-01,
     *0.49982D-01,0.49752D-01,0.49969D-01,0.49686D-01,0.49697D-01,
     *0.50204D-01,0.50082D-01,0.50607D-01,0.51547D-01,0.50865D-01,
     *0.51664D-01,0.52002D-01,0.51032D-01,0.51821D-01,0.51748D-01,
     *0.52039D-01,0.53003D-01,0.52971D-01,0.52680D-01,0.51078D-01,
     *0.52714D-01,0.53341D-01,0.53019D-01,0.54208D-01,0.54361D-01,
     *0.54193D-01,0.54834D-01,0.53670D-01,0.56477D-01,0.56332D-01/
!---------------------------------------------------------------------!
!PM0(L3) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM0(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.20442D+01,
     *0.40374D+01,0.54086D+01,0.64706D+01,0.73510D+01,0.80867D+01,
     *0.87367D+01,0.92219D+01,0.96590D+01,0.10061D+02,0.10388D+02,
     *0.10700D+02,0.10992D+02,0.11283D+02,0.11518D+02,0.11771D+02,
     *0.11984D+02,0.12165D+02,0.12363D+02,0.12501D+02,0.12696D+02,
     *0.12838D+02,0.12976D+02,0.13174D+02,0.13288D+02,0.13310D+02,
     *0.13409D+02,0.13485D+02,0.13634D+02,0.13741D+02,0.13824D+02,
     *0.13903D+02,0.13882D+02,0.13926D+02,0.13950D+02,0.14092D+02,
     *0.14086D+02,0.14068D+02,0.14112D+02,0.14209D+02,0.14158D+02,
     *0.14070D+02,0.14273D+02,0.14205D+02,0.14146D+02,0.14112D+02,
     *0.14199D+02,0.14085D+02,0.14171D+02,0.14183D+02,0.14220D+02,
     *0.14296D+02,0.14143D+02,0.14100D+02,0.14221D+02,0.14069D+02,
     *0.14124D+02,0.14038D+02,0.14094D+02,0.14149D+02,0.14109D+02,
     *0.14055D+02,0.13985D+02,0.13977D+02,0.14084D+02,0.13818D+02,
     *0.14142D+02,0.13701D+02,0.14074D+02,0.13811D+02,0.13851D+02,
     *0.13667D+02,0.14047D+02,0.13768D+02,0.13817D+02,0.14041D+02,
     *0.13672D+02,0.13788D+02,0.14060D+02,0.13684D+02,0.14024D+02,
     *0.13979D+02,0.13582D+02,0.13718D+02,0.13964D+02,0.13499D+02,
     *0.13693D+02,0.13796D+02,0.13461D+02,0.13514D+02,0.13752D+02,
     *0.13864D+02,0.13715D+02,0.13511D+02,0.13692D+02,0.13694D+02/
!---------------------------------------------------------------------!
!PM1(L3) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM1(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,-.34856D+01,
     *-.34126D+01,-.32997D+01,-.31983D+01,-.31150D+01,-.30191D+01,
     *-.29889D+01,-.28921D+01,-.28261D+01,-.27724D+01,-.26891D+01,
     *-.26321D+01,-.25829D+01,-.25690D+01,-.25112D+01,-.24956D+01,
     *-.24603D+01,-.23970D+01,-.23770D+01,-.23052D+01,-.22970D+01,
     *-.22497D+01,-.22246D+01,-.22451D+01,-.22018D+01,-.20700D+01,
     *-.20187D+01,-.19639D+01,-.19772D+01,-.19640D+01,-.19226D+01,
     *-.18811D+01,-.17605D+01,-.17113D+01,-.16436D+01,-.16619D+01,
     *-.15703D+01,-.14762D+01,-.14445D+01,-.14572D+01,-.13408D+01,
     *-.12001D+01,-.12967D+01,-.11760D+01,-.10683D+01,-.98707D+00,
     *-.10069D+01,-.86369D+00,-.86616D+00,-.83844D+00,-.81524D+00,
     *-.82505D+00,-.67470D+00,-.60223D+00,-.64735D+00,-.48848D+00,
     *-.49811D+00,-.38990D+00,-.41306D+00,-.40579D+00,-.33885D+00,
     *-.27615D+00,-.19451D+00,-.16678D+00,-.20921D+00,0.10563D-02,
     *-.17655D+00,0.12974D+00,-.78882D-01,0.10395D+00,0.11945D+00,
     *0.24121D+00,0.26119D-01,0.23479D+00,0.22300D+00,0.10335D+00,
     *0.35660D+00,0.29894D+00,0.14711D+00,0.40559D+00,0.20891D+00,
     *0.25216D+00,0.52388D+00,0.45453D+00,0.31014D+00,0.62477D+00,
     *0.51287D+00,0.46837D+00,0.69064D+00,0.67768D+00,0.53397D+00,
     *0.47927D+00,0.59476D+00,0.72818D+00,0.63096D+00,0.64353D+00/
!---------------------------------------------------------------------!
!PM2(L3) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM2(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,-.30150D+00,
     *-.30367D+00,-.32203D+00,-.33559D+00,-.34585D+00,-.36430D+00,
     *-.36037D+00,-.37458D+00,-.37767D+00,-.38149D+00,-.39497D+00,
     *-.39849D+00,-.40248D+00,-.39448D+00,-.40152D+00,-.39781D+00,
     *-.39622D+00,-.40828D+00,-.40419D+00,-.41624D+00,-.41173D+00,
     *-.41777D+00,-.41530D+00,-.40392D+00,-.40851D+00,-.43897D+00,
     *-.44728D+00,-.45502D+00,-.44569D+00,-.44261D+00,-.45095D+00,
     *-.45480D+00,-.48046D+00,-.48698D+00,-.49833D+00,-.49109D+00,
     *-.50965D+00,-.52850D+00,-.53016D+00,-.52151D+00,-.54644D+00,
     *-.57688D+00,-.54885D+00,-.57427D+00,-.59641D+00,-.61118D+00,
     *-.60102D+00,-.63139D+00,-.62857D+00,-.62945D+00,-.63141D+00,
     *-.62526D+00,-.65498D+00,-.66731D+00,-.65367D+00,-.68746D+00,
     *-.68062D+00,-.70254D+00,-.69058D+00,-.69075D+00,-.70263D+00,
     *-.71167D+00,-.72693D+00,-.72786D+00,-.71544D+00,-.75801D+00,
     *-.71850D+00,-.77766D+00,-.73308D+00,-.76585D+00,-.76840D+00,
     *-.78732D+00,-.74082D+00,-.78206D+00,-.77632D+00,-.74915D+00,
     *-.79773D+00,-.78192D+00,-.74819D+00,-.79837D+00,-.75562D+00,
     *-.76100D+00,-.81379D+00,-.79711D+00,-.76356D+00,-.82557D+00,
     *-.79921D+00,-.78861D+00,-.83044D+00,-.82568D+00,-.79224D+00,
     *-.77902D+00,-.80143D+00,-.82436D+00,-.80273D+00,-.80263D+00/
!---------------------------------------------------------------------!
!PM3(L3) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3      !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM3(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.36505D-01,
     *0.35766D-01,0.36752D-01,0.37308D-01,0.37717D-01,0.39232D-01,
     *0.38459D-01,0.39142D-01,0.38715D-01,0.38695D-01,0.39669D-01,
     *0.39422D-01,0.39513D-01,0.38359D-01,0.38673D-01,0.38241D-01,
     *0.37617D-01,0.38618D-01,0.37932D-01,0.38685D-01,0.38143D-01,
     *0.38437D-01,0.37922D-01,0.36848D-01,0.36996D-01,0.39348D-01,
     *0.39870D-01,0.40276D-01,0.39371D-01,0.38934D-01,0.39645D-01,
     *0.39646D-01,0.41482D-01,0.41814D-01,0.42492D-01,0.41915D-01,
     *0.43209D-01,0.44524D-01,0.44426D-01,0.43595D-01,0.45394D-01,
     *0.47585D-01,0.45326D-01,0.47114D-01,0.48682D-01,0.49614D-01,
     *0.48665D-01,0.50808D-01,0.50560D-01,0.50434D-01,0.50462D-01,
     *0.49889D-01,0.51858D-01,0.52596D-01,0.51513D-01,0.53881D-01,
     *0.53236D-01,0.54727D-01,0.53578D-01,0.53593D-01,0.54330D-01,
     *0.54776D-01,0.55774D-01,0.55618D-01,0.54652D-01,0.57496D-01,
     *0.54756D-01,0.58511D-01,0.55554D-01,0.57513D-01,0.57689D-01,
     *0.58663D-01,0.55502D-01,0.58197D-01,0.57692D-01,0.55802D-01,
     *0.58884D-01,0.57656D-01,0.55331D-01,0.58548D-01,0.55648D-01,
     *0.55854D-01,0.59226D-01,0.58054D-01,0.55650D-01,0.59661D-01,
     *0.57774D-01,0.57055D-01,0.59665D-01,0.59265D-01,0.56870D-01,
     *0.55941D-01,0.57407D-01,0.58729D-01,0.57242D-01,0.57133D-01/
!---------------------------------------------------------------------!
!PM0(M) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3       !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM0(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.53383D+01,0.68335D+01,0.74775D+01,0.80060D+01,0.84739D+01,
     *0.88860D+01,0.92842D+01,0.96612D+01,0.99956D+01,0.10292D+02,
     *0.10501D+02,0.10690D+02,0.10883D+02,0.11024D+02,0.11209D+02,
     *0.11372D+02,0.11524D+02,0.11709D+02,0.11837D+02,0.12003D+02,
     *0.12142D+02,0.12284D+02,0.12419D+02,0.12544D+02,0.12675D+02,
     *0.12791D+02,0.12891D+02,0.13003D+02,0.13091D+02,0.13177D+02,
     *0.13275D+02,0.13348D+02,0.13443D+02,0.13518D+02,0.13540D+02,
     *0.13552D+02,0.13719D+02,0.13771D+02,0.13844D+02,0.13890D+02,
     *0.13945D+02,0.14023D+02,0.14054D+02,0.14099D+02,0.14137D+02,
     *0.14156D+02,0.14201D+02,0.14281D+02,0.14298D+02,0.14326D+02,
     *0.14347D+02,0.14400D+02,0.14397D+02,0.14439D+02,0.14480D+02,
     *0.14500D+02,0.14448D+02,0.14483D+02,0.14546D+02,0.14569D+02,
     *0.14583D+02,0.14615D+02,0.14651D+02,0.14584D+02,0.14609D+02,
     *0.14642D+02,0.14665D+02,0.14665D+02,0.14675D+02,0.14733D+02,
     *0.14721D+02,0.14751D+02,0.14781D+02,0.14775D+02,0.14804D+02,
     *0.14819D+02,0.14824D+02,0.14766D+02,0.14827D+02,0.14841D+02,
     *0.14849D+02,0.14933D+02,0.14944D+02,0.14933D+02,0.14892D+02,
     *0.14932D+02,0.14985D+02,0.14989D+02,0.14955D+02,0.14972D+02/
!---------------------------------------------------------------------!
!PM1(M) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3       !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM1(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *-.21300D+01,-.20850D+01,-.20040D+01,-.20399D+01,-.20801D+01,
     *-.21365D+01,-.21759D+01,-.22282D+01,-.22350D+01,-.22266D+01,
     *-.22038D+01,-.21784D+01,-.22006D+01,-.21973D+01,-.21730D+01,
     *-.21775D+01,-.21790D+01,-.22183D+01,-.22285D+01,-.22351D+01,
     *-.22139D+01,-.22086D+01,-.21928D+01,-.21648D+01,-.21674D+01,
     *-.21418D+01,-.20988D+01,-.20840D+01,-.20533D+01,-.20208D+01,
     *-.20154D+01,-.19774D+01,-.19720D+01,-.19461D+01,-.18782D+01,
     *-.18054D+01,-.18689D+01,-.18309D+01,-.18178D+01,-.17800D+01,
     *-.17542D+01,-.17574D+01,-.17085D+01,-.16784D+01,-.16495D+01,
     *-.16053D+01,-.15751D+01,-.15945D+01,-.15518D+01,-.15269D+01,
     *-.14917D+01,-.14890D+01,-.14378D+01,-.14234D+01,-.14137D+01,
     *-.13868D+01,-.13017D+01,-.12909D+01,-.13028D+01,-.12832D+01,
     *-.12532D+01,-.12379D+01,-.12318D+01,-.11486D+01,-.11307D+01,
     *-.11259D+01,-.11078D+01,-.10759D+01,-.10525D+01,-.10638D+01,
     *-.10238D+01,-.10189D+01,-.10107D+01,-.97785D+00,-.96818D+00,
     *-.95279D+00,-.93590D+00,-.87050D+00,-.88704D+00,-.87294D+00,
     *-.85761D+00,-.89230D+00,-.87713D+00,-.84903D+00,-.79757D+00,
     *-.80635D+00,-.82335D+00,-.80532D+00,-.77204D+00,-.76438D+00/
!---------------------------------------------------------------------!
!PM2(M) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3       !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM2(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *-.29350D+00,-.28229D+00,-.29835D+00,-.28725D+00,-.26788D+00,
     *-.25113D+00,-.23956D+00,-.22524D+00,-.22123D+00,-.21586D+00,
     *-.21976D+00,-.22557D+00,-.21293D+00,-.21265D+00,-.21607D+00,
     *-.21191D+00,-.21025D+00,-.19719D+00,-.19526D+00,-.19017D+00,
     *-.19402D+00,-.19305D+00,-.19661D+00,-.20375D+00,-.19937D+00,
     *-.20544D+00,-.21761D+00,-.22071D+00,-.22637D+00,-.23454D+00,
     *-.23370D+00,-.24359D+00,-.24320D+00,-.24871D+00,-.26510D+00,
     *-.28303D+00,-.26506D+00,-.27343D+00,-.27517D+00,-.28362D+00,
     *-.28884D+00,-.28420D+00,-.29649D+00,-.30299D+00,-.30737D+00,
     *-.31642D+00,-.32406D+00,-.31568D+00,-.32547D+00,-.32909D+00,
     *-.33660D+00,-.33475D+00,-.34582D+00,-.34787D+00,-.34863D+00,
     *-.35313D+00,-.37262D+00,-.37296D+00,-.36779D+00,-.37056D+00,
     *-.37652D+00,-.37915D+00,-.37778D+00,-.39509D+00,-.39802D+00,
     *-.39630D+00,-.39948D+00,-.40492D+00,-.40846D+00,-.40410D+00,
     *-.41176D+00,-.41040D+00,-.41079D+00,-.41639D+00,-.41758D+00,
     *-.41893D+00,-.41982D+00,-.43240D+00,-.42732D+00,-.42883D+00,
     *-.42989D+00,-.42077D+00,-.42253D+00,-.42690D+00,-.43688D+00,
     *-.43275D+00,-.42728D+00,-.42985D+00,-.43392D+00,-.43414D+00/
!---------------------------------------------------------------------!
!PM3(M) data ln(sigma)=PM0+PM1(ln(E))+PM2(ln(E))^2+PM3(ln(E))^3       !
!    E in keV.       PHOTX                                            !
!---------------------------------------------------------------------!
      DATA (PM3(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.26839D-01,0.24298D-01,0.25251D-01,0.24711D-01,0.22617D-01,
     *0.21461D-01,0.20495D-01,0.19421D-01,0.19128D-01,0.18429D-01,
     *0.18742D-01,0.19295D-01,0.18042D-01,0.18022D-01,0.18304D-01,
     *0.17894D-01,0.17842D-01,0.16732D-01,0.16718D-01,0.16263D-01,
     *0.16565D-01,0.16429D-01,0.16754D-01,0.17388D-01,0.16894D-01,
     *0.17355D-01,0.18489D-01,0.18823D-01,0.19138D-01,0.19858D-01,
     *0.19727D-01,0.20549D-01,0.20503D-01,0.20901D-01,0.22222D-01,
     *0.23640D-01,0.22200D-01,0.22848D-01,0.22967D-01,0.23620D-01,
     *0.24005D-01,0.23468D-01,0.24492D-01,0.24992D-01,0.25230D-01,
     *0.25850D-01,0.26559D-01,0.25737D-01,0.26507D-01,0.26698D-01,
     *0.27267D-01,0.27052D-01,0.27852D-01,0.28010D-01,0.28026D-01,
     *0.28311D-01,0.29779D-01,0.29732D-01,0.29269D-01,0.29437D-01,
     *0.29869D-01,0.30090D-01,0.29866D-01,0.31066D-01,0.31285D-01,
     *0.31048D-01,0.31287D-01,0.31633D-01,0.31849D-01,0.31492D-01,
     *0.32025D-01,0.31833D-01,0.31841D-01,0.32191D-01,0.32302D-01,
     *0.32322D-01,0.32287D-01,0.33126D-01,0.32752D-01,0.32842D-01,
     *0.32838D-01,0.32189D-01,0.32283D-01,0.32555D-01,0.33250D-01,
     *0.32894D-01,0.32482D-01,0.32654D-01,0.32829D-01,0.32834D-01/
!--------------------------------------------------------------------!
!OMEGAL1 is probability of X-ray emission at L1-Shell absorption     !
!            (Table 3. of Table of Isotopes, Eighth Edition)         !
!--------------------------------------------------------------------!
      DATA OMEGAL1/
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.290D-04,  0.260D-04,  0.300D-04,  0.390D-04,
     *  0.740D-04,  0.120D-03,  0.180D-03,  0.240D-03,  0.310D-03,
     *  0.390D-03,  0.470D-03,  0.580D-03,  0.710D-03,  0.840D-03,
     *  0.100D-02,  0.120D-02,  0.140D-02,  0.160D-02,  0.180D-02,
     *  0.210D-02,  0.240D-02,  0.280D-02,  0.320D-02,  0.360D-02,
     *  0.410D-02,  0.460D-02,  0.510D-02,  0.590D-02,  0.680D-02,
     *  0.940D-02,  0.100D-01,  0.110D-01,  0.120D-01,  0.130D-01,
     *  0.140D-01,  0.160D-01,  0.180D-01,  0.200D-01,  0.370D-01,
     *  0.390D-01,  0.410D-01,  0.440D-01,  0.460D-01,  0.490D-01,
     *  0.520D-01,  0.550D-01,  0.580D-01,  0.610D-01,  0.640D-01,
     *  0.660D-01,  0.710D-01,  0.750D-01,  0.790D-01,  0.830D-01,
     *  0.890D-01,  0.940D-01,  0.100D+00,  0.106D+00,  0.112D+00,
     *  0.120D+00,  0.128D+00,  0.137D+00,  0.147D+00,  0.144D+00,
     *  0.130D+00,  0.120D+00,  0.114D+00,  0.107D+00,  0.107D+00,
     *  0.107D+00,  0.112D+00,  0.117D+00,  0.122D+00,  0.128D+00,
     *  0.134D+00,  0.139D+00,  0.146D+00,  0.153D+00,  0.161D+00,
     *  0.162D+00,  0.176D+00,  0.187D+00,  0.205D+00,  0.218D+00,
     *  0.228D+00,  0.236D+00,  0.244D+00,  0.253D+00,  0.263D+00/
!---------------------------------------------------------------!
!F12  is probability of f12 Coster-Kronig at L1-Shell absorption!
!            (Table 3. of Table of Isotopes, Eighth Edition)    !
!---------------------------------------------------------------!
      DATA F12/
     *   0.00D+00,   0.00D+00,   0.00D+00,   0.00D+00,   0.00D+00,
     *   0.00D+00,   0.00D+00,   0.00D+00,   0.00D+00,   0.00D+00,
     *   0.00D+00,   0.32D+00,   0.32D+00,   0.32D+00,   0.32D+00,
     *   0.32D+00,   0.32D+00,   0.31D+00,   0.31D+00,   0.31D+00,
     *   0.31D+00,   0.31D+00,   0.31D+00,   0.31D+00,   0.30D+00,
     *   0.30D+00,   0.30D+00,   0.30D+00,   0.30D+00,   0.29D+00,
     *   0.29D+00,   0.28D+00,   0.28D+00,   0.28D+00,   0.28D+00,
     *   0.27D+00,   0.27D+00,   0.27D+00,   0.26D+00,   0.26D+00,
     *   0.10D+00,   0.10D+00,   0.10D+00,   0.10D+00,   0.10D+00,
     *   0.10D+00,   0.10D+00,   0.10D+00,   0.10D+00,   0.17D+00,
     *   0.17D+00,   0.18D+00,   0.18D+00,   0.19D+00,   0.19D+00,
     *   0.19D+00,   0.19D+00,   0.19D+00,   0.19D+00,   0.19D+00,
     *   0.19D+00,   0.19D+00,   0.19D+00,   0.19D+00,   0.19D+00,
     *   0.19D+00,   0.19D+00,   0.19D+00,   0.19D+00,   0.19D+00,
     *   0.19D+00,   0.18D+00,   0.18D+00,   0.17D+00,   0.16D+00,
     *   0.16D+00,   0.15D+00,   0.14D+00,   0.14D+00,   0.13D+00,
     *   0.13D+00,   0.12D+00,   0.11D+00,   0.11D+00,   0.10D+00,
     *   0.10D+00,   0.10D+00,   0.90D-01,   0.90D-01,   0.90D-01,
     *   0.80D-01,   0.80D-01,   0.70D-01,   0.50D-01,   0.50D-01,
     *   0.40D-01,   0.40D-01,   0.30D-01,   0.30D-01,   0.30D-01/
!----------------------------------------------------------------------!
!F13  is probability of f13 Coster-Kronig at L1-Shell absorption       !
!            (Table 3. of Table of Isotopes, Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA F13/
     *  0.000E+00,  0.000E+00,  0.000E+00,  0.000E+00,  0.000E+00,
     *  0.000E+00,  0.000E+00,  0.000E+00,  0.000E+00,  0.000E+00,
     *  0.000E+00,  0.640E+00,  0.640E+00,  0.640E+00,  0.630E+00,
     *  0.620E+00,  0.620E+00,  0.620E+00,  0.620E+00,  0.610E+00,
     *  0.600E+00,  0.590E+00,  0.580E+00,  0.570E+00,  0.580E+00,
     *  0.570E+00,  0.560E+00,  0.550E+00,  0.540E+00,  0.540E+00,
     *  0.530E+00,  0.530E+00,  0.530E+00,  0.520E+00,  0.520E+00,
     *  0.520E+00,  0.520E+00,  0.520E+00,  0.520E+00,  0.520E+00,
     *  0.610E+00,  0.610E+00,  0.610E+00,  0.610E+00,  0.600E+00,
     *  0.600E+00,  0.590E+00,  0.590E+00,  0.590E+00,  0.270E+00,
     *  0.280E+00,  0.280E+00,  0.280E+00,  0.280E+00,  0.280E+00,
     *  0.280E+00,  0.291E+00,  0.291E+00,  0.291E+00,  0.301E+00,
     *  0.301E+00,  0.301E+00,  0.301E+00,  0.301E+00,  0.301E+00,
     *  0.301E+00,  0.301E+00,  0.301E+00,  0.292E+00,  0.292E+00,
     *  0.282E+00,  0.282E+00,  0.283E+00,  0.283E+00,  0.333E+00,
     *  0.393E+00,  0.453E+00,  0.503E+00,  0.533E+00,  0.563E+00,
     *  0.573E+00,  0.584E+00,  0.584E+00,  0.584E+00,  0.595E+00,
     *  0.585E+00,  0.586E+00,  0.586E+00,  0.587E+00,  0.578E+00,
     *  0.588E+00,  0.580E+00,  0.581E+00,  0.573E+00,  0.564E+00,
     *  0.566E+00,  0.557E+00,  0.559E+00,  0.561E+00,  0.553E+00/
!----------------------------------------------------------------------!
! Probability of L-beta3 emission,                                     !
!         or Lbeta3/(L1-Xray total)                                    !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX1(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.65999D+00,0.65979D+00,0.65962D+00,
     *0.65893D+00,0.65789D+00,0.65744D+00,0.65743D+00,0.65709D+00,
     *0.65606D+00,0.65476D+00,0.65396D+00,0.65433D+00,0.65182D+00,
     *0.65070D+00,0.64941D+00,0.64802D+00,0.64631D+00,0.64498D+00,
     *0.57777D+00,0.57470D+00,0.56952D+00,0.56484D+00,0.55963D+00,
     *0.55401D+00,0.54903D+00,0.54424D+00,0.54102D+00,0.51464D+00,
     *0.51253D+00,0.49875D+00,0.50033D+00,0.50200D+00,0.50325D+00,
     *0.50504D+00,0.50534D+00,0.50581D+00,0.50461D+00,0.50317D+00,
     *0.50127D+00,0.49912D+00,0.49561D+00,0.49234D+00,0.48836D+00,
     *0.48509D+00,0.48207D+00,0.48230D+00,0.48021D+00,0.47818D+00,
     *0.47550D+00,0.47307D+00,0.47041D+00,0.46140D+00,0.45938D+00,
     *0.45675D+00,0.45309D+00,0.44989D+00,0.44570D+00,0.44178D+00,
     *0.43681D+00,0.43249D+00,0.42716D+00,0.42225D+00,0.41676D+00,
     *0.41154D+00,0.40568D+00,0.40000D+00,0.39358D+00,0.38724D+00,
     *0.38060D+00,0.37444D+00,0.36746D+00,0.36097D+00,0.35406D+00,
     *0.34756D+00,0.34025D+00,0.33341D+00,0.32635D+00,0.31964D+00,
     *0.31299D+00,0.30657D+00,0.29994D+00,0.29366D+00,0.28633D+00,
     *0.27933D+00,0.27255D+00,0.26613D+00,0.25986D+00,0.25385D+00/
!----------------------------------------------------------------------!
! Probability of L-beta4 emission,                                     !
!         or DFLX1(1)+Lbeta4/(L1-Xray total)                           !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!  Corrected precision same with other data. Aug. 29, 2007 HH          !
!----------------------------------------------------------------------!
      DATA (DFLX1(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,1.00000D+00,1.00000D+00,1.00000D+00,
     *1.00000D+00,1.00000D+00,1.00000D+00,1.00000D+00,1.00000D+00,
     *0.99990D+00,0.99975D+00,0.99957D+00,0.99928D+00,0.99910D+00,
     *0.99880D+00,0.99845D+00,0.99806D+00,0.99752D+00,0.99713D+00,
     *0.99174D+00,0.89182D+00,0.88539D+00,0.87856D+00,0.87227D+00,
     *0.86542D+00,0.85899D+00,0.85343D+00,0.85007D+00,0.85383D+00,
     *0.85081D+00,0.85086D+00,0.84656D+00,0.84236D+00,0.83891D+00,
     *0.83584D+00,0.83129D+00,0.82700D+00,0.82151D+00,0.81565D+00,
     *0.80905D+00,0.80209D+00,0.79446D+00,0.78676D+00,0.77991D+00,
     *0.77372D+00,0.76841D+00,0.76783D+00,0.76497D+00,0.76223D+00,
     *0.75938D+00,0.75691D+00,0.75454D+00,0.74193D+00,0.74098D+00,
     *0.73903D+00,0.73718D+00,0.73556D+00,0.73317D+00,0.73115D+00,
     *0.72817D+00,0.72572D+00,0.72275D+00,0.71993D+00,0.71642D+00,
     *0.71279D+00,0.70953D+00,0.70600D+00,0.70214D+00,0.69819D+00,
     *0.69383D+00,0.68971D+00,0.68494D+00,0.68044D+00,0.67625D+00,
     *0.67219D+00,0.66757D+00,0.66314D+00,0.65824D+00,0.65366D+00,
     *0.64914D+00,0.64442D+00,0.63948D+00,0.63489D+00,0.62877D+00,
     *0.62291D+00,0.61705D+00,0.61157D+00,0.60598D+00,0.60062D+00/
!----------------------------------------------------------------------!
! Probability of L-beta10 emission,                                    !
!         or DFLX1(2)+Lbeta10/(L1-Xray total)                          !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX1(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.99994D+00,0.99985D+00,0.99975D+00,0.99957D+00,0.99946D+00,
     *0.99928D+00,0.99908D+00,0.99884D+00,0.99852D+00,0.99829D+00,
     *0.99292D+00,0.89314D+00,0.88684D+00,0.88014D+00,0.87397D+00,
     *0.86725D+00,0.86095D+00,0.85552D+00,0.85230D+00,0.85610D+00,
     *0.85322D+00,0.85336D+00,0.84922D+00,0.84518D+00,0.84191D+00,
     *0.83901D+00,0.83464D+00,0.83054D+00,0.82524D+00,0.81955D+00,
     *0.81314D+00,0.80637D+00,0.79893D+00,0.79141D+00,0.78475D+00,
     *0.77876D+00,0.77367D+00,0.77333D+00,0.77070D+00,0.76820D+00,
     *0.76559D+00,0.76338D+00,0.76127D+00,0.74882D+00,0.74816D+00,
     *0.74648D+00,0.74492D+00,0.74358D+00,0.74147D+00,0.73974D+00,
     *0.73704D+00,0.73489D+00,0.73222D+00,0.72972D+00,0.72651D+00,
     *0.72321D+00,0.72027D+00,0.71705D+00,0.71352D+00,0.70989D+00,
     *0.70586D+00,0.70209D+00,0.69766D+00,0.69351D+00,0.68968D+00,
     *0.68601D+00,0.68175D+00,0.67772D+00,0.67321D+00,0.66904D+00,
     *0.66496D+00,0.66072D+00,0.65627D+00,0.65218D+00,0.64652D+00,
     *0.64119D+00,0.63589D+00,0.63102D+00,0.62606D+00,0.62139D+00/
!----------------------------------------------------------------------!
! Probability of L-beta9/1 emission,                                   !
!         or DFLX1(3)+Lbeta9/1/(L1-Xray total)                         !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX1(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.99468D+00,0.89509D+00,0.88899D+00,0.88248D+00,0.87651D+00,
     *0.86998D+00,0.86387D+00,0.85864D+00,0.85562D+00,0.85944D+00,
     *0.85681D+00,0.85707D+00,0.85317D+00,0.84939D+00,0.84638D+00,
     *0.84375D+00,0.83964D+00,0.83582D+00,0.83080D+00,0.82537D+00,
     *0.81925D+00,0.81276D+00,0.80560D+00,0.79837D+00,0.79198D+00,
     *0.78630D+00,0.78151D+00,0.78155D+00,0.77928D+00,0.77714D+00,
     *0.77489D+00,0.77305D+00,0.77133D+00,0.75915D+00,0.75891D+00,
     *0.75764D+00,0.75649D+00,0.75559D+00,0.75391D+00,0.75260D+00,
     *0.75033D+00,0.74864D+00,0.74639D+00,0.74437D+00,0.74161D+00,
     *0.73881D+00,0.73635D+00,0.73360D+00,0.73055D+00,0.72740D+00,
     *0.72387D+00,0.72062D+00,0.71669D+00,0.71306D+00,0.70975D+00,
     *0.70668D+00,0.70292D+00,0.69948D+00,0.69557D+00,0.69199D+00,
     *0.68855D+00,0.68502D+00,0.68127D+00,0.67792D+00,0.67295D+00,
     *0.66836D+00,0.66387D+00,0.65985D+00,0.65581D+00,0.65215D+00/
!----------------------------------------------------------------------!
! Probability of L-gamma2 emission,                                    !
!         or DFLX1(4)+Lgamma2/(L1-Xray total)                          !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX1(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.99659D+00,0.90058D+00,0.89919D+00,0.89833D+00,0.89871D+00,
     *0.89917D+00,0.89843D+00,0.89768D+00,0.89775D+00,0.90222D+00,
     *0.90108D+00,0.90225D+00,0.90043D+00,0.89860D+00,0.89734D+00,
     *0.89596D+00,0.89388D+00,0.89226D+00,0.88924D+00,0.88577D+00,
     *0.88162D+00,0.87687D+00,0.87140D+00,0.86573D+00,0.86079D+00,
     *0.85670D+00,0.85351D+00,0.85420D+00,0.85285D+00,0.85155D+00,
     *0.85005D+00,0.84899D+00,0.84800D+00,0.84773D+00,0.84803D+00,
     *0.84670D+00,0.84575D+00,0.84467D+00,0.84439D+00,0.84405D+00,
     *0.84206D+00,0.84033D+00,0.83823D+00,0.83642D+00,0.83497D+00,
     *0.83347D+00,0.83290D+00,0.83160D+00,0.83052D+00,0.82925D+00,
     *0.82854D+00,0.82771D+00,0.82693D+00,0.82605D+00,0.82588D+00,
     *0.82555D+00,0.82507D+00,0.82450D+00,0.82415D+00,0.82368D+00,
     *0.82344D+00,0.82298D+00,0.82314D+00,0.82328D+00,0.82355D+00,
     *0.82394D+00,0.82412D+00,0.82458D+00,0.82472D+00,0.82502D+00/
!----------------------------------------------------------------------!
! Probability of L-gamma3 emission,                                    !
!         or DFLX1(5)+Lgamma3/(L1-Xray total)                          !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX1(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.99874D+00,0.99647D+00,
     *0.99340D+00,0.98967D+00,0.98539D+00,0.98044D+00,0.97653D+00,
     *0.97312D+00,0.97065D+00,0.97285D+00,0.97290D+00,0.97301D+00,
     *0.97321D+00,0.97341D+00,0.97360D+00,0.97231D+00,0.97436D+00,
     *0.97459D+00,0.97488D+00,0.97513D+00,0.97542D+00,0.97570D+00,
     *0.97442D+00,0.97310D+00,0.97193D+00,0.97070D+00,0.96958D+00,
     *0.96845D+00,0.96800D+00,0.96680D+00,0.96591D+00,0.96478D+00,
     *0.96365D+00,0.96250D+00,0.96142D+00,0.96033D+00,0.95936D+00,
     *0.95832D+00,0.95743D+00,0.95653D+00,0.95567D+00,0.95473D+00,
     *0.95427D+00,0.95358D+00,0.95302D+00,0.95249D+00,0.95212D+00,
     *0.95160D+00,0.95113D+00,0.95073D+00,0.95023D+00,0.94967D+00/
!----------------------------------------------------------------------!
! Probability of L-gamma4/1 emission,                                  !
!         or DFLX1(6)+Lgamma4/1/(L1-Xray total)                        !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX1(7,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.99924D+00,0.99785D+00,
     *0.99597D+00,0.99370D+00,0.99112D+00,0.98810D+00,0.98565D+00,
     *0.98355D+00,0.98208D+00,0.98352D+00,0.98362D+00,0.98375D+00,
     *0.98396D+00,0.98414D+00,0.98433D+00,0.98361D+00,0.98494D+00,
     *0.98516D+00,0.98542D+00,0.98564D+00,0.98589D+00,0.98614D+00,
     *0.98545D+00,0.98475D+00,0.98415D+00,0.98352D+00,0.98297D+00,
     *0.98243D+00,0.98232D+00,0.98174D+00,0.98136D+00,0.98084D+00,
     *0.98031D+00,0.97979D+00,0.97931D+00,0.97883D+00,0.97843D+00,
     *0.97804D+00,0.97772D+00,0.97741D+00,0.97710D+00,0.97681D+00,
     *0.97681D+00,0.97669D+00,0.97665D+00,0.97663D+00,0.97672D+00,
     *0.97674D+00,0.97681D+00,0.97695D+00,0.97704D+00,0.97712D+00/
!----------------------------------------------------------------------!
!OMEGAL2  is probability of X-ray emission at L2-Shell absorption      !
!            (Table 3. of Table of Isotopes, Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA OMEGAL2/
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.120D-02,  0.750D-03,  0.370D-03,  0.310D-03,
     *  0.260D-03,  0.240D-03,  0.220D-03,  0.270D-03,  0.330D-03,
     *  0.840D-03,  0.150D-02,  0.260D-02,  0.370D-02,  0.500D-02,
     *  0.630D-02,  0.770D-02,  0.860D-02,  0.100D-01,  0.110D-01,
     *  0.120D-01,  0.130D-01,  0.140D-01,  0.160D-01,  0.180D-01,
     *  0.200D-01,  0.220D-01,  0.240D-01,  0.260D-01,  0.280D-01,
     *  0.310D-01,  0.340D-01,  0.370D-01,  0.400D-01,  0.430D-01,
     *  0.470D-01,  0.510D-01,  0.560D-01,  0.610D-01,  0.650D-01,
     *  0.690D-01,  0.740D-01,  0.790D-01,  0.830D-01,  0.900D-01,
     *  0.960D-01,  0.103D+00,  0.110D+00,  0.117D+00,  0.124D+00,
     *  0.132D+00,  0.140D+00,  0.149D+00,  0.158D+00,  0.167D+00,
     *  0.178D+00,  0.189D+00,  0.200D+00,  0.211D+00,  0.222D+00,
     *  0.234D+00,  0.246D+00,  0.258D+00,  0.270D+00,  0.283D+00,
     *  0.295D+00,  0.308D+00,  0.321D+00,  0.334D+00,  0.347D+00,
     *  0.360D+00,  0.373D+00,  0.387D+00,  0.401D+00,  0.415D+00,
     *  0.429D+00,  0.443D+00,  0.456D+00,  0.468D+00,  0.479D+00,
     *  0.472D+00,  0.467D+00,  0.466D+00,  0.464D+00,  0.471D+00,
     *  0.479D+00,  0.485D+00,  0.490D+00,  0.497D+00,  0.506D+00/
!---------------------------------------------------------------!
!F23  is probability of f23 Coster-Kronig at L2-Shell absorption!
!            (Table 3. of Table of Isotopes, Eighth Edition)    !
!---------------------------------------------------------------!
      DATA F23/
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.000D+00,  0.280D-01,  0.280D-01,  0.260D-01,
     *  0.320D-01,  0.500D-01,  0.630D-01,  0.760D-01,  0.880D-01,
     *  0.100D+00,  0.109D+00,  0.117D+00,  0.126D+00,  0.132D+00,
     *  0.137D+00,  0.141D+00,  0.144D+00,  0.148D+00,  0.150D+00,
     *  0.151D+00,  0.153D+00,  0.155D+00,  0.157D+00,  0.157D+00,
     *  0.156D+00,  0.155D+00,  0.154D+00,  0.154D+00,  0.154D+00,
     *  0.153D+00,  0.153D+00,  0.153D+00,  0.153D+00,  0.152D+00,
     *  0.151D+00,  0.150D+00,  0.149D+00,  0.147D+00,  0.145D+00,
     *  0.143D+00,  0.142D+00,  0.140D+00,  0.139D+00,  0.138D+00,
     *  0.136D+00,  0.135D+00,  0.134D+00,  0.133D+00,  0.130D+00,
     *  0.128D+00,  0.126D+00,  0.124D+00,  0.122D+00,  0.120D+00,
     *  0.118D+00,  0.116D+00,  0.113D+00,  0.111D+00,  0.111D+00,
     *  0.110D+00,  0.109D+00,  0.108D+00,  0.108D+00,  0.108D+00,
     *  0.139D+00,  0.167D+00,  0.192D+00,  0.198D+00,  0.203D+00,
     *  0.200D+00,  0.198D+00,  0.197D+00,  0.196D+00,  0.194D+00/
!----------------------------------------------------------------------!
! Probability of L-beta1 emission,                                     !
!         or Lbeta1/(L2-Xray total)                                    !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX2(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.51319D+00,0.70299D+00,0.79547D+00,0.86613D+00,0.88148D+00,
     *0.90399D+00,0.92002D+00,0.92569D+00,0.93170D+00,0.93370D+00,
     *0.93543D+00,0.93743D+00,0.93935D+00,0.94134D+00,0.94322D+00,
     *0.94513D+00,0.94677D+00,0.94842D+00,0.94977D+00,0.92222D+00,
     *0.91501D+00,0.90788D+00,0.90077D+00,0.89376D+00,0.88155D+00,
     *0.86971D+00,0.87068D+00,0.87165D+00,0.86782D+00,0.86401D+00,
     *0.86117D+00,0.85834D+00,0.85425D+00,0.85020D+00,0.84889D+00,
     *0.84757D+00,0.84427D+00,0.84291D+00,0.84076D+00,0.83864D+00,
     *0.83740D+00,0.83618D+00,0.83478D+00,0.83264D+00,0.83234D+00,
     *0.83129D+00,0.83021D+00,0.82914D+00,0.82806D+00,0.82699D+00,
     *0.82562D+00,0.82399D+00,0.82167D+00,0.81777D+00,0.81279D+00,
     *0.80787D+00,0.80395D+00,0.80005D+00,0.79560D+00,0.79124D+00,
     *0.78748D+00,0.78381D+00,0.78007D+00,0.77637D+00,0.77298D+00,
     *0.76961D+00,0.76654D+00,0.76349D+00,0.76110D+00,0.75872D+00,
     *0.75633D+00,0.75396D+00,0.75281D+00,0.75167D+00,0.74949D+00,
     *0.74732D+00,0.74516D+00,0.74301D+00,0.74088D+00,0.73875D+00/
!----------------------------------------------------------------------!
! Probability of L-gamma1 emission,                                    !
!         or DFLX2(1)+Lgamma1/(L2-Xray total)                          !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX2(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.51319D+00,0.70299D+00,0.79547D+00,0.86613D+00,0.88148D+00,
     *0.90399D+00,0.92002D+00,0.92569D+00,0.93170D+00,0.93370D+00,
     *0.93543D+00,0.93743D+00,0.93935D+00,0.94134D+00,0.94322D+00,
     *0.94513D+00,0.94677D+00,0.94842D+00,0.94977D+00,0.95265D+00,
     *0.95436D+00,0.95600D+00,0.95765D+00,0.95928D+00,0.96089D+00,
     *0.96250D+00,0.96327D+00,0.96405D+00,0.96501D+00,0.96596D+00,
     *0.96666D+00,0.96734D+00,0.96829D+00,0.96923D+00,0.96986D+00,
     *0.97047D+00,0.97007D+00,0.97187D+00,0.97234D+00,0.97282D+00,
     *0.97348D+00,0.97415D+00,0.97461D+00,0.97419D+00,0.97550D+00,
     *0.97593D+00,0.97633D+00,0.97673D+00,0.97699D+00,0.97726D+00,
     *0.97671D+00,0.97585D+00,0.97462D+00,0.97151D+00,0.96779D+00,
     *0.96411D+00,0.96100D+00,0.95790D+00,0.95503D+00,0.95226D+00,
     *0.95002D+00,0.94786D+00,0.94572D+00,0.94361D+00,0.94203D+00,
     *0.94047D+00,0.93928D+00,0.93810D+00,0.93729D+00,0.93649D+00,
     *0.93607D+00,0.93566D+00,0.93537D+00,0.93507D+00,0.93487D+00,
     *0.93468D+00,0.93446D+00,0.93427D+00,0.93407D+00,0.93386D+00/
!----------------------------------------------------------------------!
! Probability of L-gamma5 emission,                                    !
!         or DFLX2(2)+Lgamma51/(L2-Xray total)                         !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX2(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.23840D-01,0.70940D-01,
     *0.54787D+00,0.72375D+00,0.80940D+00,0.86965D+00,0.88907D+00,
     *0.90995D+00,0.92485D+00,0.92965D+00,0.93292D+00,0.93651D+00,
     *0.93882D+00,0.94113D+00,0.94326D+00,0.94540D+00,0.94742D+00,
     *0.94944D+00,0.95134D+00,0.95324D+00,0.95474D+00,0.95758D+00,
     *0.95928D+00,0.96096D+00,0.96262D+00,0.96425D+00,0.96584D+00,
     *0.96739D+00,0.96822D+00,0.96906D+00,0.97006D+00,0.97106D+00,
     *0.97180D+00,0.97253D+00,0.97352D+00,0.97449D+00,0.97517D+00,
     *0.97584D+00,0.97547D+00,0.97724D+00,0.97772D+00,0.97820D+00,
     *0.97886D+00,0.97951D+00,0.97997D+00,0.97956D+00,0.98086D+00,
     *0.98130D+00,0.98169D+00,0.98209D+00,0.98236D+00,0.98263D+00,
     *0.98209D+00,0.98126D+00,0.98003D+00,0.97694D+00,0.97322D+00,
     *0.96954D+00,0.96644D+00,0.96336D+00,0.96050D+00,0.95767D+00,
     *0.95551D+00,0.95336D+00,0.95125D+00,0.94915D+00,0.94759D+00,
     *0.94605D+00,0.94489D+00,0.94373D+00,0.94296D+00,0.94219D+00,
     *0.94180D+00,0.94142D+00,0.94117D+00,0.94092D+00,0.94075D+00,
     *0.94059D+00,0.94042D+00,0.94026D+00,0.94010D+00,0.93994D+00/
!----------------------------------------------------------------------!
! Probability of L-gamma6 emission,                                    !
!         or DFLX2(3)+Lgamma6/(L2-Xray total)                          !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX2(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.23840D-01,0.70940D-01,
     *0.54787D+00,0.72375D+00,0.80940D+00,0.86965D+00,0.88907D+00,
     *0.90995D+00,0.92485D+00,0.92965D+00,0.93292D+00,0.93651D+00,
     *0.93882D+00,0.94113D+00,0.94326D+00,0.94540D+00,0.94742D+00,
     *0.94944D+00,0.95134D+00,0.95324D+00,0.95474D+00,0.95758D+00,
     *0.95928D+00,0.96096D+00,0.96262D+00,0.96425D+00,0.96584D+00,
     *0.96739D+00,0.96822D+00,0.96906D+00,0.97006D+00,0.97106D+00,
     *0.97180D+00,0.97253D+00,0.97352D+00,0.97449D+00,0.97517D+00,
     *0.97584D+00,0.97657D+00,0.97724D+00,0.97772D+00,0.97820D+00,
     *0.97886D+00,0.97951D+00,0.97997D+00,0.98043D+00,0.98086D+00,
     *0.98130D+00,0.98169D+00,0.98209D+00,0.98236D+00,0.98263D+00,
     *0.98274D+00,0.98286D+00,0.98283D+00,0.98283D+00,0.98285D+00,
     *0.98287D+00,0.98272D+00,0.98256D+00,0.98238D+00,0.98220D+00,
     *0.98208D+00,0.98197D+00,0.98167D+00,0.98137D+00,0.98122D+00,
     *0.98107D+00,0.98099D+00,0.98091D+00,0.98059D+00,0.98027D+00,
     *0.98015D+00,0.98002D+00,0.97986D+00,0.97970D+00,0.97958D+00,
     *0.97945D+00,0.97932D+00,0.97920D+00,0.97907D+00,0.97895D+00/
!----------------------------------------------------------------------!
!OMEGAL3  is probability of X-ray emission at L3-Shell absorption      !
!            (Table 3. of Table of Isotopes, Eighth Edition)           !
!----------------------------------------------------------------------!
      DATA OMEGAL3/
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,
     *  0.000D+00,  0.120D-02,  0.750D-03,  0.380D-03,  0.310D-03,
     *  0.260D-03,  0.240D-03,  0.220D-03,  0.270D-03,  0.330D-03,
     *  0.840D-03,  0.150D-02,  0.260D-02,  0.370D-02,  0.500D-02,
     *  0.630D-02,  0.770D-02,  0.930D-02,  0.110D-01,  0.120D-01,
     *  0.130D-01,  0.150D-01,  0.160D-01,  0.180D-01,  0.200D-01,
     *  0.220D-01,  0.240D-01,  0.260D-01,  0.280D-01,  0.310D-01,
     *  0.340D-01,  0.370D-01,  0.400D-01,  0.430D-01,  0.460D-01,
     *  0.490D-01,  0.520D-01,  0.560D-01,  0.600D-01,  0.640D-01,
     *  0.690D-01,  0.740D-01,  0.790D-01,  0.850D-01,  0.910D-01,
     *  0.970D-01,  0.104D+00,  0.111D+00,  0.118D+00,  0.125D+00,
     *  0.132D+00,  0.139D+00,  0.147D+00,  0.155D+00,  0.164D+00,
     *  0.174D+00,  0.182D+00,  0.192D+00,  0.201D+00,  0.210D+00,
     *  0.220D+00,  0.231D+00,  0.243D+00,  0.255D+00,  0.268D+00,
     *  0.281D+00,  0.294D+00,  0.306D+00,  0.320D+00,  0.333D+00,
     *  0.347D+00,  0.360D+00,  0.373D+00,  0.386D+00,  0.399D+00,
     *  0.411D+00,  0.424D+00,  0.437D+00,  0.450D+00,  0.463D+00,
     *  0.476D+00,  0.489D+00,  0.502D+00,  0.514D+00,  0.526D+00,
     *  0.539D+00,  0.550D+00,  0.560D+00,  0.570D+00,  0.579D+00/
!----------------------------------------------------------------------!
! Probability of L-alpha1 emission,                                    !
!         or Lalpha1/(L3-Xray total)                                   !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX3(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.45307D+00,0.62426D+00,0.70836D+00,0.77277D+00,0.78685D+00,
     *0.80487D+00,0.81662D+00,0.82828D+00,0.83607D+00,0.84040D+00,
     *0.84313D+00,0.84605D+00,0.84833D+00,0.85067D+00,0.85225D+00,
     *0.85387D+00,0.85491D+00,0.85585D+00,0.85255D+00,0.85427D+00,
     *0.83897D+00,0.82416D+00,0.81042D+00,0.79713D+00,0.78971D+00,
     *0.78245D+00,0.77482D+00,0.76732D+00,0.76250D+00,0.75773D+00,
     *0.75192D+00,0.74620D+00,0.74221D+00,0.73826D+00,0.73464D+00,
     *0.73106D+00,0.72912D+00,0.72875D+00,0.72768D+00,0.72738D+00,
     *0.72788D+00,0.72838D+00,0.72872D+00,0.72849D+00,0.72964D+00,
     *0.73021D+00,0.73102D+00,0.73182D+00,0.73305D+00,0.73428D+00,
     *0.72827D+00,0.72211D+00,0.71688D+00,0.71221D+00,0.70770D+00,
     *0.70325D+00,0.69951D+00,0.69582D+00,0.69234D+00,0.68890D+00,
     *0.68608D+00,0.68329D+00,0.68073D+00,0.67818D+00,0.67530D+00,
     *0.67243D+00,0.66988D+00,0.66734D+00,0.66503D+00,0.66275D+00,
     *0.66065D+00,0.65857D+00,0.65667D+00,0.65477D+00,0.65265D+00,
     *0.65054D+00,0.64845D+00,0.64636D+00,0.64430D+00,0.64224D+00/
!----------------------------------------------------------------------!
! Probability of L-alpha2 emission,                                    !
!         or DFLX3(1)+Lalpha2/(L3-Xray total)                          !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX3(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.50371D+00,0.69416D+00,0.78767D+00,0.85955D+00,0.87507D+00,
     *0.89521D+00,0.90837D+00,0.92156D+00,0.93051D+00,0.93519D+00,
     *0.93809D+00,0.94130D+00,0.94381D+00,0.94639D+00,0.94816D+00,
     *0.94995D+00,0.95108D+00,0.95223D+00,0.94846D+00,0.94823D+00,
     *0.93126D+00,0.91482D+00,0.90005D+00,0.88577D+00,0.87753D+00,
     *0.86946D+00,0.86098D+00,0.85265D+00,0.84732D+00,0.84206D+00,
     *0.83561D+00,0.82925D+00,0.82482D+00,0.82043D+00,0.81641D+00,
     *0.81243D+00,0.81031D+00,0.80993D+00,0.80874D+00,0.80841D+00,
     *0.80896D+00,0.80952D+00,0.80990D+00,0.80965D+00,0.81092D+00,
     *0.81156D+00,0.81249D+00,0.81342D+00,0.81478D+00,0.81615D+00,
     *0.80947D+00,0.80242D+00,0.79684D+00,0.79169D+00,0.78668D+00,
     *0.78173D+00,0.77762D+00,0.77354D+00,0.76967D+00,0.76585D+00,
     *0.76272D+00,0.75961D+00,0.75676D+00,0.75393D+00,0.75076D+00,
     *0.74761D+00,0.74477D+00,0.74194D+00,0.73938D+00,0.73684D+00,
     *0.73451D+00,0.73220D+00,0.73008D+00,0.72798D+00,0.72562D+00,
     *0.72327D+00,0.72094D+00,0.71863D+00,0.71633D+00,0.71404D+00/
!----------------------------------------------------------------------!
! Probability of L-beta2 emission,                                     !
!         or DFLX3(2)+Lbeta2/(L3-Xray total)                           !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX3(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.50371D+00,0.69416D+00,0.78767D+00,0.85955D+00,0.87507D+00,
     *0.89521D+00,0.90837D+00,0.92156D+00,0.93051D+00,0.93519D+00,
     *0.93809D+00,0.94130D+00,0.94381D+00,0.94639D+00,0.94816D+00,
     *0.94995D+00,0.95108D+00,0.95223D+00,0.95281D+00,0.95361D+00,
     *0.95337D+00,0.95309D+00,0.95272D+00,0.95236D+00,0.95236D+00,
     *0.95212D+00,0.95188D+00,0.95143D+00,0.95123D+00,0.95102D+00,
     *0.95051D+00,0.95000D+00,0.94960D+00,0.94922D+00,0.94877D+00,
     *0.94833D+00,0.94694D+00,0.94755D+00,0.94725D+00,0.94796D+00,
     *0.94775D+00,0.94755D+00,0.94723D+00,0.94614D+00,0.94654D+00,
     *0.94619D+00,0.94576D+00,0.94533D+00,0.94481D+00,0.94428D+00,
     *0.94288D+00,0.94063D+00,0.93895D+00,0.93741D+00,0.93359D+00,
     *0.92982D+00,0.92682D+00,0.92384D+00,0.92080D+00,0.91779D+00,
     *0.91507D+00,0.91238D+00,0.90989D+00,0.90740D+00,0.90505D+00,
     *0.90268D+00,0.90022D+00,0.89782D+00,0.89548D+00,0.89316D+00,
     *0.89104D+00,0.88897D+00,0.88718D+00,0.88544D+00,0.88335D+00,
     *0.88130D+00,0.87927D+00,0.87720D+00,0.87599D+00,0.87315D+00/
!----------------------------------------------------------------------!
! Probability of L-beta5 emission,                                     !
!         or DFLX3(3)+Lbeta5/(L3-Xray total)                           !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX3(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.50371D+00,0.69416D+00,0.78767D+00,0.85955D+00,0.87507D+00,
     *0.89521D+00,0.90837D+00,0.92156D+00,0.93051D+00,0.93519D+00,
     *0.93809D+00,0.94130D+00,0.94381D+00,0.94639D+00,0.94816D+00,
     *0.94995D+00,0.95108D+00,0.95223D+00,0.95281D+00,0.95361D+00,
     *0.95337D+00,0.95309D+00,0.95272D+00,0.95236D+00,0.95236D+00,
     *0.95212D+00,0.95188D+00,0.95143D+00,0.95123D+00,0.95102D+00,
     *0.95051D+00,0.95000D+00,0.94960D+00,0.94922D+00,0.94877D+00,
     *0.94833D+00,0.94796D+00,0.94755D+00,0.94725D+00,0.94796D+00,
     *0.94775D+00,0.94755D+00,0.94723D+00,0.94693D+00,0.94654D+00,
     *0.94619D+00,0.94576D+00,0.94533D+00,0.94481D+00,0.94428D+00,
     *0.94345D+00,0.94279D+00,0.94182D+00,0.94098D+00,0.94003D+00,
     *0.93910D+00,0.93836D+00,0.93762D+00,0.93672D+00,0.93584D+00,
     *0.93507D+00,0.93431D+00,0.93351D+00,0.93270D+00,0.93200D+00,
     *0.93126D+00,0.93030D+00,0.92938D+00,0.92843D+00,0.92749D+00,
     *0.92658D+00,0.92571D+00,0.92494D+00,0.92420D+00,0.92310D+00,
     *0.92203D+00,0.92096D+00,0.91986D+00,0.91961D+00,0.91772D+00/
!----------------------------------------------------------------------!
! Probability of L-beta6 emission,                                     !
!         or DFLX3(4)+Lbeta6/(L3-Xray total)                           !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX3(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.53900D+00,0.71552D+00,0.80212D+00,0.86324D+00,0.88310D+00,
     *0.90153D+00,0.91348D+00,0.92581D+00,0.93184D+00,0.93828D+00,
     *0.94184D+00,0.94540D+00,0.94818D+00,0.95098D+00,0.95292D+00,
     *0.95488D+00,0.95635D+00,0.95782D+00,0.95858D+00,0.95957D+00,
     *0.95931D+00,0.95907D+00,0.95870D+00,0.95835D+00,0.95839D+00,
     *0.95816D+00,0.95799D+00,0.95762D+00,0.95751D+00,0.95741D+00,
     *0.95700D+00,0.95658D+00,0.95630D+00,0.95603D+00,0.95570D+00,
     *0.95538D+00,0.95515D+00,0.95478D+00,0.95457D+00,0.95432D+00,
     *0.95431D+00,0.95429D+00,0.95421D+00,0.95414D+00,0.95398D+00,
     *0.95386D+00,0.95369D+00,0.95353D+00,0.95320D+00,0.95287D+00,
     *0.95211D+00,0.95151D+00,0.95064D+00,0.94988D+00,0.94930D+00,
     *0.94874D+00,0.94815D+00,0.94757D+00,0.94687D+00,0.94617D+00,
     *0.94557D+00,0.94497D+00,0.94434D+00,0.94368D+00,0.94314D+00,
     *0.94255D+00,0.94182D+00,0.94113D+00,0.94034D+00,0.93955D+00,
     *0.93884D+00,0.93816D+00,0.93755D+00,0.93697D+00,0.93602D+00,
     *0.93510D+00,0.93419D+00,0.93324D+00,0.93314D+00,0.93140D+00/
!----------------------------------------------------------------------!
! Probability of L-beta15 emission,                                    !
!         or DFLX3(5)+Lbeta15/(L3-Xray total)                          !
!  Intensity are adjusted to experimental data by S.I.Salem et al.     !
!  Atomic Data and Nuclear Data Table 14,91-109(1974) using the        !
!  theoretical data by J.M. Scofield. Atomic Data and Nuclear Data     !
!  Tables 14,121-137(1974).                                            !
!----------------------------------------------------------------------!
      DATA (DFLX3(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.53900D+00,0.71552D+00,0.80212D+00,0.86324D+00,0.88310D+00,
     *0.90153D+00,0.91348D+00,0.92581D+00,0.93184D+00,0.93828D+00,
     *0.94184D+00,0.94540D+00,0.94818D+00,0.95098D+00,0.95292D+00,
     *0.95488D+00,0.95635D+00,0.95782D+00,0.95907D+00,0.96017D+00,
     *0.96182D+00,0.96341D+00,0.96467D+00,0.96590D+00,0.96687D+00,
     *0.96783D+00,0.96832D+00,0.96879D+00,0.96924D+00,0.96969D+00,
     *0.96992D+00,0.97015D+00,0.97031D+00,0.97046D+00,0.97053D+00,
     *0.97059D+00,0.97042D+00,0.97019D+00,0.97008D+00,0.96993D+00,
     *0.96983D+00,0.96972D+00,0.96955D+00,0.96940D+00,0.96914D+00,
     *0.96892D+00,0.96860D+00,0.96828D+00,0.96773D+00,0.96719D+00,
     *0.96701D+00,0.96694D+00,0.96649D+00,0.96612D+00,0.96566D+00,
     *0.96521D+00,0.96474D+00,0.96426D+00,0.96363D+00,0.96301D+00,
     *0.96244D+00,0.96187D+00,0.96125D+00,0.96064D+00,0.96013D+00,
     *0.95963D+00,0.95893D+00,0.95823D+00,0.95745D+00,0.95667D+00,
     *0.95597D+00,0.95526D+00,0.95470D+00,0.95414D+00,0.95320D+00,
     *0.95226D+00,0.95134D+00,0.95041D+00,0.94950D+00,0.94859D+00/
!-------------------------------------------------------------!
!  E-M average edge energy                                    !
!            (Calculated by ln M_ab=(sum n_i ln M_i)/sum n_i  !
!             by using M_i in Table 2. of Table of Isotopes,  !
!             Eighth  Edition)                                !
!-------------------------------------------------------------!
      DATA EMBIND/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.14100D-01,0.10600D-01,0.83000D-02,0.89000D-02,0.11600D-01,
     *0.12700D-01,0.11800D-01,0.14100D-01,0.93000D-02,0.24400D-01,
     *0.40400D-01,0.57200D-01,0.74400D-01,0.94400D-01,0.11110D+00,
     *0.14110D+00,0.16180D+00,0.18920D+00,0.21780D+00,0.24460D+00,
     *0.27360D+00,0.30470D+00,0.33010D+00,0.36150D+00,0.39350D+00,
     *0.42560D+00,0.46240D+00,0.50440D+00,0.54890D+00,0.59580D+00,
     *0.64380D+00,0.69380D+00,0.74680D+00,0.80990D+00,0.86440D+00,
     *0.92590D+00,0.98300D+00,0.10411D+01,0.10957D+01,0.11485D+01,
     *0.12049D+01,0.12642D+01,0.13229D+01,0.13843D+01,0.14485D+01,
     *0.15100D+01,0.15740D+01,0.16401D+01,0.17087D+01,0.17757D+01,
     *0.18459D+01,0.19288D+01,0.20121D+01,0.20968D+01,0.21811D+01,
     *0.22693D+01,0.23616D+01,0.24543D+01,0.25506D+01,0.26528D+01,
     *0.27608D+01,0.28694D+01,0.29794D+01,0.30943D+01,0.32102D+01,
     *0.33297D+01,0.34563D+01,0.35849D+01,0.37160D+01,0.38475D+01,
     *0.39749D+01,0.41046D+01,0.42384D+01,0.43698D+01,0.45069D+01,
     *0.46479D+01,0.47889D+01,0.49329D+01,0.50791D+01,0.52282D+01/
!-------------------------------------------------------------!
!  K-L1L1 Energy  Calculated neglecting correction term       !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.                        !
!-------------------------------------------------------------!
      DATA (EKAUG(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.16280D+00,
     *0.24780D+00,0.35280D+00,0.47500D+00,0.61740D+00,0.77310D+00,
     *0.94550D+00,0.11262D+01,0.13242D+01,0.15415D+01,0.17669D+01,
     *0.20136D+01,0.22820D+01,0.25534D+01,0.28532D+01,0.31625D+01,
     *0.34920D+01,0.38390D+01,0.42087D+01,0.46000D+01,0.50010D+01,
     *0.54198D+01,0.58577D+01,0.63166D+01,0.67867D+01,0.72714D+01,
     *0.77717D+01,0.82745D+01,0.88137D+01,0.93500D+01,0.99097D+01,
     *0.10484D+02,0.11070D+02,0.11672D+02,0.12293D+02,0.12934D+02,
     *0.13590D+02,0.14269D+02,0.14959D+02,0.15669D+02,0.16396D+02,
     *0.17142D+02,0.17902D+02,0.18675D+02,0.19465D+02,0.20271D+02,
     *0.21095D+02,0.21935D+02,0.22793D+02,0.23659D+02,0.24556D+02,
     *0.25463D+02,0.26392D+02,0.27345D+02,0.28321D+02,0.29317D+02,
     *0.30328D+02,0.31361D+02,0.32415D+02,0.33488D+02,0.34580D+02,
     *0.35697D+02,0.36829D+02,0.37983D+02,0.39158D+02,0.40360D+02,
     *0.41573D+02,0.42809D+02,0.44053D+02,0.45325D+02,0.46623D+02,
     *0.47935D+02,0.49274D+02,0.50634D+02,0.52019D+02,0.53424D+02,
     *0.54837D+02,0.56283D+02,0.57751D+02,0.59244D+02,0.60760D+02,
     *0.62301D+02,0.63862D+02,0.65451D+02,0.67064D+02,0.68706D+02,
     *0.70386D+02,0.72086D+02,0.73815D+02,0.75583D+02,0.77366D+02,
     *0.79189D+02,0.81044D+02,0.82919D+02,0.84832D+02,0.86778D+02/
!-------------------------------------------------------------!
!  K-L1L2 Energy  Calculated neglecting correction term       !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.                        !
!-------------------------------------------------------------!
      DATA (EKAUG(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.17070D+00,
     *0.25940D+00,0.36800D+00,0.49640D+00,0.64280D+00,0.79990D+00,
     *0.97770D+00,0.11642D+01,0.13687D+01,0.15907D+01,0.18200D+01,
     *0.20774D+01,0.23506D+01,0.26290D+01,0.29340D+01,0.32503D+01,
     *0.35857D+01,0.39412D+01,0.43164D+01,0.47109D+01,0.51186D+01,
     *0.55448D+01,0.59897D+01,0.64528D+01,0.69318D+01,0.74222D+01,
     *0.79271D+01,0.84410D+01,0.89816D+01,0.95277D+01,0.10096D+02,
     *0.10677D+02,0.11271D+02,0.11882D+02,0.12510D+02,0.13159D+02,
     *0.13823D+02,0.14509D+02,0.15208D+02,0.15926D+02,0.16662D+02,
     *0.17416D+02,0.18185D+02,0.18966D+02,0.19764D+02,0.20579D+02,
     *0.21413D+02,0.22263D+02,0.23129D+02,0.24008D+02,0.24911D+02,
     *0.25828D+02,0.26768D+02,0.27730D+02,0.28715D+02,0.29721D+02,
     *0.30743D+02,0.31786D+02,0.32850D+02,0.33933D+02,0.35036D+02,
     *0.36162D+02,0.37306D+02,0.38470D+02,0.39657D+02,0.40868D+02,
     *0.42095D+02,0.43341D+02,0.44599D+02,0.45881D+02,0.47191D+02,
     *0.48518D+02,0.49868D+02,0.51242D+02,0.52639D+02,0.54054D+02,
     *0.55486D+02,0.56944D+02,0.58427D+02,0.59935D+02,0.61466D+02,
     *0.63021D+02,0.64597D+02,0.66199D+02,0.67829D+02,0.69485D+02,
     *0.71177D+02,0.72896D+02,0.74642D+02,0.76421D+02,0.78222D+02,
     *0.80064D+02,0.81929D+02,0.83821D+02,0.85749D+02,0.87711D+02/
!-------------------------------------------------------------!
!  K-L1L3 Energy  Calculated neglecting correction term       !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.                        !
!-------------------------------------------------------------!
      DATA (EKAUG(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.17070D+00,
     *0.25940D+00,0.36800D+00,0.49640D+00,0.64280D+00,0.80000D+00,
     *0.97770D+00,0.11642D+01,0.13692D+01,0.15913D+01,0.18209D+01,
     *0.20786D+01,0.23522D+01,0.26311D+01,0.29367D+01,0.32539D+01,
     *0.35902D+01,0.39472D+01,0.43240D+01,0.47201D+01,0.51297D+01,
     *0.55578D+01,0.60047D+01,0.64700D+01,0.69517D+01,0.74453D+01,
     *0.79540D+01,0.84721D+01,0.90171D+01,0.95681D+01,0.10142D+02,
     *0.10730D+02,0.11330D+02,0.11949D+02,0.12586D+02,0.13244D+02,
     *0.13917D+02,0.14614D+02,0.15325D+02,0.16055D+02,0.16804D+02,
     *0.17573D+02,0.18357D+02,0.19156D+02,0.19972D+02,0.20807D+02,
     *0.21661D+02,0.22533D+02,0.23424D+02,0.24329D+02,0.25258D+02,
     *0.26205D+02,0.27176D+02,0.28171D+02,0.29192D+02,0.30235D+02,
     *0.31297D+02,0.32381D+02,0.33490D+02,0.34621D+02,0.35774D+02,
     *0.36953D+02,0.38152D+02,0.39376D+02,0.40626D+02,0.41902D+02,
     *0.43199D+02,0.44519D+02,0.45854D+02,0.47218D+02,0.48614D+02,
     *0.50032D+02,0.51477D+02,0.52951D+02,0.54453D+02,0.55979D+02,
     *0.57526D+02,0.59109D+02,0.60720D+02,0.62362D+02,0.64035D+02,
     *0.65739D+02,0.67471D+02,0.69239D+02,0.71040D+02,0.72878D+02,
     *0.74758D+02,0.76676D+02,0.78632D+02,0.80630D+02,0.82664D+02,
     *0.84745D+02,0.86865D+02,0.89022D+02,0.91230D+02,0.93484D+02/
!-------------------------------------------------------------!
!  K-L2L2 Energy  Calculated neglecting correction term       !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.                        !
!-------------------------------------------------------------!
      DATA (EKAUG(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.17860D+00,
     *0.27100D+00,0.38320D+00,0.51780D+00,0.66820D+00,0.82670D+00,
     *0.10099D+01,0.12022D+01,0.14132D+01,0.16399D+01,0.18731D+01,
     *0.21412D+01,0.24192D+01,0.27046D+01,0.30148D+01,0.33381D+01,
     *0.36794D+01,0.40434D+01,0.44241D+01,0.48218D+01,0.52362D+01,
     *0.56698D+01,0.61217D+01,0.65890D+01,0.70769D+01,0.75730D+01,
     *0.80825D+01,0.86075D+01,0.91495D+01,0.97054D+01,0.10282D+02,
     *0.10871D+02,0.11472D+02,0.12091D+02,0.12727D+02,0.13384D+02,
     *0.14056D+02,0.14749D+02,0.15458D+02,0.16183D+02,0.16928D+02,
     *0.17690D+02,0.18467D+02,0.19257D+02,0.20064D+02,0.20888D+02,
     *0.21730D+02,0.22590D+02,0.23465D+02,0.24357D+02,0.25266D+02,
     *0.26193D+02,0.27143D+02,0.28115D+02,0.29110D+02,0.30126D+02,
     *0.31158D+02,0.32211D+02,0.33285D+02,0.34379D+02,0.35493D+02,
     *0.36627D+02,0.37782D+02,0.38957D+02,0.40156D+02,0.41376D+02,
     *0.42617D+02,0.43872D+02,0.45144D+02,0.46437D+02,0.47759D+02,
     *0.49101D+02,0.50463D+02,0.51850D+02,0.53258D+02,0.54685D+02,
     *0.56135D+02,0.57605D+02,0.59104D+02,0.60626D+02,0.62172D+02,
     *0.63741D+02,0.65332D+02,0.66947D+02,0.68594D+02,0.70264D+02,
     *0.71968D+02,0.73706D+02,0.75469D+02,0.77259D+02,0.79078D+02,
     *0.80939D+02,0.82814D+02,0.84723D+02,0.86666D+02,0.88644D+02/
!-------------------------------------------------------------!
!  K-L2L3 Energy  Calculated neglecting correction term       !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.                        !
!-------------------------------------------------------------!
      DATA (EKAUG(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.17860D+00,
     *0.27100D+00,0.38320D+00,0.51780D+00,0.66820D+00,0.82680D+00,
     *0.10099D+01,0.12022D+01,0.14137D+01,0.16405D+01,0.18740D+01,
     *0.21424D+01,0.24208D+01,0.27067D+01,0.30175D+01,0.33417D+01,
     *0.36839D+01,0.40494D+01,0.44317D+01,0.48310D+01,0.52473D+01,
     *0.56828D+01,0.61367D+01,0.66062D+01,0.70968D+01,0.75961D+01,
     *0.81094D+01,0.86386D+01,0.91850D+01,0.97458D+01,0.10328D+02,
     *0.10924D+02,0.11531D+02,0.12158D+02,0.12803D+02,0.13469D+02,
     *0.14150D+02,0.14854D+02,0.15574D+02,0.16312D+02,0.17070D+02,
     *0.17847D+02,0.18639D+02,0.19447D+02,0.20272D+02,0.21115D+02,
     *0.21979D+02,0.22860D+02,0.23760D+02,0.24679D+02,0.25613D+02,
     *0.26570D+02,0.27551D+02,0.28555D+02,0.29586D+02,0.30640D+02,
     *0.31712D+02,0.32806D+02,0.33925D+02,0.35066D+02,0.36230D+02,
     *0.37418D+02,0.38629D+02,0.39863D+02,0.41125D+02,0.42411D+02,
     *0.43721D+02,0.45051D+02,0.46399D+02,0.47774D+02,0.49182D+02,
     *0.50615D+02,0.52072D+02,0.53558D+02,0.55073D+02,0.56610D+02,
     *0.58175D+02,0.59769D+02,0.61396D+02,0.63053D+02,0.64741D+02,
     *0.66459D+02,0.68206D+02,0.69987D+02,0.71805D+02,0.73657D+02,
     *0.75549D+02,0.77486D+02,0.79459D+02,0.81468D+02,0.83520D+02,
     *0.85620D+02,0.87750D+02,0.89924D+02,0.92147D+02,0.94417D+02/
!-------------------------------------------------------------!
!  K-L3L3 Energy  Calculated neglecting correction term       !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.                        !
!-------------------------------------------------------------!
      DATA (EKAUG(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.17860D+00,
     *0.27100D+00,0.38320D+00,0.51780D+00,0.66820D+00,0.82690D+00,
     *0.10099D+01,0.12022D+01,0.14142D+01,0.16411D+01,0.18749D+01,
     *0.21436D+01,0.24224D+01,0.27088D+01,0.30202D+01,0.33453D+01,
     *0.36884D+01,0.40554D+01,0.44393D+01,0.48402D+01,0.52584D+01,
     *0.56958D+01,0.61517D+01,0.66234D+01,0.71167D+01,0.76192D+01,
     *0.81363D+01,0.86697D+01,0.92205D+01,0.97862D+01,0.10374D+02,
     *0.10976D+02,0.11591D+02,0.12225D+02,0.12878D+02,0.13553D+02,
     *0.14245D+02,0.14959D+02,0.15690D+02,0.16441D+02,0.17212D+02,
     *0.18004D+02,0.18812D+02,0.19636D+02,0.20480D+02,0.21343D+02,
     *0.22227D+02,0.23131D+02,0.24055D+02,0.25000D+02,0.25961D+02,
     *0.26947D+02,0.27959D+02,0.28996D+02,0.30062D+02,0.31153D+02,
     *0.32265D+02,0.33402D+02,0.34565D+02,0.35754D+02,0.36968D+02,
     *0.38208D+02,0.39476D+02,0.40770D+02,0.42094D+02,0.43445D+02,
     *0.44826D+02,0.46229D+02,0.47654D+02,0.49111D+02,0.50606D+02,
     *0.52129D+02,0.53681D+02,0.55267D+02,0.56888D+02,0.58535D+02,
     *0.60215D+02,0.61934D+02,0.63689D+02,0.65480D+02,0.67310D+02,
     *0.69177D+02,0.71080D+02,0.73027D+02,0.75016D+02,0.77050D+02,
     *0.79130D+02,0.81266D+02,0.83449D+02,0.85677D+02,0.87962D+02,
     *0.90301D+02,0.92686D+02,0.95125D+02,0.97628D+02,0.10019D+03/
!-------------------------------------------------------------!
!  K-L1M Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.                        !
!-------------------------------------------------------------!
      DATA (EKAUG(7,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.28797D+01,0.32303D+01,0.36003D+01,
     *0.39783D+01,0.43921D+01,0.48286D+01,0.52857D+01,0.57584D+01,
     *0.62532D+01,0.67715D+01,0.73106D+01,0.78735D+01,0.84406D+01,
     *0.90290D+01,0.96316D+01,0.10266D+02,0.10910D+02,0.11581D+02,
     *0.12264D+02,0.12973D+02,0.13699D+02,0.14448D+02,0.15221D+02,
     *0.16014D+02,0.16829D+02,0.17671D+02,0.18532D+02,0.19415D+02,
     *0.20320D+02,0.21246D+02,0.22189D+02,0.23154D+02,0.24140D+02,
     *0.25149D+02,0.26181D+02,0.27235D+02,0.28302D+02,0.29406D+02,
     *0.30526D+02,0.31675D+02,0.32853D+02,0.34060D+02,0.35294D+02,
     *0.36551D+02,0.37833D+02,0.39144D+02,0.40479D+02,0.41839D+02,
     *0.43233D+02,0.44650D+02,0.46094D+02,0.47565D+02,0.49070D+02,
     *0.50598D+02,0.52151D+02,0.53723D+02,0.55328D+02,0.56969D+02,
     *0.58634D+02,0.60331D+02,0.62060D+02,0.63822D+02,0.65610D+02,
     *0.67423D+02,0.69274D+02,0.71159D+02,0.73078D+02,0.75032D+02,
     *0.77019D+02,0.79040D+02,0.81098D+02,0.83194D+02,0.85331D+02,
     *0.87516D+02,0.89739D+02,0.92004D+02,0.94317D+02,0.96667D+02,
     *0.99067D+02,0.10151D+03,0.10400D+03,0.10653D+03,0.10912D+03/
!-------------------------------------------------------------!
!  K-L2M Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.                        !
!-------------------------------------------------------------!
      DATA (EKAUG(8,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.29553D+01,0.33111D+01,0.36881D+01,
     *0.40720D+01,0.44943D+01,0.49363D+01,0.53966D+01,0.58760D+01,
     *0.63782D+01,0.69035D+01,0.74468D+01,0.80186D+01,0.85914D+01,
     *0.91844D+01,0.97981D+01,0.10434D+02,0.11087D+02,0.11767D+02,
     *0.12457D+02,0.13174D+02,0.13909D+02,0.14665D+02,0.15446D+02,
     *0.16247D+02,0.17070D+02,0.17921D+02,0.18789D+02,0.19680D+02,
     *0.20594D+02,0.21528D+02,0.22480D+02,0.23453D+02,0.24448D+02,
     *0.25467D+02,0.26508D+02,0.27571D+02,0.28651D+02,0.29761D+02,
     *0.30891D+02,0.32051D+02,0.33238D+02,0.34455D+02,0.35699D+02,
     *0.36966D+02,0.38258D+02,0.39579D+02,0.40925D+02,0.42296D+02,
     *0.43698D+02,0.45126D+02,0.46581D+02,0.48064D+02,0.49578D+02,
     *0.51119D+02,0.52683D+02,0.54268D+02,0.55884D+02,0.57537D+02,
     *0.59216D+02,0.60925D+02,0.62668D+02,0.64441D+02,0.66241D+02,
     *0.68072D+02,0.69935D+02,0.71835D+02,0.73769D+02,0.75739D+02,
     *0.77739D+02,0.79775D+02,0.81846D+02,0.83959D+02,0.86110D+02,
     *0.88307D+02,0.90549D+02,0.92831D+02,0.95155D+02,0.97523D+02,
     *0.99942D+02,0.10240D+03,0.10490D+03,0.10745D+03,0.11006D+03/
!-------------------------------------------------------------!
!  K-L3M Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.                        !
!-------------------------------------------------------------!
      DATA (EKAUG(9,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.29574D+01,0.33138D+01,0.36917D+01,
     *0.40765D+01,0.45003D+01,0.49439D+01,0.54058D+01,0.58871D+01,
     *0.63912D+01,0.69185D+01,0.74640D+01,0.80385D+01,0.86145D+01,
     *0.92113D+01,0.98292D+01,0.10469D+02,0.11128D+02,0.11813D+02,
     *0.12510D+02,0.13234D+02,0.13976D+02,0.14741D+02,0.15531D+02,
     *0.16342D+02,0.17175D+02,0.18037D+02,0.18918D+02,0.19823D+02,
     *0.20751D+02,0.21701D+02,0.22669D+02,0.23661D+02,0.24676D+02,
     *0.25715D+02,0.26779D+02,0.27866D+02,0.28972D+02,0.30108D+02,
     *0.31268D+02,0.32459D+02,0.33679D+02,0.34931D+02,0.36213D+02,
     *0.37520D+02,0.38854D+02,0.40219D+02,0.41612D+02,0.43033D+02,
     *0.44488D+02,0.45973D+02,0.47488D+02,0.49033D+02,0.50613D+02,
     *0.52224D+02,0.53861D+02,0.55523D+02,0.57221D+02,0.58960D+02,
     *0.60731D+02,0.62534D+02,0.64377D+02,0.66256D+02,0.68166D+02,
     *0.70112D+02,0.72100D+02,0.74128D+02,0.76196D+02,0.78307D+02,
     *0.80457D+02,0.82649D+02,0.84886D+02,0.87170D+02,0.89503D+02,
     *0.91888D+02,0.94329D+02,0.96821D+02,0.99364D+02,0.10197D+03,
     *0.10462D+03,0.10733D+03,0.11010D+03,0.11293D+03,0.11583D+03/
!-------------------------------------------------------------!
!  K-L1N Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition. Using average N        !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EKAUG(10,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.36003D+01,
     *0.39924D+01,0.44027D+01,0.48369D+01,0.52946D+01,0.57700D+01,
     *0.62659D+01,0.67833D+01,0.73247D+01,0.78828D+01,0.84650D+01,
     *0.90682D+01,0.96854D+01,0.10336D+02,0.10997D+02,0.11684D+02,
     *0.12388D+02,0.13118D+02,0.13865D+02,0.14621D+02,0.15428D+02,
     *0.16261D+02,0.17122D+02,0.17988D+02,0.18882D+02,0.19796D+02,
     *0.20738D+02,0.21696D+02,0.22670D+02,0.23668D+02,0.24691D+02,
     *0.25738D+02,0.26809D+02,0.27904D+02,0.29012D+02,0.30158D+02,
     *0.31323D+02,0.32519D+02,0.33790D+02,0.35071D+02,0.36373D+02,
     *0.37681D+02,0.39022D+02,0.40280D+02,0.41840D+02,0.43240D+02,
     *0.44690D+02,0.46176D+02,0.47686D+02,0.49224D+02,0.50795D+02,
     *0.52389D+02,0.53995D+02,0.55629D+02,0.57298D+02,0.59004D+02,
     *0.60746D+02,0.62516D+02,0.64320D+02,0.66156D+02,0.68021D+02,
     *0.69914D+02,0.71847D+02,0.73812D+02,0.75816D+02,0.77855D+02,
     *0.79931D+02,0.82042D+02,0.84189D+02,0.86379D+02,0.88610D+02,
     *0.90894D+02,0.93216D+02,0.95581D+02,0.97997D+02,0.10045D+03,
     *0.10296D+03,0.10551D+03,0.10811D+03,0.11076D+03,0.11346D+03/
!-------------------------------------------------------------!
!  K-L2N Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition. Using average N        !
!  binding energy.                                            !
!-------------------------------------------------------------!
       DATA (EKAUG(11,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.36881D+01,
     *0.40861D+01,0.45049D+01,0.49446D+01,0.54055D+01,0.58876D+01,
     *0.63909D+01,0.69153D+01,0.74609D+01,0.80279D+01,0.86158D+01,
     *0.92236D+01,0.98519D+01,0.10504D+02,0.11174D+02,0.11870D+02,
     *0.12582D+02,0.13319D+02,0.14074D+02,0.14838D+02,0.15653D+02,
     *0.16494D+02,0.17362D+02,0.18237D+02,0.19139D+02,0.20062D+02,
     *0.21012D+02,0.21978D+02,0.22961D+02,0.23968D+02,0.24999D+02,
     *0.26056D+02,0.27136D+02,0.28240D+02,0.29361D+02,0.30513D+02,
     *0.31688D+02,0.32895D+02,0.34175D+02,0.35465D+02,0.36777D+02,
     *0.38096D+02,0.39447D+02,0.40715D+02,0.42285D+02,0.43696D+02,
     *0.45155D+02,0.46652D+02,0.48173D+02,0.49723D+02,0.51303D+02,
     *0.52911D+02,0.54527D+02,0.56174D+02,0.57854D+02,0.59572D+02,
     *0.61329D+02,0.63111D+02,0.64928D+02,0.66775D+02,0.68652D+02,
     *0.70562D+02,0.72507D+02,0.74488D+02,0.76507D+02,0.78561D+02,
     *0.80651D+02,0.82776D+02,0.84937D+02,0.87144D+02,0.89389D+02,
     *0.91685D+02,0.94026D+02,0.96408D+02,0.98835D+02,0.10131D+03,
     *0.10384D+03,0.10640D+03,0.10901D+03,0.11167D+03,0.11439D+03/
!-------------------------------------------------------------!
!  K-L3N Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average N      !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EKAUG(12,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.36917D+01,
     *0.40906D+01,0.45109D+01,0.49522D+01,0.54147D+01,0.58987D+01,
     *0.64039D+01,0.69303D+01,0.74781D+01,0.80478D+01,0.86389D+01,
     *0.92505D+01,0.98830D+01,0.10536D+02,0.11215D+02,0.11916D+02,
     *0.12634D+02,0.13378D+02,0.14142D+02,0.14914D+02,0.15738D+02,
     *0.16588D+02,0.17467D+02,0.18354D+02,0.19268D+02,0.20204D+02,
     *0.21169D+02,0.22150D+02,0.23150D+02,0.24176D+02,0.25226D+02,
     *0.26304D+02,0.27407D+02,0.28535D+02,0.29682D+02,0.30860D+02,
     *0.32065D+02,0.33304D+02,0.34616D+02,0.35941D+02,0.37291D+02,
     *0.38649D+02,0.40043D+02,0.41355D+02,0.42973D+02,0.44434D+02,
     *0.45945D+02,0.47499D+02,0.49080D+02,0.50692D+02,0.52338D+02,
     *0.54015D+02,0.55705D+02,0.57429D+02,0.59191D+02,0.60995D+02,
     *0.62843D+02,0.64719D+02,0.66636D+02,0.68590D+02,0.70577D+02,
     *0.72603D+02,0.74672D+02,0.76781D+02,0.78934D+02,0.81130D+02,
     *0.83369D+02,0.85650D+02,0.87977D+02,0.90355D+02,0.92782D+02,
     *0.95266D+02,0.97806D+02,0.10040D+03,0.10304D+03,0.10575D+03,
     *0.10852D+03,0.11133D+03,0.11421D+03,0.11715D+03,0.12017D+03/
!-------------------------------------------------------------!
!  K-MM Energy  Calculated neglecting correction term         !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.  Using average M       !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EKAUG(13,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.31690D+01,0.35656D+01,0.39799D+01,
     *0.44646D+01,0.49452D+01,0.54485D+01,0.59714D+01,0.65158D+01,
     *0.70866D+01,0.76853D+01,0.83046D+01,0.89603D+01,0.96098D+01,
     *0.10286D+02,0.10989D+02,0.11718D+02,0.12469D+02,0.13252D+02,
     *0.14043D+02,0.14876D+02,0.15726D+02,0.16603D+02,0.17508D+02,
     *0.18438D+02,0.19390D+02,0.20384D+02,0.21394D+02,0.22433D+02,
     *0.23499D+02,0.24589D+02,0.25702D+02,0.26842D+02,0.28009D+02,
     *0.29204D+02,0.30426D+02,0.31676D+02,0.32945D+02,0.34256D+02,
     *0.35589D+02,0.36959D+02,0.38361D+02,0.39799D+02,0.41272D+02,
     *0.42774D+02,0.44306D+02,0.45873D+02,0.47471D+02,0.49099D+02,
     *0.50769D+02,0.52470D+02,0.54205D+02,0.55972D+02,0.57781D+02,
     *0.59622D+02,0.61493D+02,0.63392D+02,0.65331D+02,0.67314D+02,
     *0.69332D+02,0.71388D+02,0.73486D+02,0.75624D+02,0.77797D+02,
     *0.80009D+02,0.82266D+02,0.84567D+02,0.86911D+02,0.89304D+02,
     *0.91738D+02,0.94217D+02,0.96745D+02,0.99324D+02,0.10196D+03,
     *0.10465D+03,0.10739D+03,0.11019D+03,0.11305D+03,0.11597D+03,
     *0.11895D+03,0.12198D+03,0.12507D+03,0.12824D+03,0.13147D+03/
!-------------------------------------------------------------!
!  K-MN Energy  Calculated neglecting correction term         !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average M, N   !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EKAUG(14,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.31875D+01,0.35865D+01,0.40090D+01,
     *0.44787D+01,0.49558D+01,0.54568D+01,0.59803D+01,0.65274D+01,
     *0.70993D+01,0.76971D+01,0.83187D+01,0.89696D+01,0.96342D+01,
     *0.10325D+02,0.11043D+02,0.11788D+02,0.12556D+02,0.13355D+02,
     *0.14168D+02,0.15021D+02,0.15892D+02,0.16776D+02,0.17715D+02,
     *0.18685D+02,0.19683D+02,0.20700D+02,0.21745D+02,0.22815D+02,
     *0.23917D+02,0.25039D+02,0.26183D+02,0.27357D+02,0.28559D+02,
     *0.29793D+02,0.31054D+02,0.32345D+02,0.33655D+02,0.35008D+02,
     *0.36386D+02,0.37803D+02,0.39298D+02,0.40810D+02,0.42350D+02,
     *0.43904D+02,0.45495D+02,0.47009D+02,0.48831D+02,0.50499D+02,
     *0.52226D+02,0.53996D+02,0.55798D+02,0.57631D+02,0.59505D+02,
     *0.61413D+02,0.63337D+02,0.65298D+02,0.67301D+02,0.69350D+02,
     *0.71444D+02,0.73573D+02,0.75746D+02,0.77958D+02,0.80208D+02,
     *0.82500D+02,0.84838D+02,0.87220D+02,0.89649D+02,0.92127D+02,
     *0.94649D+02,0.97218D+02,0.99836D+02,0.10251D+03,0.10523D+03,
     *0.10802D+03,0.11087D+03,0.11377D+03,0.11673D+03,0.11975D+03,
     *0.12284D+03,0.12598D+03,0.12918D+03,0.13246D+03,0.13580D+03/
!-------------------------------------------------------------!
!  L1-MM Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average M      !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EL1AUG(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.28930D+00,0.33530D+00,0.37960D+00,
     *0.47220D+00,0.54250D+00,0.61160D+00,0.67680D+00,0.74580D+00,
     *0.82070D+00,0.90200D+00,0.97990D+00,0.10775D+01,0.11448D+01,
     *0.12169D+01,0.12999D+01,0.13777D+01,0.14651D+01,0.15598D+01,
     *0.16388D+01,0.17415D+01,0.18379D+01,0.19369D+01,0.20424D+01,
     *0.21505D+01,0.22561D+01,0.23823D+01,0.25010D+01,0.26249D+01,
     *0.27531D+01,0.28810D+01,0.30092D+01,0.31397D+01,0.32731D+01,
     *0.34107D+01,0.35516D+01,0.36945D+01,0.38330D+01,0.39855D+01,
     *0.41370D+01,0.43003D+01,0.44666D+01,0.46434D+01,0.48290D+01,
     *0.50181D+01,0.52084D+01,0.54062D+01,0.56070D+01,0.58110D+01,
     *0.60258D+01,0.62462D+01,0.64711D+01,0.66983D+01,0.69350D+01,
     *0.71786D+01,0.74131D+01,0.76573D+01,0.79062D+01,0.81645D+01,
     *0.84294D+01,0.86953D+01,0.89719D+01,0.92516D+01,0.95337D+01,
     *0.98251D+01,0.10122D+02,0.10429D+02,0.10739D+02,0.11062D+02,
     *0.11389D+02,0.11721D+02,0.12062D+02,0.12414D+02,0.12777D+02,
     *0.13155D+02,0.13549D+02,0.13950D+02,0.14364D+02,0.14794D+02,
     *0.15230D+02,0.15678D+02,0.16144D+02,0.16624D+02,0.17118D+02/
!-------------------------------------------------------------!
!  L1-MN Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average M, N   !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EL1AUG(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.30780D+00,0.35620D+00,0.40870D+00,
     *0.48630D+00,0.55310D+00,0.61990D+00,0.68570D+00,0.75740D+00,
     *0.83340D+00,0.91380D+00,0.99400D+00,0.10868D+01,0.11692D+01,
     *0.12561D+01,0.13537D+01,0.14480D+01,0.15523D+01,0.16633D+01,
     *0.17633D+01,0.18862D+01,0.20038D+01,0.21098D+01,0.22495D+01,
     *0.23967D+01,0.25486D+01,0.26989D+01,0.28514D+01,0.30067D+01,
     *0.31711D+01,0.33309D+01,0.34900D+01,0.36545D+01,0.38240D+01,
     *0.39998D+01,0.41798D+01,0.43636D+01,0.45432D+01,0.47374D+01,
     *0.49341D+01,0.51444D+01,0.54040D+01,0.56542D+01,0.59076D+01,
     *0.61478D+01,0.63973D+01,0.65419D+01,0.69678D+01,0.72114D+01,
     *0.74829D+01,0.77727D+01,0.80634D+01,0.83573D+01,0.86595D+01,
     *0.89699D+01,0.92571D+01,0.95630D+01,0.98758D+01,0.10200D+02,
     *0.10541D+02,0.10881D+02,0.11232D+02,0.11586D+02,0.11945D+02,
     *0.12316D+02,0.12694D+02,0.13082D+02,0.13477D+02,0.13885D+02,
     *0.14300D+02,0.14722D+02,0.15153D+02,0.15599D+02,0.16056D+02,
     *0.16533D+02,0.17025D+02,0.17527D+02,0.18044D+02,0.18579D+02,
     *0.19124D+02,0.19678D+02,0.20254D+02,0.20845D+02,0.21453D+02/
!-------------------------------------------------------------!
!  L1-MO Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average M      !
!  binding energy.  Neglect O binding energy.                 !
!-------------------------------------------------------------!
      DATA (EL1AUG(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.30780D+00,0.35620D+00,0.40870D+00,
     *0.48630D+00,0.55310D+00,0.61990D+00,0.68570D+00,0.75740D+00,
     *0.83340D+00,0.91380D+00,0.99400D+00,0.10868D+01,0.11692D+01,
     *0.12573D+01,0.13571D+01,0.14521D+01,0.15595D+01,0.16709D+01,
     *0.17799D+01,0.19033D+01,0.20271D+01,0.21547D+01,0.22870D+01,
     *0.24241D+01,0.25608D+01,0.27124D+01,0.28625D+01,0.30184D+01,
     *0.31787D+01,0.33434D+01,0.35136D+01,0.36886D+01,0.38689D+01,
     *0.40545D+01,0.42454D+01,0.44413D+01,0.46429D+01,0.48499D+01,
     *0.50629D+01,0.52833D+01,0.55077D+01,0.57391D+01,0.59775D+01,
     *0.62230D+01,0.64726D+01,0.67291D+01,0.69913D+01,0.72595D+01,
     *0.75358D+01,0.78202D+01,0.81112D+01,0.84070D+01,0.87107D+01,
     *0.90245D+01,0.93419D+01,0.96694D+01,0.10003D+02,0.10346D+02,
     *0.10699D+02,0.11057D+02,0.11426D+02,0.11802D+02,0.12187D+02,
     *0.12586D+02,0.12991D+02,0.13408D+02,0.13834D+02,0.14272D+02,
     *0.14718D+02,0.15178D+02,0.15647D+02,0.16130D+02,0.16625D+02,
     *0.17130D+02,0.17653D+02,0.18189D+02,0.18734D+02,0.19301D+02,
     *0.19878D+02,0.20467D+02,0.21077D+02,0.21703D+02,0.22346D+02/
!-------------------------------------------------------------!
!  L1-NN Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average N      !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EL1AUG(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.12953D+01,0.14075D+01,0.15183D+01,0.16395D+01,0.17667D+01,
     *0.18879D+01,0.20310D+01,0.21696D+01,0.22827D+01,0.24565D+01,
     *0.26429D+01,0.28412D+01,0.30154D+01,0.32019D+01,0.33885D+01,
     *0.35890D+01,0.37809D+01,0.39709D+01,0.41692D+01,0.43749D+01,
     *0.45888D+01,0.48080D+01,0.50327D+01,0.52533D+01,0.54893D+01,
     *0.57312D+01,0.59884D+01,0.63414D+01,0.66650D+01,0.69862D+01,
     *0.72774D+01,0.75861D+01,0.76776D+01,0.83286D+01,0.86119D+01,
     *0.89400D+01,0.92993D+01,0.96557D+01,0.10016D+02,0.10384D+02,
     *0.10761D+02,0.11101D+02,0.11469D+02,0.11845D+02,0.12235D+02,
     *0.12653D+02,0.13066D+02,0.13491D+02,0.13921D+02,0.14356D+02,
     *0.14807D+02,0.15267D+02,0.15735D+02,0.16215D+02,0.16709D+02,
     *0.17212D+02,0.17723D+02,0.18244D+02,0.18783D+02,0.19336D+02,
     *0.19911D+02,0.20502D+02,0.21104D+02,0.21724D+02,0.22365D+02,
     *0.23018D+02,0.23678D+02,0.24364D+02,0.25067D+02,0.25788D+02/
!-------------------------------------------------------------!
!  L1-NO Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average N      !
!  binding energy.  Neglect O binding energy.                 !
!-------------------------------------------------------------!
      DATA (EL1AUG(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.12965D+01,0.14109D+01,0.15224D+01,0.16467D+01,0.17744D+01,
     *0.19044D+01,0.20480D+01,0.21930D+01,0.23276D+01,0.24941D+01,
     *0.26703D+01,0.28533D+01,0.30290D+01,0.32129D+01,0.34002D+01,
     *0.35967D+01,0.37933D+01,0.39944D+01,0.42034D+01,0.44198D+01,
     *0.46436D+01,0.48736D+01,0.51104D+01,0.53531D+01,0.56018D+01,
     *0.58600D+01,0.61274D+01,0.64451D+01,0.67499D+01,0.70561D+01,
     *0.73527D+01,0.76615D+01,0.78648D+01,0.83521D+01,0.86599D+01,
     *0.89929D+01,0.93467D+01,0.97035D+01,0.10066D+02,0.10435D+02,
     *0.10816D+02,0.11186D+02,0.11575D+02,0.11973D+02,0.12381D+02,
     *0.12811D+02,0.13242D+02,0.13686D+02,0.14137D+02,0.14598D+02,
     *0.15077D+02,0.15564D+02,0.16061D+02,0.16572D+02,0.17095D+02,
     *0.17630D+02,0.18179D+02,0.18738D+02,0.19315D+02,0.19904D+02,
     *0.20508D+02,0.21130D+02,0.21766D+02,0.22414D+02,0.23086D+02,
     *0.23772D+02,0.24467D+02,0.25187D+02,0.25924D+02,0.26681D+02/
!-------------------------------------------------------------!
!  L1-OO Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Neglect O binding    !
!  energy.                                                    !
!-------------------------------------------------------------!
      DATA (EL1AUG(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.12977D+01,0.14143D+01,0.15265D+01,0.16539D+01,0.17820D+01,
     *0.19210D+01,0.20651D+01,0.22163D+01,0.23725D+01,0.25316D+01,
     *0.26977D+01,0.28655D+01,0.30425D+01,0.32240D+01,0.34119D+01,
     *0.36043D+01,0.38058D+01,0.40180D+01,0.42375D+01,0.44647D+01,
     *0.46983D+01,0.49392D+01,0.51881D+01,0.54528D+01,0.57143D+01,
     *0.59888D+01,0.62663D+01,0.65488D+01,0.68348D+01,0.71260D+01,
     *0.74279D+01,0.77368D+01,0.80520D+01,0.83756D+01,0.87080D+01,
     *0.90458D+01,0.93942D+01,0.97513D+01,0.10116D+02,0.10486D+02,
     *0.10870D+02,0.11271D+02,0.11682D+02,0.12100D+02,0.12527D+02,
     *0.12968D+02,0.13419D+02,0.13881D+02,0.14353D+02,0.14839D+02,
     *0.15347D+02,0.15861D+02,0.16388D+02,0.16928D+02,0.17482D+02,
     *0.18048D+02,0.18634D+02,0.19232D+02,0.19846D+02,0.20472D+02,
     *0.21105D+02,0.21758D+02,0.22427D+02,0.23104D+02,0.23808D+02,
     *0.24526D+02,0.25256D+02,0.26010D+02,0.26782D+02,0.27574D+02/
!-------------------------------------------------------------!
!  L2-MM Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average M      !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EL2AUG(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.21370D+00,0.25450D+00,0.29180D+00,
     *0.37850D+00,0.44030D+00,0.50390D+00,0.56590D+00,0.62820D+00,
     *0.69570D+00,0.77000D+00,0.84370D+00,0.93240D+00,0.99400D+00,
     *0.10615D+01,0.11334D+01,0.12098D+01,0.12874D+01,0.13738D+01,
     *0.14450D+01,0.15403D+01,0.16284D+01,0.17199D+01,0.18175D+01,
     *0.19175D+01,0.20157D+01,0.21330D+01,0.22439D+01,0.23591D+01,
     *0.24791D+01,0.25989D+01,0.27182D+01,0.28402D+01,0.29645D+01,
     *0.30928D+01,0.32244D+01,0.33585D+01,0.34839D+01,0.36306D+01,
     *0.37718D+01,0.39246D+01,0.40820D+01,0.42490D+01,0.44245D+01,
     *0.46030D+01,0.47834D+01,0.49713D+01,0.51617D+01,0.53546D+01,
     *0.55606D+01,0.57698D+01,0.59841D+01,0.61995D+01,0.64268D+01,
     *0.66568D+01,0.68818D+01,0.71119D+01,0.73504D+01,0.75965D+01,
     *0.78464D+01,0.81009D+01,0.83640D+01,0.86324D+01,0.89031D+01,
     *0.91763D+01,0.94612D+01,0.97523D+01,0.10048D+02,0.10356D+02,
     *0.10669D+02,0.10986D+02,0.11314D+02,0.11649D+02,0.11998D+02,
     *0.12364D+02,0.12739D+02,0.13123D+02,0.13526D+02,0.13938D+02,
     *0.14355D+02,0.14793D+02,0.15242D+02,0.15707D+02,0.16185D+02/
!-------------------------------------------------------------!
!  L2-MN Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average M, N   !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EL2AUG(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.23220D+00,0.27540D+00,0.32090D+00,
     *0.39260D+00,0.45090D+00,0.51220D+00,0.57480D+00,0.63980D+00,
     *0.70840D+00,0.78180D+00,0.85780D+00,0.94170D+00,0.10184D+01,
     *0.11007D+01,0.11872D+01,0.12801D+01,0.13746D+01,0.14773D+01,
     *0.15695D+01,0.16850D+01,0.17943D+01,0.18928D+01,0.20246D+01,
     *0.21637D+01,0.23082D+01,0.24496D+01,0.25943D+01,0.27409D+01,
     *0.28971D+01,0.30488D+01,0.31990D+01,0.33550D+01,0.35154D+01,
     *0.36819D+01,0.38526D+01,0.40276D+01,0.41941D+01,0.43825D+01,
     *0.45689D+01,0.47687D+01,0.50194D+01,0.52598D+01,0.55031D+01,
     *0.57327D+01,0.59723D+01,0.61070D+01,0.65225D+01,0.67550D+01,
     *0.70177D+01,0.72963D+01,0.75764D+01,0.78585D+01,0.81513D+01,
     *0.84481D+01,0.87258D+01,0.90176D+01,0.93200D+01,0.96320D+01,
     *0.99584D+01,0.10286D+02,0.10624D+02,0.10967D+02,0.11314D+02,
     *0.11667D+02,0.12034D+02,0.12405D+02,0.12786D+02,0.13179D+02,
     *0.13580D+02,0.13987D+02,0.14405D+02,0.14834D+02,0.15277D+02,
     *0.15742D+02,0.16215D+02,0.16700D+02,0.17206D+02,0.17723D+02,
     *0.18249D+02,0.18793D+02,0.19352D+02,0.19928D+02,0.20520D+02/
!-------------------------------------------------------------!
!  L2-MO Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average M      !
!  binding energy.  Neglect O binding energy.                 !
!-------------------------------------------------------------!
      DATA (EL2AUG(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.23220D+00,0.27540D+00,0.32090D+00,
     *0.39260D+00,0.45090D+00,0.51220D+00,0.57480D+00,0.63980D+00,
     *0.70840D+00,0.78180D+00,0.85780D+00,0.94170D+00,0.10184D+01,
     *0.11019D+01,0.11906D+01,0.12842D+01,0.13818D+01,0.14849D+01,
     *0.15861D+01,0.17021D+01,0.18176D+01,0.19377D+01,0.20621D+01,
     *0.21911D+01,0.23204D+01,0.24631D+01,0.26054D+01,0.27526D+01,
     *0.29047D+01,0.30613D+01,0.32226D+01,0.33891D+01,0.35603D+01,
     *0.37366D+01,0.39182D+01,0.41053D+01,0.42938D+01,0.44950D+01,
     *0.46977D+01,0.49076D+01,0.51231D+01,0.53447D+01,0.55730D+01,
     *0.58079D+01,0.60476D+01,0.62942D+01,0.65460D+01,0.68031D+01,
     *0.70706D+01,0.73438D+01,0.76242D+01,0.79082D+01,0.82025D+01,
     *0.85027D+01,0.88106D+01,0.91240D+01,0.94472D+01,0.97776D+01,
     *0.10116D+02,0.10463D+02,0.10818D+02,0.11183D+02,0.11556D+02,
     *0.11937D+02,0.12331D+02,0.12732D+02,0.13143D+02,0.13566D+02,
     *0.13998D+02,0.14443D+02,0.14899D+02,0.15365D+02,0.15846D+02,
     *0.16339D+02,0.16843D+02,0.17362D+02,0.17896D+02,0.18445D+02,
     *0.19003D+02,0.19582D+02,0.20175D+02,0.20786D+02,0.21413D+02/
!-------------------------------------------------------------!
!  L2-NN Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average N      !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EL2AUG(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.11398D+01,0.12410D+01,0.13504D+01,0.14618D+01,0.15807D+01,
     *0.16941D+01,0.18298D+01,0.19601D+01,0.20657D+01,0.22316D+01,
     *0.24099D+01,0.26008D+01,0.27661D+01,0.29448D+01,0.31227D+01,
     *0.33150D+01,0.34988D+01,0.36799D+01,0.38697D+01,0.40663D+01,
     *0.42709D+01,0.44808D+01,0.46967D+01,0.49042D+01,0.51344D+01,
     *0.53660D+01,0.56127D+01,0.59568D+01,0.62706D+01,0.65817D+01,
     *0.68623D+01,0.71611D+01,0.72427D+01,0.78833D+01,0.81555D+01,
     *0.84748D+01,0.88229D+01,0.91687D+01,0.95175D+01,0.98758D+01,
     *0.10239D+02,0.10570D+02,0.10923D+02,0.11290D+02,0.11667D+02,
     *0.12070D+02,0.12471D+02,0.12883D+02,0.13301D+02,0.13725D+02,
     *0.14158D+02,0.14606D+02,0.15058D+02,0.15524D+02,0.16003D+02,
     *0.16492D+02,0.16988D+02,0.17496D+02,0.18018D+02,0.18557D+02,
     *0.19120D+02,0.19692D+02,0.20277D+02,0.20886D+02,0.21509D+02,
     *0.22143D+02,0.22793D+02,0.23462D+02,0.24150D+02,0.24855D+02/
!-------------------------------------------------------------!
!  L2-NO Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average N      !
!  binding energy.  Neglect O binding energy.                 !
!-------------------------------------------------------------!
      DATA (EL2AUG(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.11411D+01,0.12444D+01,0.13545D+01,0.14690D+01,0.15884D+01,
     *0.17106D+01,0.18468D+01,0.19835D+01,0.21106D+01,0.22692D+01,
     *0.24373D+01,0.26129D+01,0.27797D+01,0.29558D+01,0.31344D+01,
     *0.33227D+01,0.35112D+01,0.37034D+01,0.39039D+01,0.41112D+01,
     *0.43257D+01,0.45464D+01,0.47744D+01,0.50040D+01,0.52469D+01,
     *0.54948D+01,0.57517D+01,0.60605D+01,0.63555D+01,0.66516D+01,
     *0.69376D+01,0.72365D+01,0.74299D+01,0.79068D+01,0.82035D+01,
     *0.85277D+01,0.88703D+01,0.92165D+01,0.95672D+01,0.99270D+01,
     *0.10294D+02,0.10655D+02,0.11030D+02,0.11417D+02,0.11813D+02,
     *0.12228D+02,0.12648D+02,0.13078D+02,0.13517D+02,0.13967D+02,
     *0.14428D+02,0.14903D+02,0.15385D+02,0.15881D+02,0.16389D+02,
     *0.16910D+02,0.17444D+02,0.17990D+02,0.18550D+02,0.19125D+02,
     *0.19717D+02,0.20320D+02,0.20939D+02,0.21576D+02,0.22230D+02,
     *0.22897D+02,0.23582D+02,0.24285D+02,0.25007D+02,0.25748D+02/
!-------------------------------------------------------------!
!  L2-OO Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Neglect O binding    !
!  energy.                                                    !
!-------------------------------------------------------------!
      DATA (EL2AUG(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.11423D+01,0.12478D+01,0.13586D+01,0.14762D+01,0.15960D+01,
     *0.17272D+01,0.18639D+01,0.20068D+01,0.21555D+01,0.23067D+01,
     *0.24647D+01,0.26251D+01,0.27932D+01,0.29669D+01,0.31461D+01,
     *0.33303D+01,0.35237D+01,0.37270D+01,0.39380D+01,0.41561D+01,
     *0.43804D+01,0.46120D+01,0.48521D+01,0.51037D+01,0.53594D+01,
     *0.56236D+01,0.58906D+01,0.61642D+01,0.64404D+01,0.67215D+01,
     *0.70128D+01,0.73118D+01,0.76171D+01,0.79303D+01,0.82516D+01,
     *0.85806D+01,0.89178D+01,0.92643D+01,0.96169D+01,0.99782D+01,
     *0.10349D+02,0.10739D+02,0.11136D+02,0.11544D+02,0.11959D+02,
     *0.12385D+02,0.12824D+02,0.13273D+02,0.13734D+02,0.14209D+02,
     *0.14698D+02,0.15200D+02,0.15711D+02,0.16237D+02,0.16776D+02,
     *0.17328D+02,0.17899D+02,0.18484D+02,0.19081D+02,0.19693D+02,
     *0.20314D+02,0.20948D+02,0.21600D+02,0.22266D+02,0.22952D+02,
     *0.23651D+02,0.24371D+02,0.25108D+02,0.25865D+02,0.26641D+02/
!-------------------------------------------------------------!
!  L3-MM Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average M      !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EL3AUG(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.21160D+00,0.25180D+00,0.28820D+00,
     *0.37400D+00,0.43430D+00,0.49630D+00,0.55670D+00,0.61710D+00,
     *0.68270D+00,0.75500D+00,0.82650D+00,0.91250D+00,0.97090D+00,
     *0.10346D+01,0.11023D+01,0.11743D+01,0.12470D+01,0.13277D+01,
     *0.13927D+01,0.14808D+01,0.15612D+01,0.16444D+01,0.17331D+01,
     *0.18233D+01,0.19108D+01,0.20167D+01,0.21149D+01,0.22168D+01,
     *0.23221D+01,0.24263D+01,0.25287D+01,0.26323D+01,0.27372D+01,
     *0.28446D+01,0.29538D+01,0.30635D+01,0.31624D+01,0.32831D+01,
     *0.33952D+01,0.35167D+01,0.36412D+01,0.37729D+01,0.39109D+01,
     *0.40495D+01,0.41878D+01,0.43311D+01,0.44742D+01,0.46170D+01,
     *0.47701D+01,0.49231D+01,0.50777D+01,0.52306D+01,0.53922D+01,
     *0.55523D+01,0.57031D+01,0.58569D+01,0.60132D+01,0.61731D+01,
     *0.63323D+01,0.64920D+01,0.66552D+01,0.68175D+01,0.69783D+01,
     *0.71359D+01,0.72964D+01,0.74598D+01,0.76214D+01,0.77866D+01,
     *0.79506D+01,0.81124D+01,0.82742D+01,0.84380D+01,0.86050D+01,
     *0.87832D+01,0.89588D+01,0.91332D+01,0.93174D+01,0.94962D+01,
     *0.96742D+01,0.98570D+01,0.10041D+02,0.10226D+02,0.10412D+02/
!-------------------------------------------------------------!
!  L3-MN Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average M, N   !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EL3AUG(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.23010D+00,0.27270D+00,0.31790D+00,
     *0.38810D+00,0.44490D+00,0.50460D+00,0.56560D+00,0.62870D+00,
     *0.69540D+00,0.76680D+00,0.84060D+00,0.92180D+00,0.99530D+00,
     *0.10738D+01,0.11561D+01,0.12446D+01,0.13342D+01,0.14312D+01,
     *0.15172D+01,0.16255D+01,0.17271D+01,0.18173D+01,0.19402D+01,
     *0.20695D+01,0.22033D+01,0.23333D+01,0.24653D+01,0.25986D+01,
     *0.27401D+01,0.28762D+01,0.30095D+01,0.31471D+01,0.32881D+01,
     *0.34337D+01,0.35820D+01,0.37326D+01,0.38726D+01,0.40350D+01,
     *0.41923D+01,0.43608D+01,0.45786D+01,0.47837D+01,0.49895D+01,
     *0.51792D+01,0.53767D+01,0.54668D+01,0.58350D+01,0.60174D+01,
     *0.62272D+01,0.64496D+01,0.66700D+01,0.68896D+01,0.71167D+01,
     *0.73436D+01,0.75471D+01,0.77626D+01,0.79828D+01,0.82086D+01,
     *0.84443D+01,0.86772D+01,0.89149D+01,0.91520D+01,0.93894D+01,
     *0.96266D+01,0.98688D+01,0.10113D+02,0.10359D+02,0.10610D+02,
     *0.10862D+02,0.11113D+02,0.11365D+02,0.11623D+02,0.11884D+02,
     *0.12161D+02,0.12435D+02,0.12710D+02,0.12997D+02,0.13281D+02,
     *0.13568D+02,0.13857D+02,0.14151D+02,0.14447D+02,0.14747D+02/
!-------------------------------------------------------------!
!  L3-MO Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average M      !
!  binding energy.   Neglect O binding energy                 !
!-------------------------------------------------------------!
      DATA (EL3AUG(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.23010D+00,0.27270D+00,0.31730D+00,
     *0.38810D+00,0.44490D+00,0.50460D+00,0.56560D+00,0.62870D+00,
     *0.69540D+00,0.76680D+00,0.84060D+00,0.92180D+00,0.99530D+00,
     *0.10750D+01,0.11595D+01,0.12487D+01,0.13414D+01,0.14388D+01,
     *0.15338D+01,0.16426D+01,0.17504D+01,0.18622D+01,0.19777D+01,
     *0.20969D+01,0.22155D+01,0.23468D+01,0.24764D+01,0.26103D+01,
     *0.27477D+01,0.28887D+01,0.30331D+01,0.31812D+01,0.33330D+01,
     *0.34884D+01,0.36476D+01,0.38103D+01,0.39723D+01,0.41475D+01,
     *0.43211D+01,0.44997D+01,0.46823D+01,0.48686D+01,0.50594D+01,
     *0.52544D+01,0.54520D+01,0.56540D+01,0.58585D+01,0.60655D+01,
     *0.62801D+01,0.64971D+01,0.67178D+01,0.69393D+01,0.71679D+01,
     *0.73982D+01,0.76319D+01,0.78690D+01,0.81100D+01,0.83542D+01,
     *0.86016D+01,0.88536D+01,0.91095D+01,0.93681D+01,0.96311D+01,
     *0.98967D+01,0.10166D+02,0.10439D+02,0.10716D+02,0.10997D+02,
     *0.11280D+02,0.11569D+02,0.11859D+02,0.12154D+02,0.12453D+02,
     *0.12758D+02,0.13063D+02,0.13372D+02,0.13687D+02,0.14003D+02,
     *0.14322D+02,0.14646D+02,0.14974D+02,0.15305D+02,0.15640D+02/
!-------------------------------------------------------------!
!  L3-NN Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average N      !
!  binding energy.                                            !
!-------------------------------------------------------------!
      DATA (EL3AUG(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.11130D+01,0.12099D+01,0.13149D+01,0.14214D+01,0.15346D+01,
     *0.16418D+01,0.17703D+01,0.18929D+01,0.19902D+01,0.21472D+01,
     *0.23157D+01,0.24959D+01,0.26498D+01,0.28158D+01,0.29804D+01,
     *0.31580D+01,0.33262D+01,0.34904D+01,0.36618D+01,0.38390D+01,
     *0.40227D+01,0.42102D+01,0.44017D+01,0.45827D+01,0.47869D+01,
     *0.49894D+01,0.52048D+01,0.55160D+01,0.57945D+01,0.60681D+01,
     *0.63088D+01,0.65655D+01,0.66025D+01,0.71958D+01,0.74179D+01,
     *0.76843D+01,0.79762D+01,0.82623D+01,0.85486D+01,0.88412D+01,
     *0.91349D+01,0.93912D+01,0.96683D+01,0.99524D+01,0.10244D+02,
     *0.10556D+02,0.10862D+02,0.11175D+02,0.11486D+02,0.11801D+02,
     *0.12117D+02,0.12441D+02,0.12766D+02,0.13097D+02,0.13434D+02,
     *0.13774D+02,0.14114D+02,0.14456D+02,0.14807D+02,0.15164D+02,
     *0.15539D+02,0.15912D+02,0.16287D+02,0.16677D+02,0.17067D+02,
     *0.17462D+02,0.17857D+02,0.18261D+02,0.18669D+02,0.19082D+02/
!-------------------------------------------------------------!
!  L3-NO Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Using average N      !
!  binding energy.  Neglect O binding energy.                 !
!-------------------------------------------------------------!
      DATA (EL3AUG(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.11142D+01,0.12133D+01,0.13190D+01,0.14286D+01,0.15423D+01,
     *0.16583D+01,0.17873D+01,0.19163D+01,0.20351D+01,0.21848D+01,
     *0.23431D+01,0.25080D+01,0.26634D+01,0.28268D+01,0.29921D+01,
     *0.31657D+01,0.33386D+01,0.35139D+01,0.36960D+01,0.38839D+01,
     *0.40775D+01,0.42758D+01,0.44794D+01,0.46825D+01,0.48994D+01,
     *0.51182D+01,0.53438D+01,0.56197D+01,0.58794D+01,0.61380D+01,
     *0.63841D+01,0.66409D+01,0.67897D+01,0.72193D+01,0.74659D+01,
     *0.77372D+01,0.80236D+01,0.83101D+01,0.85983D+01,0.88924D+01,
     *0.91895D+01,0.94759D+01,0.97747D+01,0.10080D+02,0.10390D+02,
     *0.10714D+02,0.11039D+02,0.11369D+02,0.11703D+02,0.12042D+02,
     *0.12387D+02,0.12738D+02,0.13092D+02,0.13454D+02,0.13820D+02,
     *0.14192D+02,0.14570D+02,0.14950D+02,0.15339D+02,0.15732D+02,
     *0.16136D+02,0.16540D+02,0.16949D+02,0.17367D+02,0.17788D+02,
     *0.18216D+02,0.18646D+02,0.19084D+02,0.19526D+02,0.19975D+02/
!-------------------------------------------------------------!
!  L3-OO Energy  Calculated neglecting correction term        !
!  by using Atomic-Electron Binding Energy in Table 2. of     !
!  Table of Isotopes, Eighth  Edition.   Neglect O binding    !
!  energy.                                                    !
!-------------------------------------------------------------!
      DATA (EL3AUG(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.11154D+01,0.12167D+01,0.13231D+01,0.14358D+01,0.15499D+01,
     *0.16749D+01,0.18044D+01,0.19396D+01,0.20800D+01,0.22223D+01,
     *0.23705D+01,0.25202D+01,0.26769D+01,0.28379D+01,0.30038D+01,
     *0.31733D+01,0.33511D+01,0.35375D+01,0.37301D+01,0.39288D+01,
     *0.41322D+01,0.43414D+01,0.45571D+01,0.47822D+01,0.50119D+01,
     *0.52470D+01,0.54827D+01,0.57234D+01,0.59643D+01,0.62079D+01,
     *0.64593D+01,0.67162D+01,0.69769D+01,0.72428D+01,0.75140D+01,
     *0.77901D+01,0.80711D+01,0.83579D+01,0.86480D+01,0.89436D+01,
     *0.92441D+01,0.95607D+01,0.98811D+01,0.10207D+02,0.10535D+02,
     *0.10871D+02,0.11215D+02,0.11564D+02,0.11919D+02,0.12284D+02,
     *0.12658D+02,0.13035D+02,0.13419D+02,0.13810D+02,0.14207D+02,
     *0.14610D+02,0.15025D+02,0.15444D+02,0.15870D+02,0.16300D+02,
     *0.16733D+02,0.17168D+02,0.17610D+02,0.18057D+02,0.18510D+02,
     *0.18970D+02,0.19435D+02,0.19907D+02,0.20384D+02,0.20868D+02/
!-------------------------------------------------------------!
!  K-L1L1 Auger Intensity                                     !
!     Z=12-17 Table 1 of W.N.Assad, Nucl. Phys. 44(1963)399.  !
!     Z>17  Table 8. of  Table of Isotopes, Eighth  Edition.  !
!-------------------------------------------------------------!
      DATA (DFKAUG(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.30930D+00,0.27650D+00,0.25230D+00,0.23370D+00,
     *0.21980D+00,0.20600D+00,0.69400D-01,0.67600D-01,0.66700D-01,
     *0.66200D-01,0.66100D-01,0.66000D-01,0.66200D-01,0.66500D-01,
     *0.66700D-01,0.67000D-01,0.67500D-01,0.67900D-01,0.68400D-01,
     *0.69100D-01,0.70900D-01,0.70600D-01,0.70500D-01,0.68100D-01,
     *0.67300D-01,0.68200D-01,0.68700D-01,0.69700D-01,0.70500D-01,
     *0.70900D-01,0.70800D-01,0.71800D-01,0.72100D-01,0.73100D-01,
     *0.73600D-01,0.74100D-01,0.74700D-01,0.75700D-01,0.75900D-01,
     *0.77100D-01,0.77200D-01,0.78400D-01,0.78800D-01,0.79600D-01,
     *0.80500D-01,0.81600D-01,0.83000D-01,0.83100D-01,0.84700D-01,
     *0.85400D-01,0.86000D-01,0.88100D-01,0.89200D-01,0.90200D-01,
     *0.91500D-01,0.91100D-01,0.92400D-01,0.94000D-01,0.95800D-01,
     *0.95600D-01,0.97700D-01,0.97800D-01,0.10000D+00,0.10010D+00,
     *0.10240D+00,0.10250D+00,0.10550D+00,0.10550D+00,0.10570D+00,
     *0.10890D+00,0.10900D+00,0.10930D+00,0.10970D+00,0.11280D+00,
     *0.11290D+00,0.11320D+00,0.11630D+00,0.11720D+00,0.11750D+00,
     *0.11780D+00,0.11780D+00,0.11850D+00,0.12220D+00,0.12300D+00,
     *0.12320D+00,0.12400D+00,0.12440D+00,0.12420D+00,0.12520D+00/
!-------------------------------------------------------------!
!  K-L1L2 Auger Intensity                                     !
!     Z=12-17 Table 1 of W.N.Assad, Nucl. Phys. 44(1963)399.  !
!     Z>17  Table 8. of  Table of Isotopes, Eighth  Edition.  !
!-------------------------------------------------------------!
      DATA (DFKAUG(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.67310D+00,0.63990D+00,0.61250D+00,0.59030D+00,
     *0.57340D+00,0.55400D+00,0.14560D+00,0.14210D+00,0.14050D+00,
     *0.13980D+00,0.13990D+00,0.14000D+00,0.14060D+00,0.14020D+00,
     *0.14100D+00,0.14200D+00,0.14340D+00,0.14480D+00,0.14430D+00,
     *0.14620D+00,0.15040D+00,0.15040D+00,0.14830D+00,0.14660D+00,
     *0.14300D+00,0.14480D+00,0.14620D+00,0.14840D+00,0.15030D+00,
     *0.15140D+00,0.15140D+00,0.15360D+00,0.15480D+00,0.15710D+00,
     *0.15880D+00,0.16000D+00,0.16220D+00,0.16430D+00,0.16550D+00,
     *0.16800D+00,0.16990D+00,0.17220D+00,0.17410D+00,0.17660D+00,
     *0.17940D+00,0.18260D+00,0.18540D+00,0.18800D+00,0.19220D+00,
     *0.19490D+00,0.19730D+00,0.20270D+00,0.20620D+00,0.20930D+00,
     *0.21360D+00,0.21620D+00,0.22070D+00,0.22530D+00,0.23030D+00,
     *0.23360D+00,0.23770D+00,0.24220D+00,0.24760D+00,0.25140D+00,
     *0.25610D+00,0.26030D+00,0.26770D+00,0.27200D+00,0.27430D+00,
     *0.28240D+00,0.28460D+00,0.29050D+00,0.29460D+00,0.30300D+00,
     *0.30650D+00,0.30980D+00,0.31910D+00,0.32390D+00,0.32830D+00,
     *0.33550D+00,0.33930D+00,0.34440D+00,0.35180D+00,0.35740D+00,
     *0.36190D+00,0.36810D+00,0.37330D+00,0.38070D+00,0.38390D+00/
!-------------------------------------------------------------!
!  K-L1L3 Auger Intensity                                     !
!     Z=12-17 Table 1 of W.N.Assad, Nucl. Phys. 44(1963)399.  !
!     Z>17  Table 8. of  Table of Isotopes, Eighth  Edition.  !
!-------------------------------------------------------------!
      DATA (DFKAUG(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.77300D+00,0.73570D+00,0.70340D+00,0.67800D+00,
     *0.65790D+00,0.63590D+00,0.29130D+00,0.28420D+00,0.27980D+00,
     *0.27840D+00,0.27850D+00,0.27740D+00,0.27840D+00,0.27600D+00,
     *0.27740D+00,0.27760D+00,0.27840D+00,0.27880D+00,0.27910D+00,
     *0.28230D+00,0.28570D+00,0.28490D+00,0.28200D+00,0.27490D+00,
     *0.26640D+00,0.26790D+00,0.27150D+00,0.27260D+00,0.27280D+00,
     *0.27430D+00,0.27440D+00,0.27630D+00,0.27520D+00,0.27760D+00,
     *0.27860D+00,0.27900D+00,0.28030D+00,0.28230D+00,0.28190D+00,
     *0.28440D+00,0.28540D+00,0.28670D+00,0.28770D+00,0.29010D+00,
     *0.29150D+00,0.29440D+00,0.29680D+00,0.29880D+00,0.30210D+00,
     *0.30430D+00,0.30730D+00,0.31140D+00,0.31380D+00,0.31720D+00,
     *0.32040D+00,0.32340D+00,0.32630D+00,0.33110D+00,0.33430D+00,
     *0.33770D+00,0.33990D+00,0.34470D+00,0.35000D+00,0.35140D+00,
     *0.35590D+00,0.36020D+00,0.36510D+00,0.36910D+00,0.37140D+00,
     *0.37660D+00,0.37850D+00,0.38420D+00,0.38540D+00,0.39320D+00,
     *0.39690D+00,0.39970D+00,0.40550D+00,0.41010D+00,0.41330D+00,
     *0.41900D+00,0.42180D+00,0.42550D+00,0.43170D+00,0.43580D+00,
     *0.43930D+00,0.44410D+00,0.44790D+00,0.45400D+00,0.45610D+00/
!-------------------------------------------------------------!
!  K-L2L2 Auger Intensity                                     !
!     Z=12-17 Table 1 of W.N.Assad, Nucl. Phys. 44(1963)399.  !
!     Z>17  Table 8. of  Table of Isotopes, Eighth  Edition.  !
!-------------------------------------------------------------!
      DATA (DFKAUG(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.78870D+00,0.75420D+00,0.72420D+00,0.70080D+00,
     *0.68250D+00,0.66190D+00,0.30530D+00,0.29790D+00,0.29320D+00,
     *0.29190D+00,0.29210D+00,0.29100D+00,0.29210D+00,0.28960D+00,
     *0.29100D+00,0.29110D+00,0.29210D+00,0.29240D+00,0.29280D+00,
     *0.29610D+00,0.29950D+00,0.29850D+00,0.29560D+00,0.28790D+00,
     *0.27930D+00,0.28080D+00,0.28430D+00,0.28540D+00,0.28540D+00,
     *0.28700D+00,0.28720D+00,0.28900D+00,0.28780D+00,0.29010D+00,
     *0.29110D+00,0.29140D+00,0.29260D+00,0.29450D+00,0.29400D+00,
     *0.29640D+00,0.29730D+00,0.29860D+00,0.29940D+00,0.30180D+00,
     *0.30310D+00,0.30600D+00,0.30830D+00,0.31030D+00,0.31350D+00,
     *0.31570D+00,0.31860D+00,0.32250D+00,0.32490D+00,0.32820D+00,
     *0.33140D+00,0.33430D+00,0.33710D+00,0.34190D+00,0.34490D+00,
     *0.34830D+00,0.35030D+00,0.35520D+00,0.36020D+00,0.36170D+00,
     *0.36590D+00,0.37020D+00,0.37480D+00,0.37880D+00,0.38110D+00,
     *0.38600D+00,0.38780D+00,0.39360D+00,0.39450D+00,0.40230D+00,
     *0.40590D+00,0.40840D+00,0.41420D+00,0.41860D+00,0.42160D+00,
     *0.42720D+00,0.42980D+00,0.43340D+00,0.43950D+00,0.44350D+00,
     *0.44680D+00,0.45150D+00,0.45520D+00,0.46110D+00,0.46310D+00/
!-------------------------------------------------------------!
!  K-L2L3 Auger Intensity                                     !
!     Z=12-17 Table 1 of W.N.Assad, Nucl. Phys. 44(1963)399.  !
!     Z>17  Table 8. of  Table of Isotopes, Eighth  Edition.  !
!-------------------------------------------------------------!
      DATA (DFKAUG(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.99990D+00,0.99990D+00,0.99980D+00,0.99950D+00,
     *0.99910D+00,0.99850D+00,0.64660D+00,0.63570D+00,0.62660D+00,
     *0.62310D+00,0.62280D+00,0.62000D+00,0.62010D+00,0.61470D+00,
     *0.61540D+00,0.61490D+00,0.61430D+00,0.61400D+00,0.61170D+00,
     *0.61700D+00,0.61960D+00,0.61530D+00,0.60930D+00,0.58900D+00,
     *0.57100D+00,0.57210D+00,0.57340D+00,0.57180D+00,0.57110D+00,
     *0.56840D+00,0.56710D+00,0.56620D+00,0.56340D+00,0.56140D+00,
     *0.55850D+00,0.55800D+00,0.55440D+00,0.55350D+00,0.55420D+00,
     *0.55080D+00,0.54940D+00,0.54830D+00,0.54680D+00,0.54430D+00,
     *0.54270D+00,0.54340D+00,0.54260D+00,0.54160D+00,0.54230D+00,
     *0.54260D+00,0.54270D+00,0.54280D+00,0.54340D+00,0.54400D+00,
     *0.54320D+00,0.54340D+00,0.54460D+00,0.54570D+00,0.54670D+00,
     *0.54580D+00,0.54580D+00,0.54620D+00,0.54830D+00,0.54710D+00,
     *0.54770D+00,0.54900D+00,0.55060D+00,0.55090D+00,0.54970D+00,
     *0.55070D+00,0.55130D+00,0.55280D+00,0.55120D+00,0.55380D+00,
     *0.55430D+00,0.55490D+00,0.55710D+00,0.55640D+00,0.55640D+00,
     *0.55930D+00,0.55840D+00,0.55930D+00,0.56170D+00,0.56260D+00,
     *0.56230D+00,0.56350D+00,0.56360D+00,0.56530D+00,0.56610D+00/
!-------------------------------------------------------------!
!  K-L3L3 Auger Intensity                                     !
!     Z=12-17 Table 1 of W.N.Assad, Nucl. Phys. 44(1963)399.  !
!     Z>17  Table 8. of  Table of Isotopes, Eighth  Edition.  !
!-------------------------------------------------------------!
      DATA (DFKAUG(6,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.84230D+00,0.82790D+00,0.81350D+00,
     *0.80960D+00,0.80850D+00,0.80490D+00,0.80340D+00,0.79680D+00,
     *0.79730D+00,0.79520D+00,0.79320D+00,0.79100D+00,0.78830D+00,
     *0.79170D+00,0.79150D+00,0.78620D+00,0.77700D+00,0.75390D+00,
     *0.73090D+00,0.73130D+00,0.73090D+00,0.72710D+00,0.72330D+00,
     *0.71900D+00,0.71560D+00,0.71170D+00,0.70850D+00,0.70230D+00,
     *0.69950D+00,0.69660D+00,0.69110D+00,0.68790D+00,0.68580D+00,
     *0.68110D+00,0.67700D+00,0.67400D+00,0.67040D+00,0.66560D+00,
     *0.66190D+00,0.66160D+00,0.65850D+00,0.65610D+00,0.65480D+00,
     *0.65340D+00,0.65120D+00,0.65010D+00,0.64800D+00,0.64700D+00,
     *0.64490D+00,0.64350D+00,0.64270D+00,0.64170D+00,0.64050D+00,
     *0.63920D+00,0.63690D+00,0.63470D+00,0.63400D+00,0.63250D+00,
     *0.63220D+00,0.63050D+00,0.62900D+00,0.62860D+00,0.62680D+00,
     *0.62520D+00,0.62400D+00,0.62380D+00,0.62040D+00,0.62110D+00,
     *0.61980D+00,0.61890D+00,0.61930D+00,0.61670D+00,0.61510D+00,
     *0.61640D+00,0.61410D+00,0.61340D+00,0.61390D+00,0.61340D+00,
     *0.61160D+00,0.61110D+00,0.60970D+00,0.60970D+00,0.60910D+00/
!-------------------------------------------------------------!
!  K-L1M Auger Intensity                                      !
!      Table 8. of  Table of Isotopes, Eighth  Edition.       !
!-------------------------------------------------------------!
      DATA (DFKAUG(7,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.87850D+00,0.86730D+00,0.85480D+00,
     *0.85160D+00,0.85140D+00,0.84830D+00,0.84750D+00,0.84170D+00,
     *0.84230D+00,0.84070D+00,0.83910D+00,0.83750D+00,0.83560D+00,
     *0.84090D+00,0.84210D+00,0.83820D+00,0.82950D+00,0.80640D+00,
     *0.78280D+00,0.78450D+00,0.78540D+00,0.78320D+00,0.78100D+00,
     *0.77730D+00,0.77500D+00,0.77200D+00,0.76970D+00,0.76510D+00,
     *0.76310D+00,0.76110D+00,0.75710D+00,0.75480D+00,0.75310D+00,
     *0.74980D+00,0.74720D+00,0.74490D+00,0.74240D+00,0.73880D+00,
     *0.73630D+00,0.73710D+00,0.73540D+00,0.73420D+00,0.73360D+00,
     *0.73360D+00,0.73280D+00,0.73260D+00,0.73200D+00,0.73210D+00,
     *0.73160D+00,0.73140D+00,0.73200D+00,0.73230D+00,0.73240D+00,
     *0.73250D+00,0.73160D+00,0.73080D+00,0.73130D+00,0.73090D+00,
     *0.73130D+00,0.73120D+00,0.73100D+00,0.73150D+00,0.73130D+00,
     *0.73140D+00,0.73170D+00,0.73250D+00,0.73110D+00,0.73260D+00,
     *0.73290D+00,0.73320D+00,0.73430D+00,0.73370D+00,0.73350D+00,
     *0.73560D+00,0.73480D+00,0.73540D+00,0.73660D+00,0.73740D+00,
     *0.73700D+00,0.73770D+00,0.73830D+00,0.73920D+00,0.73950D+00/
!-------------------------------------------------------------!
!  K-L2M Auger Intensity                                      !
!      Table 8. of  Table of Isotopes, Eighth  Edition.       !
!-------------------------------------------------------------!
      DATA (DFKAUG(8,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.91720D+00,0.90930D+00,0.89900D+00,
     *0.89710D+00,0.89710D+00,0.89550D+00,0.89500D+00,0.89010D+00,
     *0.89100D+00,0.89000D+00,0.88910D+00,0.88820D+00,0.88690D+00,
     *0.89430D+00,0.89670D+00,0.89390D+00,0.88580D+00,0.86220D+00,
     *0.83810D+00,0.84080D+00,0.84270D+00,0.84200D+00,0.84040D+00,
     *0.83770D+00,0.83600D+00,0.83340D+00,0.83150D+00,0.82740D+00,
     *0.82630D+00,0.82490D+00,0.82140D+00,0.81940D+00,0.81750D+00,
     *0.81490D+00,0.81240D+00,0.81030D+00,0.80800D+00,0.80510D+00,
     *0.80290D+00,0.80310D+00,0.80180D+00,0.80090D+00,0.80150D+00,
     *0.80140D+00,0.80060D+00,0.80090D+00,0.80060D+00,0.80090D+00,
     *0.80070D+00,0.80090D+00,0.80160D+00,0.80220D+00,0.80240D+00,
     *0.80260D+00,0.80200D+00,0.80170D+00,0.80220D+00,0.80200D+00,
     *0.80250D+00,0.80240D+00,0.80260D+00,0.80310D+00,0.80310D+00,
     *0.80320D+00,0.80380D+00,0.80460D+00,0.80360D+00,0.80500D+00,
     *0.80560D+00,0.80610D+00,0.80690D+00,0.80680D+00,0.80690D+00,
     *0.80880D+00,0.80850D+00,0.80910D+00,0.81050D+00,0.81140D+00,
     *0.81170D+00,0.81240D+00,0.81300D+00,0.81400D+00,0.81490D+00/
!-------------------------------------------------------------!
!  K-L3M Auger Intensity                                      !
!      Table 8. of  Table of Isotopes, Eighth  Edition.       !
!-------------------------------------------------------------!
      DATA (DFKAUG(9,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.99320D+00,0.99180D+00,0.98740D+00,
     *0.98710D+00,0.98700D+00,0.98670D+00,0.98670D+00,0.98500D+00,
     *0.98540D+00,0.98560D+00,0.98560D+00,0.98530D+00,0.98490D+00,
     *0.98670D+00,0.98710D+00,0.98600D+00,0.98350D+00,0.96720D+00,
     *0.95310D+00,0.95310D+00,0.95280D+00,0.95140D+00,0.94980D+00,
     *0.94770D+00,0.94590D+00,0.94380D+00,0.94210D+00,0.93920D+00,
     *0.93830D+00,0.93680D+00,0.93340D+00,0.93120D+00,0.92840D+00,
     *0.92600D+00,0.92300D+00,0.92040D+00,0.91770D+00,0.91460D+00,
     *0.91240D+00,0.91150D+00,0.91020D+00,0.90920D+00,0.90840D+00,
     *0.90730D+00,0.90680D+00,0.90590D+00,0.90520D+00,0.90460D+00,
     *0.90370D+00,0.90310D+00,0.90290D+00,0.90230D+00,0.90170D+00,
     *0.90090D+00,0.89930D+00,0.89810D+00,0.89710D+00,0.89590D+00,
     *0.89490D+00,0.89360D+00,0.89260D+00,0.89170D+00,0.89040D+00,
     *0.88930D+00,0.88830D+00,0.88740D+00,0.88590D+00,0.88530D+00,
     *0.88410D+00,0.88330D+00,0.88240D+00,0.88100D+00,0.88010D+00,
     *0.87960D+00,0.87850D+00,0.87740D+00,0.87680D+00,0.87660D+00,
     *0.87520D+00,0.87430D+00,0.87370D+00,0.87320D+00,0.87270D+00/
!-------------------------------------------------------------!
!  K-L1N Auger Intensity                                      !
!      Table 8. of  Table of Isotopes, Eighth  Edition.       !
!-------------------------------------------------------------!
      DATA (DFKAUG(10,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.99320D+00,0.99180D+00,0.98930D+00,
     *0.98890D+00,0.98870D+00,0.98850D+00,0.98840D+00,0.98660D+00,
     *0.98680D+00,0.98700D+00,0.98690D+00,0.98670D+00,0.98630D+00,
     *0.98840D+00,0.98900D+00,0.98810D+00,0.98580D+00,0.97190D+00,
     *0.95870D+00,0.95940D+00,0.95980D+00,0.95920D+00,0.95810D+00,
     *0.95640D+00,0.95500D+00,0.95330D+00,0.95190D+00,0.94980D+00,
     *0.94930D+00,0.94810D+00,0.94540D+00,0.94390D+00,0.94190D+00,
     *0.94010D+00,0.93790D+00,0.93600D+00,0.93410D+00,0.93190D+00,
     *0.93050D+00,0.92990D+00,0.92910D+00,0.92850D+00,0.92800D+00,
     *0.92740D+00,0.92730D+00,0.92680D+00,0.92630D+00,0.92610D+00,
     *0.92570D+00,0.92540D+00,0.92550D+00,0.92540D+00,0.92520D+00,
     *0.92480D+00,0.92380D+00,0.92340D+00,0.92300D+00,0.92240D+00,
     *0.92220D+00,0.92170D+00,0.92110D+00,0.92090D+00,0.92040D+00,
     *0.91990D+00,0.91970D+00,0.91940D+00,0.91880D+00,0.91870D+00,
     *0.91840D+00,0.91810D+00,0.91810D+00,0.91760D+00,0.91730D+00,
     *0.91750D+00,0.91720D+00,0.91700D+00,0.91680D+00,0.91710D+00,
     *0.91670D+00,0.91660D+00,0.91630D+00,0.91670D+00,0.91680D+00/
!-------------------------------------------------------------!
!  K-L2N Auger Intensity                                      !
!      Table 8. of  Table of Isotopes, Eighth  Edition.       !
!-------------------------------------------------------------!
      DATA (DFKAUG(11,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.99320D+00,0.99180D+00,0.99020D+00,
     *0.98980D+00,0.98960D+00,0.98930D+00,0.98920D+00,0.98740D+00,
     *0.98750D+00,0.98760D+00,0.98750D+00,0.98730D+00,0.98700D+00,
     *0.98920D+00,0.98990D+00,0.98910D+00,0.98690D+00,0.97600D+00,
     *0.96380D+00,0.96530D+00,0.96640D+00,0.96630D+00,0.96570D+00,
     *0.96430D+00,0.96320D+00,0.96180D+00,0.96070D+00,0.95940D+00,
     *0.95930D+00,0.95840D+00,0.95620D+00,0.95520D+00,0.95350D+00,
     *0.95220D+00,0.95070D+00,0.94950D+00,0.94830D+00,0.94670D+00,
     *0.94580D+00,0.94530D+00,0.94460D+00,0.94430D+00,0.94390D+00,
     *0.94350D+00,0.94340D+00,0.94300D+00,0.94260D+00,0.94250D+00,
     *0.94230D+00,0.94220D+00,0.94230D+00,0.94220D+00,0.94210D+00,
     *0.94180D+00,0.94120D+00,0.94100D+00,0.94090D+00,0.94050D+00,
     *0.94060D+00,0.94040D+00,0.94020D+00,0.94010D+00,0.93990D+00,
     *0.93960D+00,0.93960D+00,0.93960D+00,0.93920D+00,0.93940D+00,
     *0.93930D+00,0.93930D+00,0.93950D+00,0.93930D+00,0.93940D+00,
     *0.93950D+00,0.93970D+00,0.93980D+00,0.94000D+00,0.94020D+00,
     *0.94020D+00,0.94050D+00,0.94050D+00,0.94090D+00,0.94140D+00/
!-------------------------------------------------------------!
!  K-L3N Auger Intensity                                      !
!      Table 8. of  Table of Isotopes, Eighth  Edition.       !
!-------------------------------------------------------------!
      DATA (DFKAUG(12,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.99320D+00,0.99180D+00,0.99020D+00,
     *0.98980D+00,0.98960D+00,0.98930D+00,0.98920D+00,0.98880D+00,
     *0.98880D+00,0.98880D+00,0.98860D+00,0.98840D+00,0.98810D+00,
     *0.98990D+00,0.99050D+00,0.98990D+00,0.98810D+00,0.98410D+00,
     *0.97910D+00,0.97980D+00,0.98030D+00,0.98030D+00,0.98010D+00,
     *0.97940D+00,0.97890D+00,0.97820D+00,0.97770D+00,0.97710D+00,
     *0.97650D+00,0.97600D+00,0.97540D+00,0.97490D+00,0.97440D+00,
     *0.97390D+00,0.97340D+00,0.97300D+00,0.97250D+00,0.97190D+00,
     *0.97150D+00,0.97120D+00,0.97050D+00,0.97030D+00,0.96990D+00,
     *0.96950D+00,0.96910D+00,0.96870D+00,0.96840D+00,0.96810D+00,
     *0.96770D+00,0.96740D+00,0.96730D+00,0.96690D+00,0.96660D+00,
     *0.96640D+00,0.96600D+00,0.96580D+00,0.96560D+00,0.96510D+00,
     *0.96490D+00,0.96460D+00,0.96440D+00,0.96410D+00,0.96390D+00,
     *0.96360D+00,0.96340D+00,0.96330D+00,0.96280D+00,0.96270D+00,
     *0.96240D+00,0.96230D+00,0.96210D+00,0.96180D+00,0.96170D+00,
     *0.96150D+00,0.96130D+00,0.96110D+00,0.96100D+00,0.96080D+00,
     *0.96050D+00,0.96040D+00,0.96020D+00,0.96010D+00,0.96010D+00/
!-------------------------------------------------------------!
!  K-MM Auger Intensity                                       !
!      Table 8. of  Table of Isotopes, Eighth  Edition.       !
!-------------------------------------------------------------!
      DATA (DFKAUG(13,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.99940D+00,
     *0.99940D+00,0.99940D+00,0.99950D+00,0.99950D+00,0.99950D+00,
     *0.99950D+00,0.99960D+00,0.99960D+00,0.99960D+00,0.99950D+00,
     *0.99980D+00,0.99990D+00,0.99980D+00,0.99960D+00,0.99780D+00,
     *0.99560D+00,0.99580D+00,0.99590D+00,0.99590D+00,0.99580D+00,
     *0.99560D+00,0.99540D+00,0.99510D+00,0.99490D+00,0.99460D+00,
     *0.99440D+00,0.99420D+00,0.99400D+00,0.99370D+00,0.99350D+00,
     *0.99320D+00,0.99290D+00,0.99270D+00,0.99240D+00,0.99220D+00,
     *0.99200D+00,0.99190D+00,0.99170D+00,0.99150D+00,0.99140D+00,
     *0.99120D+00,0.99110D+00,0.99090D+00,0.99080D+00,0.99070D+00,
     *0.99060D+00,0.99050D+00,0.99040D+00,0.99020D+00,0.99020D+00,
     *0.99000D+00,0.98990D+00,0.98970D+00,0.98960D+00,0.98940D+00,
     *0.98930D+00,0.98910D+00,0.98900D+00,0.98890D+00,0.98880D+00,
     *0.98860D+00,0.98850D+00,0.98840D+00,0.98820D+00,0.98800D+00,
     *0.98790D+00,0.98780D+00,0.98770D+00,0.98760D+00,0.98750D+00,
     *0.98740D+00,0.98730D+00,0.98710D+00,0.98700D+00,0.98690D+00,
     *0.98680D+00,0.98670D+00,0.98660D+00,0.98660D+00,0.98660D+00/
!---------------------------------------------------------------------!
!  L1-MM Auger Intensity                                              !
!      Table 2. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL1AUG(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.95685D+00,0.91307D+00,
     *0.91429D+00,0.91550D+00,0.93018D+00,0.94487D+00,0.94278D+00,
     *0.94068D+00,0.94688D+00,0.95308D+00,0.95534D+00,0.95760D+00,
     *0.95061D+00,0.94363D+00,0.93993D+00,0.93623D+00,0.92272D+00,
     *0.90922D+00,0.90308D+00,0.89695D+00,0.88510D+00,0.87324D+00,
     *0.85927D+00,0.84531D+00,0.84074D+00,0.83617D+00,0.82345D+00,
     *0.81072D+00,0.79800D+00,0.78832D+00,0.77865D+00,0.76897D+00,
     *0.76315D+00,0.75732D+00,0.75150D+00,0.74568D+00,0.74571D+00,
     *0.74573D+00,0.74576D+00,0.74579D+00,0.74581D+00,0.74584D+00,
     *0.74028D+00,0.73472D+00,0.72916D+00,0.72359D+00,0.71803D+00,
     *0.71247D+00,0.70691D+00,0.70473D+00,0.70256D+00,0.70038D+00,
     *0.69820D+00,0.69602D+00,0.69385D+00,0.69167D+00,0.69359D+00,
     *0.69550D+00,0.69742D+00,0.69933D+00,0.70125D+00,0.68993D+00,
     *0.67861D+00,0.66730D+00,0.65598D+00,0.65185D+00,0.64771D+00,
     *0.64358D+00,0.63944D+00,0.63531D+00,0.63117D+00,0.62704D+00,
     *0.62291D+00,0.61877D+00,0.61464D+00,0.61050D+00,0.60637D+00,
     *0.60223D+00,0.59810D+00,0.59397D+00,0.58983D+00,0.58570D+00/
!---------------------------------------------------------------------!
!  L1-MN Auger Intensity                                              !
!      Table 2. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL1AUG(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.99903D+00,
     *0.99903D+00,0.99903D+00,0.99951D+00,0.10000D+01,0.99981D+00,
     *0.99962D+00,0.99969D+00,0.99975D+00,0.99978D+00,0.99981D+00,
     *0.99949D+00,0.99916D+00,0.99884D+00,0.99853D+00,0.99795D+00,
     *0.99737D+00,0.99340D+00,0.98944D+00,0.98832D+00,0.98721D+00,
     *0.98886D+00,0.99050D+00,0.99019D+00,0.98987D+00,0.98856D+00,
     *0.98726D+00,0.98595D+00,0.98191D+00,0.97788D+00,0.97384D+00,
     *0.97091D+00,0.96797D+00,0.96504D+00,0.96210D+00,0.96124D+00,
     *0.96039D+00,0.95953D+00,0.95867D+00,0.95782D+00,0.95696D+00,
     *0.95708D+00,0.95721D+00,0.95733D+00,0.95746D+00,0.95758D+00,
     *0.95771D+00,0.95783D+00,0.95696D+00,0.95609D+00,0.95522D+00,
     *0.95435D+00,0.95348D+00,0.95261D+00,0.95174D+00,0.94977D+00,
     *0.94780D+00,0.94582D+00,0.94385D+00,0.94188D+00,0.93893D+00,
     *0.93599D+00,0.93305D+00,0.93010D+00,0.92789D+00,0.92568D+00,
     *0.92347D+00,0.92126D+00,0.91905D+00,0.91684D+00,0.91463D+00,
     *0.91242D+00,0.91021D+00,0.90800D+00,0.90579D+00,0.90358D+00,
     *0.90137D+00,0.89916D+00,0.89695D+00,0.89474D+00,0.89253D+00/
!---------------------------------------------------------------------!
!  L1-MO Auger Intensity                                              !
!      Table 2. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL1AUG(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.99903D+00,
     *0.99903D+00,0.99903D+00,0.99951D+00,0.10000D+01,0.99981D+00,
     *0.99962D+00,0.99969D+00,0.99975D+00,0.99978D+00,0.99981D+00,
     *0.99949D+00,0.99916D+00,0.99884D+00,0.99853D+00,0.99795D+00,
     *0.99737D+00,0.99695D+00,0.99652D+00,0.99586D+00,0.99520D+00,
     *0.99441D+00,0.99361D+00,0.99292D+00,0.99223D+00,0.99086D+00,
     *0.98950D+00,0.98813D+00,0.98649D+00,0.98486D+00,0.98322D+00,
     *0.98265D+00,0.98207D+00,0.98150D+00,0.98093D+00,0.98035D+00,
     *0.97976D+00,0.97918D+00,0.97860D+00,0.97801D+00,0.97743D+00,
     *0.97716D+00,0.97690D+00,0.97663D+00,0.97637D+00,0.97610D+00,
     *0.97584D+00,0.97557D+00,0.97538D+00,0.97518D+00,0.97499D+00,
     *0.97480D+00,0.97461D+00,0.97441D+00,0.97422D+00,0.97436D+00,
     *0.97451D+00,0.97465D+00,0.97480D+00,0.97494D+00,0.97299D+00,
     *0.97103D+00,0.96907D+00,0.96712D+00,0.96663D+00,0.96614D+00,
     *0.96565D+00,0.96516D+00,0.96467D+00,0.96418D+00,0.96369D+00,
     *0.96320D+00,0.96271D+00,0.96222D+00,0.96173D+00,0.96124D+00,
     *0.96075D+00,0.96026D+00,0.95977D+00,0.95928D+00,0.95879D+00/
!---------------------------------------------------------------------!
!  L1-NN Auger Intensity                                              !
!      Table 2. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL1AUG(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.99977D+00,0.99953D+00,0.99950D+00,0.99946D+00,
     *0.99958D+00,0.99970D+00,0.99970D+00,0.99969D+00,0.99969D+00,
     *0.99968D+00,0.99968D+00,0.99924D+00,0.99880D+00,0.99836D+00,
     *0.99806D+00,0.99777D+00,0.99747D+00,0.99718D+00,0.99702D+00,
     *0.99687D+00,0.99671D+00,0.99655D+00,0.99640D+00,0.99624D+00,
     *0.99628D+00,0.99632D+00,0.99636D+00,0.99641D+00,0.99645D+00,
     *0.99649D+00,0.99653D+00,0.99636D+00,0.99618D+00,0.99601D+00,
     *0.99584D+00,0.99567D+00,0.99549D+00,0.99532D+00,0.99513D+00,
     *0.99495D+00,0.99476D+00,0.99458D+00,0.99439D+00,0.99389D+00,
     *0.99339D+00,0.99289D+00,0.99239D+00,0.99202D+00,0.99166D+00,
     *0.99129D+00,0.99092D+00,0.99055D+00,0.99019D+00,0.98982D+00,
     *0.98945D+00,0.98909D+00,0.98872D+00,0.98835D+00,0.98798D+00,
     *0.98762D+00,0.98725D+00,0.98688D+00,0.98652D+00,0.98615D+00/
!---------------------------------------------------------------------!
!  L1-NO Auger Intensity                                              !
!      Table 2. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL1AUG(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.99999D+00,0.99999D+00,0.99999D+00,0.99999D+00,
     *0.99999D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.99999D+00,0.99998D+00,0.99997D+00,
     *0.99995D+00,0.99993D+00,0.99990D+00,0.99988D+00,0.99987D+00,
     *0.99986D+00,0.99985D+00,0.99984D+00,0.99983D+00,0.99982D+00,
     *0.99982D+00,0.99983D+00,0.99983D+00,0.99984D+00,0.99984D+00,
     *0.99985D+00,0.99985D+00,0.99984D+00,0.99983D+00,0.99982D+00,
     *0.99981D+00,0.99980D+00,0.99979D+00,0.99978D+00,0.99975D+00,
     *0.99972D+00,0.99969D+00,0.99966D+00,0.99963D+00,0.99959D+00,
     *0.99955D+00,0.99951D+00,0.99947D+00,0.99942D+00,0.99938D+00,
     *0.99933D+00,0.99928D+00,0.99923D+00,0.99919D+00,0.99914D+00,
     *0.99909D+00,0.99905D+00,0.99900D+00,0.99895D+00,0.99890D+00,
     *0.99886D+00,0.99881D+00,0.99876D+00,0.99872D+00,0.99867D+00/
!---------------------------------------------------------------------!
!  L2-MM Auger Intensity                                              !
!      Table 3. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL2AUG(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.99074D+00,0.97985D+00,
     *0.97989D+00,0.97994D+00,0.98742D+00,0.99491D+00,0.99303D+00,
     *0.99115D+00,0.99234D+00,0.99352D+00,0.99447D+00,0.99542D+00,
     *0.98803D+00,0.98065D+00,0.96849D+00,0.95633D+00,0.94335D+00,
     *0.93036D+00,0.92330D+00,0.91623D+00,0.89902D+00,0.88181D+00,
     *0.87808D+00,0.87435D+00,0.86712D+00,0.85988D+00,0.84055D+00,
     *0.82122D+00,0.80189D+00,0.79148D+00,0.78108D+00,0.77067D+00,
     *0.76426D+00,0.75785D+00,0.75144D+00,0.74503D+00,0.74308D+00,
     *0.74112D+00,0.73917D+00,0.73722D+00,0.73526D+00,0.73331D+00,
     *0.73077D+00,0.72823D+00,0.72569D+00,0.72316D+00,0.72062D+00,
     *0.71808D+00,0.71554D+00,0.71442D+00,0.71330D+00,0.71218D+00,
     *0.71106D+00,0.70994D+00,0.70882D+00,0.70770D+00,0.70290D+00,
     *0.69810D+00,0.69330D+00,0.68850D+00,0.68370D+00,0.68053D+00,
     *0.67737D+00,0.67420D+00,0.67103D+00,0.65478D+00,0.63854D+00,
     *0.62229D+00,0.60605D+00,0.58980D+00,0.57356D+00,0.55731D+00,
     *0.54106D+00,0.52482D+00,0.50857D+00,0.49233D+00,0.47608D+00,
     *0.45984D+00,0.44359D+00,0.42734D+00,0.41110D+00,0.39485D+00/
!---------------------------------------------------------------------!
!  L2-MN Auger Intensity. DFL2AUG(1)+L2-MN                            !
!      Table 3. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL2AUG(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.99990D+00,
     *0.99991D+00,0.99992D+00,0.99996D+00,0.10000D+01,0.99998D+00,
     *0.99996D+00,0.99997D+00,0.99998D+00,0.99998D+00,0.99999D+00,
     *0.99999D+00,0.99999D+00,0.99964D+00,0.99930D+00,0.99866D+00,
     *0.99803D+00,0.99727D+00,0.99651D+00,0.97854D+00,0.96056D+00,
     *0.97775D+00,0.99494D+00,0.99397D+00,0.99300D+00,0.99157D+00,
     *0.99015D+00,0.98872D+00,0.98620D+00,0.98367D+00,0.98115D+00,
     *0.97799D+00,0.97484D+00,0.97168D+00,0.96853D+00,0.96774D+00,
     *0.96695D+00,0.96616D+00,0.96537D+00,0.96458D+00,0.96379D+00,
     *0.96364D+00,0.96349D+00,0.96334D+00,0.96318D+00,0.96303D+00,
     *0.96288D+00,0.96273D+00,0.96155D+00,0.96037D+00,0.95919D+00,
     *0.95800D+00,0.95682D+00,0.95564D+00,0.95446D+00,0.95194D+00,
     *0.94942D+00,0.94691D+00,0.94439D+00,0.94187D+00,0.93898D+00,
     *0.93609D+00,0.93321D+00,0.93032D+00,0.92507D+00,0.91983D+00,
     *0.91458D+00,0.90933D+00,0.90408D+00,0.89884D+00,0.89359D+00,
     *0.88834D+00,0.88310D+00,0.87785D+00,0.87260D+00,0.86735D+00,
     *0.86211D+00,0.85686D+00,0.85161D+00,0.84637D+00,0.84112D+00/
!---------------------------------------------------------------------!
!  L2-MO Auger Intensity.  DFL2AUG(2)+L2-MO                           !
!      Table 3. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL2AUG(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.99990D+00,
     *0.99991D+00,0.99992D+00,0.99996D+00,0.10000D+01,0.99998D+00,
     *0.99996D+00,0.99997D+00,0.99998D+00,0.99998D+00,0.99999D+00,
     *0.99999D+00,0.99999D+00,0.99964D+00,0.99930D+00,0.99866D+00,
     *0.99803D+00,0.99757D+00,0.99710D+00,0.98091D+00,0.96472D+00,
     *0.97996D+00,0.99521D+00,0.99424D+00,0.99327D+00,0.99182D+00,
     *0.99038D+00,0.98893D+00,0.98753D+00,0.98612D+00,0.98472D+00,
     *0.98381D+00,0.98290D+00,0.98199D+00,0.98108D+00,0.98077D+00,
     *0.98045D+00,0.98014D+00,0.97983D+00,0.97951D+00,0.97920D+00,
     *0.97868D+00,0.97816D+00,0.97764D+00,0.97712D+00,0.97660D+00,
     *0.97608D+00,0.97556D+00,0.97532D+00,0.97507D+00,0.97483D+00,
     *0.97459D+00,0.97435D+00,0.97410D+00,0.97386D+00,0.97380D+00,
     *0.97374D+00,0.97369D+00,0.97363D+00,0.97357D+00,0.97225D+00,
     *0.97092D+00,0.96960D+00,0.96828D+00,0.96659D+00,0.96490D+00,
     *0.96321D+00,0.96153D+00,0.95984D+00,0.95815D+00,0.95646D+00,
     *0.95477D+00,0.95308D+00,0.95139D+00,0.94971D+00,0.94802D+00,
     *0.94633D+00,0.94464D+00,0.94295D+00,0.94126D+00,0.93957D+00/
!---------------------------------------------------------------------!
!  L2-NN Auger Intensity. DFL2AUG(3)+L2-NN                            !
!      Table 3. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL2AUG(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.99997D+00,0.99993D+00,0.99962D+00,0.99932D+00,
     *0.99964D+00,0.99997D+00,0.99997D+00,0.99997D+00,0.99997D+00,
     *0.99998D+00,0.99998D+00,0.99981D+00,0.99964D+00,0.99947D+00,
     *0.99912D+00,0.99877D+00,0.99842D+00,0.99807D+00,0.99794D+00,
     *0.99781D+00,0.99769D+00,0.99756D+00,0.99743D+00,0.99730D+00,
     *0.99717D+00,0.99704D+00,0.99691D+00,0.99678D+00,0.99665D+00,
     *0.99652D+00,0.99639D+00,0.99636D+00,0.99634D+00,0.99631D+00,
     *0.99629D+00,0.99626D+00,0.99624D+00,0.99621D+00,0.99567D+00,
     *0.99513D+00,0.99458D+00,0.99404D+00,0.99350D+00,0.99328D+00,
     *0.99306D+00,0.99285D+00,0.99263D+00,0.99185D+00,0.99107D+00,
     *0.99029D+00,0.98950D+00,0.98872D+00,0.98794D+00,0.98716D+00,
     *0.98638D+00,0.98560D+00,0.98482D+00,0.98403D+00,0.98325D+00,
     *0.98247D+00,0.98169D+00,0.98091D+00,0.98013D+00,0.97935D+00/
!---------------------------------------------------------------------!
!  L2-NO Auger Intensity. DFL2AUG(4)+L2-NO                            !
!      Table 3. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL2AUG(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.99999D+00,0.99999D+00,
     *0.99997D+00,0.99995D+00,0.99993D+00,0.99991D+00,0.99990D+00,
     *0.99990D+00,0.99989D+00,0.99988D+00,0.99988D+00,0.99987D+00,
     *0.99987D+00,0.99988D+00,0.99988D+00,0.99989D+00,0.99989D+00,
     *0.99990D+00,0.99990D+00,0.99989D+00,0.99987D+00,0.99986D+00,
     *0.99985D+00,0.99984D+00,0.99982D+00,0.99981D+00,0.99978D+00,
     *0.99976D+00,0.99973D+00,0.99971D+00,0.99968D+00,0.99964D+00,
     *0.99959D+00,0.99955D+00,0.99951D+00,0.99942D+00,0.99932D+00,
     *0.99923D+00,0.99914D+00,0.99905D+00,0.99895D+00,0.99886D+00,
     *0.99877D+00,0.99867D+00,0.99858D+00,0.99849D+00,0.99840D+00,
     *0.99830D+00,0.99821D+00,0.99812D+00,0.99802D+00,0.99793D+00/
!---------------------------------------------------------------------!
!  L3-MM Auger Intensity                                              !
!      Table 3. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL3AUG(1,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.99074D+00,0.97985D+00,
     *0.97989D+00,0.97994D+00,0.98742D+00,0.99491D+00,0.99303D+00,
     *0.99115D+00,0.99234D+00,0.99352D+00,0.99447D+00,0.99542D+00,
     *0.98803D+00,0.98065D+00,0.96849D+00,0.95633D+00,0.94335D+00,
     *0.93036D+00,0.92330D+00,0.91623D+00,0.89902D+00,0.88181D+00,
     *0.87808D+00,0.87435D+00,0.86712D+00,0.85988D+00,0.84055D+00,
     *0.82122D+00,0.80189D+00,0.79148D+00,0.78108D+00,0.77067D+00,
     *0.76426D+00,0.75785D+00,0.75144D+00,0.74503D+00,0.74308D+00,
     *0.74112D+00,0.73917D+00,0.73722D+00,0.73526D+00,0.73331D+00,
     *0.73077D+00,0.72823D+00,0.72569D+00,0.72316D+00,0.72062D+00,
     *0.71808D+00,0.71554D+00,0.71442D+00,0.71330D+00,0.71218D+00,
     *0.71106D+00,0.70994D+00,0.70882D+00,0.70770D+00,0.70290D+00,
     *0.69810D+00,0.69330D+00,0.68850D+00,0.68370D+00,0.68053D+00,
     *0.67737D+00,0.67420D+00,0.67103D+00,0.65478D+00,0.63854D+00,
     *0.62229D+00,0.60605D+00,0.58980D+00,0.57356D+00,0.55731D+00,
     *0.54106D+00,0.52482D+00,0.50857D+00,0.49233D+00,0.47608D+00,
     *0.45984D+00,0.44359D+00,0.42734D+00,0.41110D+00,0.39485D+00/
!---------------------------------------------------------------------!
!  L3-MN Auger Intensity. DFL3AUG(1)+L3-MN                            !
!      Table 3. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL3AUG(2,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.99990D+00,
     *0.99991D+00,0.99992D+00,0.99996D+00,0.10000D+01,0.99998D+00,
     *0.99996D+00,0.99997D+00,0.99998D+00,0.99998D+00,0.99999D+00,
     *0.99999D+00,0.99999D+00,0.99964D+00,0.99930D+00,0.99866D+00,
     *0.99803D+00,0.99727D+00,0.99651D+00,0.97854D+00,0.96056D+00,
     *0.97775D+00,0.99494D+00,0.99397D+00,0.99300D+00,0.99157D+00,
     *0.99015D+00,0.98872D+00,0.98620D+00,0.98367D+00,0.98115D+00,
     *0.97799D+00,0.97484D+00,0.97168D+00,0.96853D+00,0.96774D+00,
     *0.96695D+00,0.96616D+00,0.96537D+00,0.96458D+00,0.96379D+00,
     *0.96364D+00,0.96349D+00,0.96334D+00,0.96318D+00,0.96303D+00,
     *0.96288D+00,0.96273D+00,0.96155D+00,0.96037D+00,0.95919D+00,
     *0.95800D+00,0.95682D+00,0.95564D+00,0.95446D+00,0.95194D+00,
     *0.94942D+00,0.94691D+00,0.94439D+00,0.94187D+00,0.93898D+00,
     *0.93609D+00,0.93321D+00,0.93032D+00,0.92507D+00,0.91983D+00,
     *0.91458D+00,0.90933D+00,0.90408D+00,0.89884D+00,0.89359D+00,
     *0.88834D+00,0.88310D+00,0.87785D+00,0.87260D+00,0.86735D+00,
     *0.86211D+00,0.85686D+00,0.85161D+00,0.84637D+00,0.84112D+00/
!---------------------------------------------------------------------!
!  L3-MO Auger Intensity.  DFL3AUG(2)+L3-MO                           !
!      Table 3. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL3AUG(3,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.99990D+00,
     *0.99991D+00,0.99992D+00,0.99996D+00,0.10000D+01,0.99998D+00,
     *0.99996D+00,0.99997D+00,0.99998D+00,0.99998D+00,0.99999D+00,
     *0.99999D+00,0.99999D+00,0.99964D+00,0.99930D+00,0.99866D+00,
     *0.99803D+00,0.99757D+00,0.99710D+00,0.98091D+00,0.96472D+00,
     *0.97996D+00,0.99521D+00,0.99424D+00,0.99327D+00,0.99182D+00,
     *0.99038D+00,0.98893D+00,0.98753D+00,0.98612D+00,0.98472D+00,
     *0.98381D+00,0.98290D+00,0.98199D+00,0.98108D+00,0.98077D+00,
     *0.98045D+00,0.98014D+00,0.97983D+00,0.97951D+00,0.97920D+00,
     *0.97868D+00,0.97816D+00,0.97764D+00,0.97712D+00,0.97660D+00,
     *0.97608D+00,0.97556D+00,0.97532D+00,0.97507D+00,0.97483D+00,
     *0.97459D+00,0.97435D+00,0.97410D+00,0.97386D+00,0.97380D+00,
     *0.97374D+00,0.97369D+00,0.97363D+00,0.97357D+00,0.97225D+00,
     *0.97092D+00,0.96960D+00,0.96828D+00,0.96659D+00,0.96490D+00,
     *0.96321D+00,0.96153D+00,0.95984D+00,0.95815D+00,0.95646D+00,
     *0.95477D+00,0.95308D+00,0.95139D+00,0.94971D+00,0.94802D+00,
     *0.94633D+00,0.94464D+00,0.94295D+00,0.94126D+00,0.93957D+00/
!---------------------------------------------------------------------!
!  L3-NN Auger Intensity. DFL3AUG(3)+L3-NN                            !
!      Table 3. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL3AUG(4,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.99997D+00,0.99993D+00,0.99962D+00,0.99932D+00,
     *0.99964D+00,0.99997D+00,0.99997D+00,0.99997D+00,0.99997D+00,
     *0.99998D+00,0.99998D+00,0.99981D+00,0.99964D+00,0.99947D+00,
     *0.99912D+00,0.99877D+00,0.99842D+00,0.99807D+00,0.99794D+00,
     *0.99781D+00,0.99769D+00,0.99756D+00,0.99743D+00,0.99730D+00,
     *0.99717D+00,0.99704D+00,0.99691D+00,0.99678D+00,0.99665D+00,
     *0.99652D+00,0.99639D+00,0.99636D+00,0.99634D+00,0.99631D+00,
     *0.99629D+00,0.99626D+00,0.99624D+00,0.99621D+00,0.99567D+00,
     *0.99513D+00,0.99458D+00,0.99404D+00,0.99350D+00,0.99328D+00,
     *0.99306D+00,0.99285D+00,0.99263D+00,0.99185D+00,0.99107D+00,
     *0.99029D+00,0.98950D+00,0.98872D+00,0.98794D+00,0.98716D+00,
     *0.98638D+00,0.98560D+00,0.98482D+00,0.98403D+00,0.98325D+00,
     *0.98247D+00,0.98169D+00,0.98091D+00,0.98013D+00,0.97935D+00/
!---------------------------------------------------------------------!
!  L3-NO Auger Intensity. DFL3AUG(4)+L3-NO                            !
!      Table 3. E. J. McGuire, Phy. Rev. A, 3(1971)587.               !
!      Linear interpolation is applied for element which is not       !
!      included in this table.                                        !
!---------------------------------------------------------------------!
      DATA (DFL3AUG(5,IIZ),IIZ=1,100)/
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,0.00000D+00,
     *0.00000D+00,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,0.10000D+01,
     *0.10000D+01,0.10000D+01,0.10000D+01,0.99999D+00,0.99999D+00,
     *0.99997D+00,0.99995D+00,0.99993D+00,0.99991D+00,0.99990D+00,
     *0.99990D+00,0.99989D+00,0.99988D+00,0.99988D+00,0.99987D+00,
     *0.99987D+00,0.99988D+00,0.99988D+00,0.99989D+00,0.99989D+00,
     *0.99990D+00,0.99990D+00,0.99989D+00,0.99987D+00,0.99986D+00,
     *0.99985D+00,0.99984D+00,0.99982D+00,0.99981D+00,0.99978D+00,
     *0.99976D+00,0.99973D+00,0.99971D+00,0.99968D+00,0.99964D+00,
     *0.99959D+00,0.99955D+00,0.99951D+00,0.99942D+00,0.99932D+00,
     *0.99923D+00,0.99914D+00,0.99905D+00,0.99895D+00,0.99886D+00,
     *0.99877D+00,0.99867D+00,0.99858D+00,0.99849D+00,0.99840D+00,
     *0.99830D+00,0.99821D+00,0.99812D+00,0.99802D+00,0.99793D+00/

      data NEPM/MXEPERMED*1/

      end

!------------------last line of egs5_block_data_atom.f------------------
